/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.solr.common.SolrCloseableLatch;
import org.apache.solr.common.cloud.CollectionStateWatcher;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveReplicaWatcher
implements CollectionStateWatcher {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String collection;
    private final List<String> replicaIds = new ArrayList<String>();
    private final List<String> solrCoreNames = new ArrayList<String>();
    private final List<Replica> activeReplicas = new ArrayList<Replica>();
    private int lastZkVersion = -1;
    private SolrCloseableLatch latch;

    public ActiveReplicaWatcher(String collection, List<String> replicaIds, List<String> solrCoreNames, SolrCloseableLatch latch) {
        if (replicaIds == null && solrCoreNames == null) {
            throw new IllegalArgumentException("Either replicaId or solrCoreName must be provided.");
        }
        if (replicaIds != null) {
            this.replicaIds.addAll(replicaIds);
        }
        if (solrCoreNames != null) {
            this.solrCoreNames.addAll(solrCoreNames);
        }
        if (this.replicaIds.isEmpty() && this.solrCoreNames.isEmpty()) {
            throw new IllegalArgumentException("At least one replicaId or solrCoreName must be provided");
        }
        this.collection = collection;
        this.latch = latch;
    }

    public String getCollection() {
        return this.collection;
    }

    public List<Replica> getActiveReplicas() {
        return this.activeReplicas;
    }

    public List<String> getReplicaIds() {
        return this.replicaIds;
    }

    public List<String> getSolrCoreNames() {
        return this.solrCoreNames;
    }

    public String toString() {
        return "ActiveReplicaWatcher@" + Long.toHexString(this.hashCode()) + "{collection='" + this.collection + "', replicaIds=" + this.replicaIds + ", solrCoreNames=" + this.solrCoreNames + ", latch=" + (Serializable)(this.latch != null ? Long.valueOf(this.latch.getCount()) : "null") + ",, activeReplicas=" + this.activeReplicas + "}";
    }

    @Override
    public synchronized boolean onStateChanged(Set<String> liveNodes, DocCollection collectionState) {
        if (log.isDebugEnabled()) {
            log.debug("-- onStateChanged@{}: replicaIds={}, solrCoreNames={} {}\ncollectionState {}", new Object[]{Long.toHexString(this.hashCode()), this.replicaIds, this.solrCoreNames, this.latch != null ? "\nlatch count=" + this.latch.getCount() : "", collectionState});
        }
        if (collectionState == null) {
            if (log.isDebugEnabled()) {
                log.debug("-- collection deleted, decrementing latch by {} ", (Object)(this.replicaIds.size() + this.solrCoreNames.size()));
            }
            if (this.latch != null) {
                for (int i = 0; i < this.replicaIds.size() + this.solrCoreNames.size(); ++i) {
                    this.latch.countDown();
                }
            }
            this.replicaIds.clear();
            this.solrCoreNames.clear();
            return true;
        }
        if (this.replicaIds.isEmpty() && this.solrCoreNames.isEmpty()) {
            log.debug("-- already done, exiting...");
            return true;
        }
        if (collectionState.getZNodeVersion() == this.lastZkVersion) {
            log.debug("-- spurious call with already seen zkVersion= {}, ignoring...", (Object)this.lastZkVersion);
            return false;
        }
        this.lastZkVersion = collectionState.getZNodeVersion();
        for (Slice slice : collectionState.getSlices()) {
            for (Replica replica : slice.getReplicas()) {
                if (this.replicaIds.contains(replica.getName())) {
                    if (!replica.isActive(liveNodes)) continue;
                    this.activeReplicas.add(replica);
                    this.replicaIds.remove(replica.getName());
                    if (this.latch == null) continue;
                    this.latch.countDown();
                    continue;
                }
                if (!this.solrCoreNames.contains(replica.getStr("core")) || !replica.isActive(liveNodes)) continue;
                this.activeReplicas.add(replica);
                this.solrCoreNames.remove(replica.getStr("core"));
                if (this.latch == null) continue;
                this.latch.countDown();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("-- {} now latchcount={}", (Object)Long.toHexString(this.hashCode()), (Object)this.latch.getCount());
        }
        return this.replicaIds.isEmpty() && this.solrCoreNames.isEmpty();
    }
}

