/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerSolrResponseSerializer;
import org.apache.solr.cloud.SizeLimitedDistributedMap;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedApiAsyncTracker {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static int MAX_TRACKED_ASYNC_TASKS = 10000;
    private static final String ZK_ASYNC_PERSISTENT = "/persistent";
    private static final String ZK_ASYNC_INFLIGHT = "/inflight";
    private final String persistentIdsPath;
    private final String inFlightIdsPath;
    private final SizeLimitedDistributedMap trackedAsyncTasks;
    private final InFlightJobs inFlightAsyncTasks;

    public DistributedApiAsyncTracker(SolrZkClient zkClient, String rootPath) {
        this(zkClient, rootPath, MAX_TRACKED_ASYNC_TASKS);
    }

    @VisibleForTesting
    DistributedApiAsyncTracker(SolrZkClient zkClient, String rootPath, int maxTrackedTasks) {
        this.persistentIdsPath = rootPath + ZK_ASYNC_PERSISTENT;
        this.inFlightIdsPath = rootPath + ZK_ASYNC_INFLIGHT;
        this.trackedAsyncTasks = new SizeLimitedDistributedMap(zkClient, this.persistentIdsPath, maxTrackedTasks, null);
        this.inFlightAsyncTasks = new InFlightJobs(zkClient, this.inFlightIdsPath);
    }

    public boolean createNewAsyncJobTracker(String asyncId) {
        if (asyncId == null) {
            return true;
        }
        try {
            if (!this.trackedAsyncTasks.putIfAbsent(asyncId, null)) {
                return false;
            }
            try {
                this.inFlightAsyncTasks.createNewInFlightTask(asyncId);
                return true;
            }
            catch (KeeperException.NodeExistsException nee) {
                log.warn("Async id {} was not found in trackedAsyncTasks but was still present in inFlightAsyncTasks", (Object)asyncId);
                return false;
            }
        }
        catch (KeeperException ke) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating new async job tracking " + asyncId, (Throwable)ke);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted creating new async job tracking " + asyncId, (Throwable)ie);
        }
    }

    public void setTaskRunning(String asyncId) {
        if (asyncId == null) {
            return;
        }
        try {
            this.inFlightAsyncTasks.setTaskRunning(asyncId);
        }
        catch (KeeperException ke) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error setting async task as running " + asyncId, (Throwable)ke);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted setting async task as running " + asyncId, (Throwable)ie);
        }
    }

    public void setTaskCompleted(String asyncId, OverseerSolrResponse solrResponse) {
        if (asyncId == null) {
            return;
        }
        try {
            try {
                this.trackedAsyncTasks.put(asyncId, OverseerSolrResponseSerializer.serialize(solrResponse));
            }
            finally {
                this.inFlightAsyncTasks.deleteInFlightTask(asyncId);
            }
        }
        catch (KeeperException ke) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error setting async task as completed " + asyncId, (Throwable)ke);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted setting async task as completed " + asyncId, (Throwable)ie);
        }
    }

    public void cancelAsyncId(String asyncId) {
        if (asyncId == null) {
            return;
        }
        try {
            try {
                this.trackedAsyncTasks.remove(asyncId);
            }
            finally {
                this.inFlightAsyncTasks.deleteInFlightTask(asyncId);
            }
        }
        catch (KeeperException ke) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error canceling async task " + asyncId, (Throwable)ke);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted canceling async task " + asyncId, (Throwable)ie);
        }
    }

    public Pair<RequestStatusState, OverseerSolrResponse> getAsyncTaskRequestStatus(String asyncId) throws Exception {
        OverseerSolrResponse response;
        if (asyncId == null || !this.trackedAsyncTasks.contains(asyncId)) {
            return new Pair<RequestStatusState, Object>(RequestStatusState.NOT_FOUND, null);
        }
        byte[] data = this.trackedAsyncTasks.get(asyncId);
        OverseerSolrResponse overseerSolrResponse = response = data != null ? OverseerSolrResponseSerializer.deserialize(data) : null;
        if (response != null && response.getResponse().get("failure") == null && response.getResponse().get("exception") == null) {
            return new Pair<RequestStatusState, OverseerSolrResponse>(RequestStatusState.COMPLETED, response);
        }
        InFlightJobs.State ephemeralState = this.inFlightAsyncTasks.getInFlightState(asyncId);
        if (ephemeralState == InFlightJobs.State.SUBMITTED) {
            return new Pair<RequestStatusState, Object>(RequestStatusState.SUBMITTED, null);
        }
        if (ephemeralState == InFlightJobs.State.RUNNING) {
            return new Pair<RequestStatusState, Object>(RequestStatusState.RUNNING, null);
        }
        if (response == null) {
            NamedList<Object> results = new NamedList<Object>();
            SimpleOrderedMap<Object> nl = new SimpleOrderedMap<Object>();
            nl.add("msg", "Operation (asyncId: " + asyncId + ") failed due to server restart. Please resubmit.");
            nl.add("rspCode", SolrException.ErrorCode.SERVER_ERROR.code);
            results.add("exception", nl);
            response = new OverseerSolrResponse(results);
        }
        return new Pair<RequestStatusState, OverseerSolrResponse>(RequestStatusState.FAILED, response);
    }

    public boolean deleteSingleAsyncId(String asyncId) throws Exception {
        return this.inFlightAsyncTasks.getInFlightState(asyncId) == InFlightJobs.State.NOT_FOUND && this.trackedAsyncTasks.remove(asyncId);
    }

    public void deleteAllAsyncIds() throws Exception {
        Collection<String> allTracked = this.trackedAsyncTasks.keys();
        for (String asyncId : allTracked) {
            this.deleteSingleAsyncId(asyncId);
        }
    }

    private static class InFlightJobs {
        private final SolrZkClient zkClient;
        private final String rootNodePath;

        InFlightJobs(SolrZkClient zkClient, String rootNodePath) {
            this.zkClient = zkClient;
            this.rootNodePath = rootNodePath;
            try {
                if (!zkClient.exists(rootNodePath, true).booleanValue()) {
                    zkClient.makePath(rootNodePath, new byte[0], CreateMode.PERSISTENT, true);
                }
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
            }
            catch (KeeperException ke) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating root node " + rootNodePath, (Throwable)ke);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted creating root node " + rootNodePath, (Throwable)ie);
            }
        }

        void createNewInFlightTask(String asyncId) throws KeeperException, InterruptedException {
            this.zkClient.create(this.getPath(asyncId), State.SUBMITTED.shorthand.getBytes(StandardCharsets.UTF_8), CreateMode.EPHEMERAL, true);
        }

        void setTaskRunning(String asyncId) throws KeeperException, InterruptedException {
            this.zkClient.setData(this.getPath(asyncId), State.RUNNING.shorthand.getBytes(StandardCharsets.UTF_8), true);
        }

        void deleteInFlightTask(String asyncId) throws KeeperException, InterruptedException {
            this.zkClient.delete(this.getPath(asyncId), -1, true);
        }

        State getInFlightState(String asyncId) throws KeeperException, InterruptedException {
            byte[] bytes;
            if (!this.zkClient.exists(this.getPath(asyncId), true).booleanValue()) {
                return State.NOT_FOUND;
            }
            try {
                bytes = this.zkClient.getData(this.getPath(asyncId), null, null, true);
            }
            catch (KeeperException.NoNodeException nne) {
                if (log.isInfoEnabled()) {
                    log.info("AsyncId ephemeral node " + this.getPath(asyncId) + " vanished from underneath us. Funny.");
                }
                return State.NOT_FOUND;
            }
            if (bytes == null) {
                log.error("AsyncId ephemeral node " + this.getPath(asyncId) + " has null content. This is unexpected (bug).");
                return State.NOT_FOUND;
            }
            String content = new String(bytes, StandardCharsets.UTF_8);
            if (State.RUNNING.shorthand.equals(content)) {
                return State.RUNNING;
            }
            if (State.SUBMITTED.shorthand.equals(content)) {
                return State.SUBMITTED;
            }
            log.error("AsyncId ephemeral node " + this.getPath(asyncId) + " has unexpected content \"" + content + "\". This is unexpected (bug).");
            return State.NOT_FOUND;
        }

        private String getPath(String asyncId) {
            return this.rootNodePath + "/" + asyncId;
        }

        static enum State {
            SUBMITTED("S"),
            RUNNING("R"),
            NOT_FOUND(null);

            private final String shorthand;

            private State(String shorthand) {
                this.shorthand = shorthand;
            }
        }
    }
}

