/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.ActiveReplicaWatcher;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.common.SolrCloseableLatch;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddReplicaCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionCommandContext ccc;

    public AddReplicaCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        this.addReplica(state, message, results, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ZkNodeProps> addReplica(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results, Runnable onComplete) throws IOException, InterruptedException, KeeperException {
        List createReplicas;
        block17: {
            if (log.isDebugEnabled()) {
                log.debug("addReplica() : {}", (Object)Utils.toJSONString(message));
            }
            String extCollectionName = message.getStr("collection");
            boolean followAliases = message.getBool("followAliases", false);
            String shard = message.getStr("shard");
            String collectionName = followAliases ? this.ccc.getSolrCloudManager().getClusterStateProvider().resolveSimpleAlias(extCollectionName) : extCollectionName;
            DocCollection coll = clusterState.getCollection(collectionName);
            if (coll == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collectionName + " does not exist");
            }
            if (coll.getSlice(shard) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collectionName + " shard: " + shard + " does not exist");
            }
            boolean waitForFinalState = message.getBool("waitForFinalState", false);
            boolean skipCreateReplicaInClusterState = message.getBool("skipCreateReplicaInClusterState", false);
            String asyncId = message.getStr("async");
            String node = message.getStr("node");
            String createNodeSetStr = message.getStr("createNodeSet");
            if (node != null && createNodeSetStr != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Both 'node' and 'createNodeSet' parameters cannot be specified together.");
            }
            int timeout = message.getInt("timeout", 600);
            boolean parallel = message.getBool("parallel", false);
            Replica.Type replicaType = Replica.Type.valueOf(message.getStr("type", Replica.Type.NRT.name()).toUpperCase(Locale.ROOT));
            EnumMap<Replica.Type, Integer> replicaTypesVsCount = new EnumMap<Replica.Type, Integer>(Replica.Type.class);
            replicaTypesVsCount.put(Replica.Type.NRT, message.getInt("nrtReplicas", replicaType == Replica.Type.NRT ? 1 : 0));
            replicaTypesVsCount.put(Replica.Type.TLOG, message.getInt("tlogReplicas", replicaType == Replica.Type.TLOG ? 1 : 0));
            replicaTypesVsCount.put(Replica.Type.PULL, message.getInt("pullReplicas", replicaType == Replica.Type.PULL ? 1 : 0));
            int totalReplicas = 0;
            for (Map.Entry entry : replicaTypesVsCount.entrySet()) {
                totalReplicas += ((Integer)entry.getValue()).intValue();
            }
            if (totalReplicas > 1) {
                if (node != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create " + totalReplicas + " replicas if 'name' parameter is specified");
                }
                if (message.getStr("coreNodeName") != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create " + totalReplicas + " replicas if 'coreNodeName' parameter is specified");
                }
            }
            createReplicas = AddReplicaCmd.buildReplicaPositions(this.ccc.getSolrCloudManager(), clusterState, collectionName, message, replicaTypesVsCount, this.ccc.getCoreContainer()).stream().map(replicaPosition -> AddReplicaCmd.assignReplicaDetails(this.ccc.getSolrCloudManager(), clusterState, message, replicaPosition)).collect(Collectors.toList());
            ShardHandler shardHandler = this.ccc.newShardHandler();
            ZkStateReader zkStateReader = this.ccc.getZkStateReader();
            CollectionHandlingUtils.ShardRequestTracker shardRequestTracker = CollectionHandlingUtils.asyncRequestTracker(asyncId, this.ccc);
            for (CreateReplica createReplica2 : createReplicas) {
                assert (createReplica2.coreName != null);
                ModifiableSolrParams params = this.getReplicaParams(message, collectionName, coll, skipCreateReplicaInClusterState, createReplica2);
                shardRequestTracker.sendShardRequest(createReplica2.node, params, shardHandler);
            }
            Runnable runnable = () -> {
                shardRequestTracker.processResponses(results, shardHandler, true, "ADDREPLICA failed to create replica");
                for (CreateReplica replica : createReplicas) {
                    CollectionHandlingUtils.waitForCoreNodeName(collectionName, replica.node, replica.coreName, this.ccc.getZkStateReader());
                }
                if (onComplete != null) {
                    onComplete.run();
                }
            };
            if (!parallel || waitForFinalState) {
                if (waitForFinalState) {
                    SolrCloseableLatch latch = new SolrCloseableLatch(totalReplicas, this.ccc.getCloseableToLatchOn());
                    ActiveReplicaWatcher watcher = new ActiveReplicaWatcher(collectionName, null, createReplicas.stream().map(createReplica -> createReplica.coreName).collect(Collectors.toList()), latch);
                    try {
                        zkStateReader.registerCollectionStateWatcher(collectionName, watcher);
                        runnable.run();
                        if (!latch.await(timeout, TimeUnit.SECONDS)) {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Timeout waiting " + timeout + " seconds for replica to become active.");
                        }
                        break block17;
                    }
                    finally {
                        zkStateReader.removeCollectionStateWatcher(collectionName, watcher);
                    }
                }
                runnable.run();
            } else {
                this.ccc.getExecutorService().submit(runnable);
            }
        }
        return createReplicas.stream().map(createReplica -> new ZkNodeProps("collection", createReplica.collectionName, "shard", createReplica.sliceName, "core", createReplica.coreName, "node_name", createReplica.node)).collect(Collectors.toList());
    }

    private ModifiableSolrParams getReplicaParams(ZkNodeProps message, String collectionName, DocCollection coll, boolean skipCreateReplicaInClusterState, CreateReplica createReplica) throws InterruptedException, KeeperException {
        if (!skipCreateReplicaInClusterState) {
            Map<String, Object> replicaProps = Utils.makeMap(new Object[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toLower(), "collection", collectionName, "shard", createReplica.sliceName, "core", createReplica.coreName, "state", Replica.State.DOWN.toString(), "node_name", createReplica.node, "base_url", this.ccc.getZkStateReader().getBaseUrlForNodeName(createReplica.node), "type", createReplica.replicaType.name()});
            if (createReplica.coreNodeName != null) {
                replicaProps.put("core_node_name", createReplica.coreNodeName);
            }
            CollectionHandlingUtils.addPropertyParams(message, replicaProps);
            ZkNodeProps props = new ZkNodeProps(replicaProps);
            if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.SliceAddReplica, props, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
            } else {
                try {
                    this.ccc.offerStateUpdate(props);
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Exception updating Overseer state queue", (Throwable)e);
                }
            }
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("coreNodeName", CollectionHandlingUtils.waitToSeeReplicasInState(this.ccc.getZkStateReader(), this.ccc.getSolrCloudManager().getTimeSource(), collectionName, Collections.singleton(createReplica.coreName)).get(createReplica.coreName).getName());
        String configName = coll.getConfigName();
        String routeKey = message.getStr("_route_");
        String dataDir = message.getStr("dataDir");
        String ulogDir = message.getStr("ulogDir");
        String instanceDir = message.getStr("instanceDir");
        params.set("action", CoreAdminParams.CoreAdminAction.CREATE.toString());
        params.set("name", createReplica.coreName);
        params.set("collection.configName", configName);
        params.set("collection", collectionName);
        params.set("replicaType", createReplica.replicaType.name());
        if (createReplica.sliceName != null) {
            params.set("shard", createReplica.sliceName);
        } else if (routeKey != null) {
            Collection<Slice> slices = coll.getRouter().getSearchSlicesSingle(routeKey, null, coll);
            if (slices.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active shard serving _route_=" + routeKey + " found");
            }
            params.set("shard", slices.iterator().next().getName());
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specify either 'shard' or _route_ param");
        }
        if (dataDir != null) {
            params.set("dataDir", dataDir);
        }
        if (ulogDir != null) {
            params.set("ulogDir", ulogDir);
        }
        if (instanceDir != null) {
            params.set("instanceDir", instanceDir);
        }
        if (createReplica.coreNodeName != null) {
            params.set("coreNodeName", createReplica.coreNodeName);
        }
        CollectionHandlingUtils.addPropertyParams((ZkNodeProps)coll, params);
        CollectionHandlingUtils.addPropertyParams(message, params);
        return params;
    }

    public static CreateReplica assignReplicaDetails(SolrCloudManager cloudManager, ClusterState clusterState, ZkNodeProps message, ReplicaPosition replicaPosition) {
        boolean skipCreateReplicaInClusterState = message.getBool("skipCreateReplicaInClusterState", false);
        String collection = message.getStr("collection");
        String node = replicaPosition.node;
        String shard = message.getStr("shard");
        String coreName = message.getStr("name");
        String coreNodeName = message.getStr("coreNodeName");
        Replica.Type replicaType = replicaPosition.type;
        if (StrUtils.isBlank(coreName)) {
            coreName = message.getStr("property.name");
        }
        log.info("Node Identified {} for creating new replica of shard {} for collection {}", new Object[]{node, shard, collection});
        if (!clusterState.liveNodesContain(node)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Node: " + node + " is not live");
        }
        DocCollection coll = clusterState.getCollection(collection);
        if (coreName == null) {
            coreName = Assign.buildSolrCoreName(cloudManager.getDistribStateManager(), coll, shard, replicaType);
        } else if (!skipCreateReplicaInClusterState) {
            for (Slice slice : coll.getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    String replicaCoreName = replica.getStr("core");
                    if (!coreName.equals(replicaCoreName)) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Another replica with the same core name already exists for this collection");
                }
            }
        }
        log.info("Returning CreateReplica command.");
        return new CreateReplica(collection, shard, node, replicaType, coreName, coreNodeName);
    }

    public static List<ReplicaPosition> buildReplicaPositions(SolrCloudManager cloudManager, ClusterState clusterState, String collectionName, ZkNodeProps message, EnumMap<Replica.Type, Integer> replicaTypeVsCount, CoreContainer coreContainer) throws IOException, InterruptedException {
        boolean skipCreateReplicaInClusterState = message.getBool("skipCreateReplicaInClusterState", false);
        boolean skipNodeAssignment = message.getBool("skipNodeAssignment", false);
        String sliceName = message.getStr("shard");
        DocCollection collection = clusterState.getCollection(collectionName);
        int numNrtReplicas = replicaTypeVsCount.get((Object)Replica.Type.NRT);
        int numPullReplicas = replicaTypeVsCount.get((Object)Replica.Type.PULL);
        int numTlogReplicas = replicaTypeVsCount.get((Object)Replica.Type.TLOG);
        int totalReplicas = numNrtReplicas + numPullReplicas + numTlogReplicas;
        String node = message.getStr("node");
        Object createNodeSetStr = message.get("createNodeSet");
        if (createNodeSetStr == null && node != null) {
            message.getProperties().put("createNodeSet", node);
            createNodeSetStr = node;
        }
        List<Object> positions = null;
        if (!skipCreateReplicaInClusterState && !skipNodeAssignment) {
            positions = Assign.getNodesForNewReplicas(clusterState, collection.getName(), sliceName, numNrtReplicas, numTlogReplicas, numPullReplicas, createNodeSetStr, cloudManager, coreContainer);
        }
        if (positions == null) {
            assert (node != null);
            if (node == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "A node should have been identified to add replica but wasn't. Please inform solr developers at SOLR-9317");
            }
            positions = new ArrayList(totalReplicas);
            int i = 0;
            for (Map.Entry<Replica.Type, Integer> entry : replicaTypeVsCount.entrySet()) {
                for (int j = 0; j < entry.getValue(); ++j) {
                    positions.add(new ReplicaPosition(collectionName, sliceName, i++, entry.getKey(), node));
                }
            }
        }
        return positions;
    }

    public static class CreateReplica {
        public final String collectionName;
        public final String sliceName;
        public final String node;
        public final Replica.Type replicaType;
        public String coreName;
        public String coreNodeName;

        CreateReplica(String collectionName, String sliceName, String node, Replica.Type replicaType, String coreName, String coreNodeName) {
            this.collectionName = collectionName;
            this.sliceName = sliceName;
            this.node = node;
            this.replicaType = replicaType;
            this.coreName = coreName;
            this.coreNodeName = coreNodeName;
        }
    }
}

