/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracer;
import io.opentracing.util.GlobalTracer;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.api.collections.AddReplicaCmd;
import org.apache.solr.cloud.api.collections.BackupCmd;
import org.apache.solr.cloud.api.collections.BalanceReplicasCmd;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.cloud.api.collections.CreateAliasCmd;
import org.apache.solr.cloud.api.collections.CreateCollectionCmd;
import org.apache.solr.cloud.api.collections.CreateShardCmd;
import org.apache.solr.cloud.api.collections.CreateSnapshotCmd;
import org.apache.solr.cloud.api.collections.DeleteAliasCmd;
import org.apache.solr.cloud.api.collections.DeleteBackupCmd;
import org.apache.solr.cloud.api.collections.DeleteCollectionCmd;
import org.apache.solr.cloud.api.collections.DeleteNodeCmd;
import org.apache.solr.cloud.api.collections.DeleteReplicaCmd;
import org.apache.solr.cloud.api.collections.DeleteShardCmd;
import org.apache.solr.cloud.api.collections.DeleteSnapshotCmd;
import org.apache.solr.cloud.api.collections.InstallShardDataCmd;
import org.apache.solr.cloud.api.collections.MaintainRoutedAliasCmd;
import org.apache.solr.cloud.api.collections.MigrateCmd;
import org.apache.solr.cloud.api.collections.MigrateReplicasCmd;
import org.apache.solr.cloud.api.collections.MoveReplicaCmd;
import org.apache.solr.cloud.api.collections.OverseerRoleCmd;
import org.apache.solr.cloud.api.collections.OverseerStatusCmd;
import org.apache.solr.cloud.api.collections.ReindexCollectionCmd;
import org.apache.solr.cloud.api.collections.RenameCmd;
import org.apache.solr.cloud.api.collections.ReplaceNodeCmd;
import org.apache.solr.cloud.api.collections.RestoreCmd;
import org.apache.solr.cloud.api.collections.SetAliasPropCmd;
import org.apache.solr.cloud.api.collections.SplitShardCmd;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.util.tracing.TraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollApiCmds {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static class ModifyCollectionCmd
    implements CollectionApiCommand {
        private final CollectionCommandContext ccc;

        public ModifyCollectionCmd(CollectionCommandContext ccc) {
            this.ccc = ccc;
        }

        @Override
        public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
            String collectionName = message.getStr("collection");
            String configName = (String)message.getProperties().get("collection.configName");
            if (configName != null) {
                CollectionHandlingUtils.validateConfigOrThrowSolrException(this.ccc.getCoreContainer().getConfigSetService(), configName);
                String collPath = "/collections/" + collectionName;
                if (this.ccc.getSolrCloudManager().getDistribStateManager().hasData(collPath)) {
                    this.ccc.getSolrCloudManager().getDistribStateManager().setData(collPath, Utils.toJSON(Map.of("configName", configName)), -1);
                }
            }
            if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.CollectionModifyCollection, message, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
            } else {
                this.ccc.offerStateUpdate(message);
            }
            try {
                this.ccc.getZkStateReader().waitForState(collectionName, 30L, TimeUnit.SECONDS, c -> {
                    if (c == null) {
                        return false;
                    }
                    for (Map.Entry<String, Object> updateEntry : message.getProperties().entrySet()) {
                        String updateKey = updateEntry.getKey();
                        if (updateKey.equals("collection.configName")) {
                            updateKey = "configName";
                        }
                        if (!(updateKey.equals("collection") || updateKey.equals("operation") || updateKey.equals("async") || updateEntry.getValue() == null || updateEntry.getValue().equals(c.get(updateKey)))) {
                            return false;
                        }
                        if (updateEntry.getValue() != null || !c.containsKey(updateKey)) continue;
                        return false;
                    }
                    return true;
                });
            }
            catch (InterruptedException | TimeoutException e) {
                SolrZkClient.checkInterrupted(e);
                log.debug("modifyCollection(ClusterState={}, ZkNodeProps={}, NamedList={})", new Object[]{clusterState, message, results, e});
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to modify collection", (Throwable)e);
            }
            if (message.keySet().contains("readOnly") || configName != null) {
                new ReloadCollectionCmd(this.ccc).call(clusterState, new ZkNodeProps("name", collectionName), results);
            }
        }
    }

    public static class BalanceShardsUniqueCmd
    implements CollectionApiCommand {
        private final CollectionCommandContext ccc;

        public BalanceShardsUniqueCmd(CollectionCommandContext ccc) {
            this.ccc = ccc;
        }

        @Override
        public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
            if (StrUtils.isBlank(message.getStr("collection")) || StrUtils.isBlank(message.getStr("property"))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The 'collection' and 'property' parameters are required for the BALANCESHARDUNIQUE operation, no action taken");
            }
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("operation", CollectionParams.CollectionAction.BALANCESHARDUNIQUE.toLower());
            m.putAll(message.getProperties());
            if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.BalanceShardsUnique, new ZkNodeProps(m), this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
            } else {
                this.ccc.offerStateUpdate(Utils.toJSON(m));
            }
        }
    }

    public static class DeleteReplicaPropCmd
    implements CollectionApiCommand {
        private final CollectionCommandContext ccc;

        public DeleteReplicaPropCmd(CollectionCommandContext ccc) {
            this.ccc = ccc;
        }

        @Override
        public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
            CollectionHandlingUtils.checkRequired(message, "collection", "shard", "replica", "property");
            HashMap<String, Object> propMap = new HashMap<String, Object>();
            propMap.put("operation", CollectionParams.CollectionAction.DELETEREPLICAPROP.toLower());
            propMap.putAll(message.getProperties());
            ZkNodeProps m = new ZkNodeProps(propMap);
            if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.ReplicaDeleteReplicaProperty, m, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
            } else {
                this.ccc.offerStateUpdate(m);
            }
        }
    }

    public static class AddReplicaPropCmd
    implements CollectionApiCommand {
        private final CollectionCommandContext ccc;

        public AddReplicaPropCmd(CollectionCommandContext ccc) {
            this.ccc = ccc;
        }

        @Override
        public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
            CollectionHandlingUtils.checkRequired(message, "collection", "shard", "replica", "property", "property.value");
            HashMap<String, Object> propMap = new HashMap<String, Object>();
            propMap.put("operation", CollectionParams.CollectionAction.ADDREPLICAPROP.toLower());
            propMap.putAll(message.getProperties());
            ZkNodeProps m = new ZkNodeProps(propMap);
            if (this.ccc.getDistributedClusterStateUpdater().isDistributedStateUpdate()) {
                this.ccc.getDistributedClusterStateUpdater().doSingleStateUpdate(DistributedClusterStateUpdater.MutatingCommand.ReplicaAddReplicaProperty, m, this.ccc.getSolrCloudManager(), this.ccc.getZkStateReader());
            } else {
                this.ccc.offerStateUpdate(m);
            }
        }
    }

    public static class RebalanceLeadersCmd
    implements CollectionApiCommand {
        private final CollectionCommandContext ccc;

        public RebalanceLeadersCmd(CollectionCommandContext ccc) {
            this.ccc = ccc;
        }

        @Override
        public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) throws Exception {
            CollectionHandlingUtils.checkRequired(message, "collection", "shard", "core", "election_node", "core_node_name", "node_name", "rejoinAtHead");
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("collection", message.getStr("collection"));
            params.set("shard", message.getStr("shard"));
            params.set("rejoinAtHead", message.getStr("rejoinAtHead"));
            params.set("action", CoreAdminParams.CoreAdminAction.REJOINLEADERELECTION.toString());
            params.set("core", message.getStr("core"));
            params.set("core_node_name", message.getStr("core_node_name"));
            params.set("election_node", message.getStr("election_node"));
            params.set("node_name", message.getStr("node_name"));
            String baseUrl = this.ccc.getZkStateReader().getBaseUrlForNodeName(message.getStr("node_name"));
            ShardRequest sreq = new ShardRequest();
            sreq.nodeName = message.getStr("core");
            params.set("qt", this.ccc.getAdminPath());
            sreq.purpose = 1;
            sreq.shards = new String[]{baseUrl};
            sreq.actualShards = sreq.shards;
            sreq.params = params;
            ShardHandler shardHandler = this.ccc.newShardHandler();
            shardHandler.submit(sreq, baseUrl, sreq.params);
        }
    }

    public static class ReloadCollectionCmd
    implements CollectionApiCommand {
        private final CollectionCommandContext ccc;

        public ReloadCollectionCmd(CollectionCommandContext ccc) {
            this.ccc = ccc;
        }

        @Override
        public void call(ClusterState clusterState, ZkNodeProps message, NamedList<Object> results) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", CoreAdminParams.CoreAdminAction.RELOAD.toString());
            String asyncId = message.getStr("async");
            CollectionHandlingUtils.collectionCmd(message, params, results, Replica.State.ACTIVE, asyncId, Collections.emptySet(), this.ccc, clusterState);
        }
    }

    public static class MockOperationCmd
    implements CollectionApiCommand {
        @Override
        @SuppressForbidden(reason="Needs currentTimeMillis for mock requests")
        public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws InterruptedException {
            Thread.sleep(message.getInt("sleep", 1).intValue());
            if (log.isInfoEnabled()) {
                log.info("MOCK_TASK_EXECUTED time {} data {}", (Object)System.currentTimeMillis(), (Object)Utils.toJSONString(message));
            }
            results.add("MOCK_FINISHED", System.currentTimeMillis());
        }
    }

    public static class TraceAwareCommand
    implements CollectionApiCommand {
        private final CollectionApiCommand command;
        private final Tracer tracer = GlobalTracer.get();

        public TraceAwareCommand(CollectionApiCommand command) {
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
            if (this.tracer instanceof NoopTracer) {
                this.command.call(state, message, results);
            } else {
                String collection = Optional.ofNullable(message.getStr("collection", message.getStr("name"))).orElse("unknown");
                boolean isAsync = message.containsKey("async");
                Span localSpan = TraceUtils.startCollectionApiCommandSpan(this.tracer, this.command.getClass().getSimpleName(), collection, isAsync);
                try (Scope scope = this.tracer.scopeManager().activate(localSpan);){
                    assert (scope != null);
                    this.command.call(state, message, results);
                }
                finally {
                    localSpan.finish();
                }
            }
        }
    }

    protected static class CommandMap {
        private final Map<CollectionParams.CollectionAction, CollectionApiCommand> commandMap;

        CommandMap(CollectionCommandContext ccc, OverseerNodePrioritizer overseerPrioritizer) {
            this(overseerPrioritizer, ccc);
            assert (!ccc.isDistributedCollectionAPI());
        }

        CommandMap(CollectionCommandContext ccc) {
            this(null, ccc);
            assert (ccc.isDistributedCollectionAPI());
        }

        private CommandMap(OverseerNodePrioritizer overseerPrioritizer, CollectionCommandContext ccc) {
            this.commandMap = Map.ofEntries(Map.entry(CollectionParams.CollectionAction.REPLACENODE, new ReplaceNodeCmd(ccc)), Map.entry(CollectionParams.CollectionAction.MIGRATE_REPLICAS, new MigrateReplicasCmd(ccc)), Map.entry(CollectionParams.CollectionAction.BALANCE_REPLICAS, new BalanceReplicasCmd(ccc)), Map.entry(CollectionParams.CollectionAction.DELETENODE, new DeleteNodeCmd(ccc)), Map.entry(CollectionParams.CollectionAction.BACKUP, new BackupCmd(ccc)), Map.entry(CollectionParams.CollectionAction.RESTORE, new RestoreCmd(ccc)), Map.entry(CollectionParams.CollectionAction.INSTALLSHARDDATA, new InstallShardDataCmd(ccc)), Map.entry(CollectionParams.CollectionAction.DELETEBACKUP, new DeleteBackupCmd(ccc)), Map.entry(CollectionParams.CollectionAction.CREATESNAPSHOT, new CreateSnapshotCmd(ccc)), Map.entry(CollectionParams.CollectionAction.DELETESNAPSHOT, new DeleteSnapshotCmd(ccc)), Map.entry(CollectionParams.CollectionAction.SPLITSHARD, new SplitShardCmd(ccc)), Map.entry(CollectionParams.CollectionAction.ADDROLE, new OverseerRoleCmd(ccc, CollectionParams.CollectionAction.ADDROLE, overseerPrioritizer)), Map.entry(CollectionParams.CollectionAction.REMOVEROLE, new OverseerRoleCmd(ccc, CollectionParams.CollectionAction.REMOVEROLE, overseerPrioritizer)), Map.entry(CollectionParams.CollectionAction.MOCK_COLL_TASK, new MockOperationCmd()), Map.entry(CollectionParams.CollectionAction.MOCK_SHARD_TASK, new MockOperationCmd()), Map.entry(CollectionParams.CollectionAction.MOCK_REPLICA_TASK, new MockOperationCmd()), Map.entry(CollectionParams.CollectionAction.CREATESHARD, new CreateShardCmd(ccc)), Map.entry(CollectionParams.CollectionAction.MIGRATE, new MigrateCmd(ccc)), Map.entry(CollectionParams.CollectionAction.CREATE, new CreateCollectionCmd(ccc)), Map.entry(CollectionParams.CollectionAction.MODIFYCOLLECTION, new ModifyCollectionCmd(ccc)), Map.entry(CollectionParams.CollectionAction.ADDREPLICAPROP, new AddReplicaPropCmd(ccc)), Map.entry(CollectionParams.CollectionAction.DELETEREPLICAPROP, new DeleteReplicaPropCmd(ccc)), Map.entry(CollectionParams.CollectionAction.BALANCESHARDUNIQUE, new BalanceShardsUniqueCmd(ccc)), Map.entry(CollectionParams.CollectionAction.REBALANCELEADERS, new RebalanceLeadersCmd(ccc)), Map.entry(CollectionParams.CollectionAction.RELOAD, new ReloadCollectionCmd(ccc)), Map.entry(CollectionParams.CollectionAction.DELETE, new DeleteCollectionCmd(ccc)), Map.entry(CollectionParams.CollectionAction.CREATEALIAS, new CreateAliasCmd(ccc)), Map.entry(CollectionParams.CollectionAction.DELETEALIAS, new DeleteAliasCmd(ccc)), Map.entry(CollectionParams.CollectionAction.ALIASPROP, new SetAliasPropCmd(ccc)), Map.entry(CollectionParams.CollectionAction.MAINTAINROUTEDALIAS, new MaintainRoutedAliasCmd(ccc)), Map.entry(CollectionParams.CollectionAction.OVERSEERSTATUS, new OverseerStatusCmd(ccc)), Map.entry(CollectionParams.CollectionAction.DELETESHARD, new DeleteShardCmd(ccc)), Map.entry(CollectionParams.CollectionAction.DELETEREPLICA, new DeleteReplicaCmd(ccc)), Map.entry(CollectionParams.CollectionAction.ADDREPLICA, new AddReplicaCmd(ccc)), Map.entry(CollectionParams.CollectionAction.MOVEREPLICA, new MoveReplicaCmd(ccc)), Map.entry(CollectionParams.CollectionAction.REINDEXCOLLECTION, new ReindexCollectionCmd(ccc)), Map.entry(CollectionParams.CollectionAction.RENAME, new RenameCmd(ccc)));
        }

        CollectionApiCommand getActionCommand(CollectionParams.CollectionAction action) {
            CollectionApiCommand command = this.commandMap.get((Object)action);
            if (command != null) {
                return new TraceAwareCommand(this.commandMap.get((Object)action));
            }
            return command;
        }
    }

    protected static interface CollectionApiCommand {
        public void call(ClusterState var1, ZkNodeProps var2, NamedList<Object> var3) throws Exception;
    }
}

