/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.VersionedData;
import org.apache.solr.cloud.CloudUtil;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.SplitShardCmd;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.overseer.CollectionMutator;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.overseer.ZkStateWriter;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.TestInjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaMutator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrCloudManager cloudManager;
    protected final DistribStateManager stateManager;
    protected SolrZkClient zkClient;

    public ReplicaMutator(SolrCloudManager cloudManager) {
        this.cloudManager = cloudManager;
        this.stateManager = cloudManager.getDistribStateManager();
        this.zkClient = SliceMutator.getZkClient(cloudManager);
    }

    static Replica setProperty(Replica replica, String key, String value) {
        assert (key != null);
        assert (value != null);
        if (value.equalsIgnoreCase(replica.getStr(key))) {
            return replica;
        }
        LinkedHashMap<String, Object> replicaProps = new LinkedHashMap<String, Object>(replica.getProperties());
        replicaProps.put(key, value);
        return new Replica(replica.getName(), replicaProps, replica.getCollection(), replica.getShard());
    }

    static Replica unsetProperty(Replica replica, String key) {
        assert (key != null);
        if (!replica.containsKey(key)) {
            return replica;
        }
        LinkedHashMap<String, Object> replicaProps = new LinkedHashMap<String, Object>(replica.getProperties());
        replicaProps.remove(key);
        return new Replica(replica.getName(), replicaProps, replica.getCollection(), replica.getShard());
    }

    static Replica setLeader(Replica replica) {
        return ReplicaMutator.setProperty(replica, "leader", "true");
    }

    static Replica unsetLeader(Replica replica) {
        return ReplicaMutator.unsetProperty(replica, "leader");
    }

    static Replica setState(Replica replica, String state) {
        assert (state != null);
        return ReplicaMutator.setProperty(replica, "state", state);
    }

    public ZkWriteCommand addReplicaProperty(ClusterState clusterState, ZkNodeProps message) {
        if (!(CollectionMutator.checkKeyExistence(message, "collection") && CollectionMutator.checkKeyExistence(message, "shard") && CollectionMutator.checkKeyExistence(message, "replica") && CollectionMutator.checkKeyExistence(message, "property") && CollectionMutator.checkKeyExistence(message, "property.value"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer ADDREPLICAPROP requires collection and shard and replica and property and property.value no action taken.");
        }
        String collectionName = message.getStr("collection");
        String sliceName = message.getStr("shard");
        String replicaName = message.getStr("replica");
        Object property = message.getStr("property").toLowerCase(Locale.ROOT);
        if (!((String)property).startsWith("property.")) {
            property = "property." + (String)property;
        }
        property = ((String)property).toLowerCase(Locale.ROOT);
        String propVal = message.getStr("property.value");
        String shardUnique = message.getStr("shardUnique");
        boolean isUnique = false;
        if (SliceMutator.SLICE_UNIQUE_BOOLEAN_PROPERTIES.contains(property)) {
            if (StrUtils.isNotBlank(shardUnique) && !Boolean.parseBoolean(shardUnique)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer ADDREPLICAPROP for " + (String)property + " cannot have shardUnique set to anything other than'true'. No action taken");
            }
            isUnique = true;
        } else {
            isUnique = Boolean.parseBoolean(shardUnique);
        }
        DocCollection collection = clusterState.getCollection(collectionName);
        Replica replica = collection.getReplica(replicaName);
        if (replica == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection/slice/replica " + collectionName + "/" + sliceName + "/" + replicaName + " no action taken.");
        }
        log.info("Setting property {} with value {} for collection {}", new Object[]{property, propVal, collectionName});
        log.debug("Full message: {}", (Object)message);
        if (propVal.equalsIgnoreCase(replica.getStr((String)property))) {
            return ZkStateWriter.NO_OP;
        }
        Map<String, Replica> replicas = collection.getSlice(sliceName).getReplicasCopy();
        if (!isUnique) {
            replicas.get(replicaName).getProperties().put((String)property, propVal);
        } else {
            for (Replica rep : replicas.values()) {
                if (rep.getName().equalsIgnoreCase(replicaName)) {
                    rep.getProperties().put((String)property, propVal);
                    continue;
                }
                rep.getProperties().remove(property);
            }
        }
        Slice newSlice = new Slice(sliceName, replicas, collection.getSlice(sliceName).shallowCopy(), collectionName);
        DocCollection newCollection = CollectionMutator.updateSlice(collectionName, collection, newSlice);
        return new ZkWriteCommand(collectionName, newCollection);
    }

    public ZkWriteCommand deleteReplicaProperty(ClusterState clusterState, ZkNodeProps message) {
        DocCollection collection;
        Replica replica;
        if (!(CollectionMutator.checkKeyExistence(message, "collection") && CollectionMutator.checkKeyExistence(message, "shard") && CollectionMutator.checkKeyExistence(message, "replica") && CollectionMutator.checkKeyExistence(message, "property"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Overseer DELETEREPLICAPROP requires collection and shard and replica and property no action taken.");
        }
        String collectionName = message.getStr("collection");
        String sliceName = message.getStr("shard");
        String replicaName = message.getStr("replica");
        Object property = message.getStr("property").toLowerCase(Locale.ROOT);
        if (!((String)property).startsWith("property.")) {
            property = "property." + (String)property;
        }
        if ((replica = (collection = clusterState.getCollection(collectionName)).getReplica(replicaName)) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection/slice/replica " + collectionName + "/" + sliceName + "/" + replicaName + " no action taken.");
        }
        log.info("Deleting property {} for collection: {} slice: {} replica: {}", new Object[]{property, collectionName, sliceName, replicaName});
        log.debug("Full message: {}", (Object)message);
        String curProp = replica.getStr((String)property);
        if (curProp == null) {
            return ZkStateWriter.NO_OP;
        }
        Slice slice = collection.getSlice(sliceName);
        DocCollection newCollection = SliceMutator.updateReplica(collection, slice, replicaName, ReplicaMutator.unsetProperty(replica, (String)property));
        return new ZkWriteCommand(collectionName, newCollection);
    }

    public ZkWriteCommand setState(ClusterState clusterState, ZkNodeProps message) {
        Slice slice;
        String collectionName = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        String sliceName = message.getStr("shard");
        if (collectionName == null || sliceName == null) {
            log.error("Invalid collection and slice {}", (Object)message);
            return ZkStateWriter.NO_OP;
        }
        DocCollection collection = clusterState.getCollectionOrNull(collectionName);
        Slice slice2 = slice = collection != null ? collection.getSlice(sliceName) : null;
        if (slice == null) {
            log.error("No such slice exists {}", (Object)message);
            return ZkStateWriter.NO_OP;
        }
        return this.updateState(clusterState, message);
    }

    protected ZkWriteCommand updateState(ClusterState prevState, ZkNodeProps message) {
        String cName = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        Integer numShards = message.getInt("numShards", null);
        log.debug("Update state numShards={} message={}", (Object)numShards, (Object)message);
        ArrayList<String> shardNames = new ArrayList<String>();
        ZkWriteCommand writeCommand = null;
        ClusterState newState = null;
        boolean collectionExists = prevState.hasCollection(cName);
        if (!collectionExists && numShards != null) {
            ClusterStateMutator.getShardNames(numShards, shardNames);
            HashMap<String, Object> createMsg = new HashMap<String, Object>();
            createMsg.put("name", cName);
            createMsg.putAll(message.getProperties());
            writeCommand = new ClusterStateMutator(this.cloudManager).createCollection(prevState, new ZkNodeProps(createMsg));
            DocCollection collection = writeCommand.collection;
            newState = ClusterStateMutator.newState(prevState, cName, collection);
        }
        return this.updateState(newState != null ? newState : prevState, message, cName, numShards, collectionExists);
    }

    private ZkWriteCommand updateState(ClusterState prevState, ZkNodeProps message, String collectionName, Integer numShards, boolean collectionExists) {
        HashMap<String, Replica> replicas;
        String sliceName = message.getStr("shard");
        String coreNodeName = message.getStr("core_node_name");
        boolean forceSetState = message.getBool("force_set_state", true);
        DocCollection collection = prevState.getCollectionOrNull(collectionName);
        if (!forceSetState && !CloudUtil.replicaExists(prevState, collectionName, sliceName, coreNodeName)) {
            log.info("Failed to update state because the replica does not exist, {}", (Object)message);
            return ZkStateWriter.NO_OP;
        }
        if (coreNodeName == null) {
            coreNodeName = ClusterStateMutator.getAssignedCoreNodeName(collection, message.getStr("node_name"), message.getStr("core"));
            if (coreNodeName != null) {
                log.debug("node={} is already registered", (Object)coreNodeName);
            } else {
                if (!forceSetState) {
                    log.info("Failed to update state because the replica does not exist, {}", (Object)message);
                    return ZkStateWriter.NO_OP;
                }
                coreNodeName = Assign.assignCoreNodeName(this.stateManager, collection);
            }
            message.getProperties().put("core_node_name", coreNodeName);
        }
        if (sliceName == null && (sliceName = ClusterStateMutator.getAssignedId(collection, coreNodeName)) != null) {
            log.debug("shard={} is already registered", (Object)sliceName);
        }
        if (sliceName == null) {
            if (collectionExists) {
                numShards = collection.getSlices().size();
                log.debug("Collection already exists with {} = {}", (Object)"numShards", (Object)numShards);
            }
            sliceName = Assign.assignShard(collection, numShards);
            log.info("Assigning new node to shard shard={}", (Object)sliceName);
        }
        Slice slice = collection != null ? collection.getSlice(sliceName) : null;
        Replica oldReplica = null;
        LinkedHashMap<String, Object> replicaProps = new LinkedHashMap<String, Object>(message.getProperties());
        if (slice != null && (oldReplica = slice.getReplica(coreNodeName)) != null) {
            if (oldReplica.containsKey("leader")) {
                replicaProps.put("leader", oldReplica.get("leader"));
            }
            replicaProps.put("type", oldReplica.getType().toString());
            for (Map.Entry<String, Object> ent : oldReplica.getProperties().entrySet()) {
                if (!ent.getKey().startsWith("property.")) continue;
                replicaProps.put(ent.getKey(), ent.getValue());
            }
        }
        replicaProps.remove("numShards");
        replicaProps.remove("core_node_name");
        replicaProps.remove("shard");
        replicaProps.remove("collection");
        replicaProps.remove("operation");
        Set entrySet = replicaProps.entrySet();
        ArrayList<String> removeKeys = new ArrayList<String>();
        for (Map.Entry entry : entrySet) {
            if (entry.getValue() != null) continue;
            removeKeys.add((String)entry.getKey());
        }
        for (String removeKey : removeKeys) {
            replicaProps.remove(removeKey);
        }
        replicaProps.remove("core_node_name");
        String shardRange = (String)replicaProps.remove("shard_range");
        String shardState = (String)replicaProps.remove("shard_state");
        String shardParent = (String)replicaProps.remove("shard_parent");
        String nodeName = (String)replicaProps.get("node_name");
        if (nodeName != null) {
            String baseUrl = Utils.getBaseUrlForNodeName(nodeName, this.cloudManager.getClusterStateProvider().getClusterProperty("urlScheme", "http"));
            replicaProps.put("base_url", baseUrl);
        }
        Replica replica = new Replica(coreNodeName, replicaProps, collectionName, sliceName);
        log.debug("Will update state for replica: {}", (Object)replica);
        HashMap<String, Object> sliceProps = null;
        boolean sliceChanged = true;
        if (slice != null) {
            Slice.State originalState = slice.getState();
            sliceChanged = originalState != (slice = (collection = this.checkAndCompleteShardSplit(prevState, collection, coreNodeName, sliceName, replica)).getSlice(sliceName)).getState();
            sliceProps = slice.getProperties();
            replicas = slice.getReplicasCopy();
        } else {
            replicas = CollectionUtil.newHashMap(1);
            sliceProps = new HashMap<String, String>();
            sliceProps.put("range", shardRange);
            sliceProps.put("state", shardState);
            sliceProps.put("parent", shardParent);
        }
        replicas.put(replica.getName(), replica);
        slice = new Slice(sliceName, replicas, sliceProps, collectionName);
        DocCollection newCollection = CollectionMutator.updateSlice(collectionName, collection, slice);
        log.debug("Collection is now: {}", (Object)newCollection);
        if (collection.isPerReplicaState() && oldReplica != null && !sliceChanged && !this.persistStateJson(replica, oldReplica, collection)) {
            if (log.isDebugEnabled()) {
                log.debug("state.json is not persisted slice/replica : {}/{} \n , old : {}, \n new {}", new Object[]{replica.shard, replica.name, Utils.toJSONString(oldReplica.getProperties()), Utils.toJSONString(replica.getProperties())});
            }
            return ZkWriteCommand.NO_OP;
        }
        return new ZkWriteCommand(collectionName, newCollection);
    }

    private boolean persistStateJson(Replica newReplica, Replica oldReplica, DocCollection coll) {
        if (!Objects.equals(newReplica.getBaseUrl(), oldReplica.getBaseUrl())) {
            return true;
        }
        if (!Objects.equals(newReplica.getCoreName(), oldReplica.getCoreName())) {
            return true;
        }
        if (!Objects.equals(newReplica.getNodeName(), oldReplica.getNodeName())) {
            return true;
        }
        if (!Objects.equals((Object)newReplica.getState(), (Object)oldReplica.getState())) {
            return true;
        }
        if (!Objects.equals(newReplica.getProperties().get("force_set_state"), oldReplica.getProperties().get("force_set_state"))) {
            if (log.isInfoEnabled()) {
                log.info("{} force_set_state is changed from {} -> {}", new Object[]{newReplica.name, oldReplica.getProperties().get("force_set_state"), newReplica.getProperties().get("force_set_state")});
            }
            return true;
        }
        Slice slice = coll.getSlice(newReplica.getShard());
        if (slice.getState() == Slice.State.RECOVERY) {
            if (log.isInfoEnabled()) {
                log.info("{} slice state_is_recovery", (Object)slice.getName());
            }
            return true;
        }
        if (Objects.equals(oldReplica.getProperties().get("state"), "recovering")) {
            if (log.isInfoEnabled()) {
                log.info("{} state_is_recovering", (Object)newReplica.name);
            }
            return true;
        }
        return false;
    }

    private DocCollection checkAndCompleteShardSplit(ClusterState prevState, DocCollection collection, String coreNodeName, String sliceName, Replica replica) {
        Slice slice = collection.getSlice(sliceName);
        Map<String, Object> sliceProps = slice.getProperties();
        if (slice.getState() == Slice.State.RECOVERY) {
            log.info("Shard: {} is in recovery state", (Object)sliceName);
            if (replica.getState() == Replica.State.ACTIVE) {
                log.info("Shard: {} is in recovery state and coreNodeName: {} is active", (Object)sliceName, (Object)coreNodeName);
                boolean allActive = true;
                for (Map.Entry<String, Replica> entry : slice.getReplicasMap().entrySet()) {
                    if (coreNodeName.equals(entry.getKey()) || entry.getValue().getState() == Replica.State.ACTIVE) continue;
                    allActive = false;
                    break;
                }
                if (allActive) {
                    if (log.isInfoEnabled()) {
                        log.info("Shard: {} - all {} replicas are active. Finding status of fellow sub-shards", (Object)sliceName, (Object)slice.getReplicasMap().size());
                    }
                    HashMap<String, Slice> allSlicesCopy = new HashMap<String, Slice>(collection.getSlicesMap());
                    ArrayList<Slice> subShardSlices = new ArrayList<Slice>();
                    block7: for (Map.Entry entry : allSlicesCopy.entrySet()) {
                        Slice otherSlice;
                        if (sliceName.equals(entry.getKey()) || (otherSlice = (Slice)entry.getValue()).getState() != Slice.State.RECOVERY || slice.getParent() == null || !slice.getParent().equals(otherSlice.getParent())) continue;
                        if (log.isInfoEnabled()) {
                            log.info("Shard: {} - Fellow sub-shard: {} found", (Object)sliceName, (Object)otherSlice.getName());
                        }
                        for (Map.Entry<String, Replica> sliceEntry : otherSlice.getReplicasMap().entrySet()) {
                            if (sliceEntry.getValue().getState() == Replica.State.ACTIVE) continue;
                            allActive = false;
                            break block7;
                        }
                        if (log.isInfoEnabled()) {
                            log.info("Shard: {} - Fellow sub-shard: {} has all {} replicas active", new Object[]{sliceName, otherSlice.getName(), otherSlice.getReplicasMap().size()});
                        }
                        subShardSlices.add(otherSlice);
                    }
                    if (allActive) {
                        log.info("Shard: {} - All replicas across all fellow sub-shards are now ACTIVE.", (Object)sliceName);
                        String parentSliceName = (String)sliceProps.remove("parent");
                        String shardParentZkSession = (String)sliceProps.remove("shard_parent_zk_session");
                        String shardParentNode = (String)sliceProps.remove("shard_parent_node");
                        boolean isLeaderSame = true;
                        if (shardParentNode != null && shardParentZkSession != null) {
                            log.info("Checking whether sub-shard leader node is still the same one at {} with ZK session id {}", (Object)shardParentNode, (Object)shardParentZkSession);
                            try {
                                VersionedData leaderZnode = null;
                                try {
                                    leaderZnode = this.stateManager.getData("/live_nodes/" + shardParentNode, null);
                                }
                                catch (NoSuchElementException noSuchElementException) {
                                    // empty catch block
                                }
                                if (leaderZnode == null) {
                                    log.error("The shard leader node: {} is not live anymore!", (Object)shardParentNode);
                                    isLeaderSame = false;
                                } else if (!shardParentZkSession.equals(leaderZnode.getOwner())) {
                                    log.error("The zk session id for shard leader node: {} has changed from {} to {}", new Object[]{shardParentNode, shardParentZkSession, leaderZnode.getOwner()});
                                    isLeaderSame = false;
                                }
                            }
                            catch (Exception e) {
                                log.warn("Error occurred while checking if parent shard node is still live with the same zk session id. {}", (Object)"We cannot switch shard states at this time.", (Object)e);
                                return collection;
                            }
                        }
                        HashMap<String, Object> propMap = new HashMap<String, Object>();
                        propMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
                        propMap.put("collection", collection.getName());
                        if (isLeaderSame) {
                            log.info("Sub-shard leader node is still the same one at {} with ZK session id {}. Preparing to switch shard states.", (Object)shardParentNode, (Object)shardParentZkSession);
                            propMap.put(parentSliceName, Slice.State.INACTIVE.toString());
                            propMap.put(sliceName, Slice.State.ACTIVE.toString());
                            long now = this.cloudManager.getTimeSource().getEpochTimeNs();
                            for (Slice subShardSlice : subShardSlices) {
                                propMap.put(subShardSlice.getName(), Slice.State.ACTIVE.toString());
                                String lastTimeStr = subShardSlice.getStr("stateTimestamp");
                                if (lastTimeStr != null) {
                                    long start = Long.parseLong(lastTimeStr);
                                    if (!log.isInfoEnabled()) continue;
                                    log.info("TIMINGS: Sub-shard {} recovered in {} ms", (Object)subShardSlice.getName(), (Object)TimeUnit.MILLISECONDS.convert(now - start, TimeUnit.NANOSECONDS));
                                    continue;
                                }
                                if (!log.isInfoEnabled()) continue;
                                log.info("TIMINGS Sub-shard {} not available: {}", (Object)subShardSlice.getName(), (Object)subShardSlice);
                            }
                        } else {
                            propMap.put(sliceName, Slice.State.RECOVERY_FAILED.toString());
                            for (Slice subShardSlice : subShardSlices) {
                                propMap.put(subShardSlice.getName(), Slice.State.RECOVERY_FAILED.toString());
                            }
                        }
                        TestInjection.injectSplitLatch();
                        try {
                            SplitShardCmd.unlockForSplit(this.cloudManager, collection.getName(), parentSliceName);
                        }
                        catch (Exception e) {
                            log.warn("Failed to unlock shard after {} successful split: {} / {}", new Object[]{isLeaderSame ? "" : "un", collection.getName(), parentSliceName});
                        }
                        ZkNodeProps m = new ZkNodeProps(propMap);
                        return new SliceMutator((SolrCloudManager)this.cloudManager).updateShardState((ClusterState)prevState, (ZkNodeProps)m).collection;
                    }
                }
            }
        }
        return collection;
    }
}

