/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.events.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.cloud.ClusterSingleton;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cluster.events.ClusterEvent;
import org.apache.solr.cluster.events.ClusterEventListener;
import org.apache.solr.cluster.events.NodesDownEvent;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsRepairEventListener
implements ClusterEventListener,
ClusterSingleton,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PLUGIN_NAME = "collectionsRepairListener";
    public static final int DEFAULT_WAIT_FOR_SEC = 30;
    private static final String ASYNC_ID_PREFIX = "_async_collectionsRepairListener";
    private static final AtomicInteger counter = new AtomicInteger();
    private final SolrClient solrClient;
    private final SolrCloudManager solrCloudManager;
    private final CoreContainer cc;
    private ClusterSingleton.State state = ClusterSingleton.State.STOPPED;
    private int waitForSecond = 30;
    private ScheduledThreadPoolExecutor waitForExecutor;
    private final Map<String, Long> nodeNameVsTimeRemoved = new ConcurrentHashMap<String, Long>();

    public CollectionsRepairEventListener(CoreContainer cc) {
        this.cc = cc;
        this.solrClient = cc.getSolrClientCache().getCloudSolrClient(cc.getZkController().getZkClient().getZkServerAddress());
        this.solrCloudManager = cc.getZkController().getSolrCloudManager();
    }

    @VisibleForTesting
    public void setWaitForSecond(int waitForSecond) {
        if (log.isDebugEnabled()) {
            log.debug("-- setting waitFor={}", (Object)waitForSecond);
        }
        this.waitForSecond = waitForSecond;
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public void onEvent(ClusterEvent event) {
        if (this.state != ClusterSingleton.State.RUNNING) {
            return;
        }
        switch (event.getType()) {
            case NODES_DOWN: {
                this.handleNodesDown((NodesDownEvent)event);
                break;
            }
            default: {
                log.warn("Unsupported event {}, ignoring...", (Object)event);
            }
        }
    }

    private void handleNodesDown(NodesDownEvent event) {
        Set<String> trackingKeySet = this.nodeNameVsTimeRemoved.keySet();
        trackingKeySet.removeAll(this.solrCloudManager.getClusterStateProvider().getLiveNodes());
        event.getNodeNames().forEachRemaining(lostNode -> this.nodeNameVsTimeRemoved.computeIfAbsent((String)lostNode, n -> this.solrCloudManager.getTimeSource().getTimeNs()));
    }

    private void runRepair() {
        if (this.nodeNameVsTimeRemoved.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("-- runRepair for {} lost nodes", (Object)this.nodeNameVsTimeRemoved.size());
        }
        HashSet reallyLostNodes = new HashSet();
        this.nodeNameVsTimeRemoved.forEach((lostNode, timeRemoved) -> {
            long now = this.solrCloudManager.getTimeSource().getTimeNs();
            long te = TimeUnit.SECONDS.convert(now - timeRemoved, TimeUnit.NANOSECONDS);
            if (te >= (long)this.waitForSecond) {
                reallyLostNodes.add(lostNode);
            }
        });
        if (reallyLostNodes.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("--- skipping repair, {} nodes are still in waitFor period", (Object)this.nodeNameVsTimeRemoved.size());
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("--- running repair for nodes that are still lost after waitFor: {}", reallyLostNodes);
        }
        HashMap<String, List> newPositions = new HashMap<String, List>();
        try {
            ClusterState clusterState = this.solrCloudManager.getClusterState();
            clusterState.forEachCollection(coll -> {
                HashMap<String, Map> lostReplicas = new HashMap<String, Map>();
                coll.forEachReplica((shard, replica) -> {
                    if (reallyLostNodes.contains(replica.getNodeName())) {
                        lostReplicas.computeIfAbsent((String)shard, s -> new HashMap()).computeIfAbsent(replica.type, t -> new AtomicInteger()).incrementAndGet();
                    }
                });
                Assign.AssignStrategy assignStrategy = Assign.createAssignStrategy(this.cc);
                lostReplicas.forEach((shard, types) -> {
                    Assign.AssignRequestBuilder assignRequestBuilder = new Assign.AssignRequestBuilder().forCollection(coll.getName()).forShard(Collections.singletonList(shard));
                    types.forEach((type, count) -> {
                        switch (type) {
                            case NRT: {
                                assignRequestBuilder.assignNrtReplicas(count.get());
                                break;
                            }
                            case PULL: {
                                assignRequestBuilder.assignPullReplicas(count.get());
                                break;
                            }
                            case TLOG: {
                                assignRequestBuilder.assignTlogReplicas(count.get());
                            }
                        }
                    });
                    Assign.AssignRequest assignRequest = assignRequestBuilder.build();
                    try {
                        List<ReplicaPosition> positions = assignStrategy.assign(this.solrCloudManager, assignRequest);
                        newPositions.put(coll.getName(), positions);
                    }
                    catch (Exception e) {
                        log.warn("Exception computing positions for {}/{}: {}", new Object[]{coll.getName(), shard, e});
                    }
                });
            });
        }
        catch (IOException e) {
            log.warn("Exception getting cluster state", (Throwable)e);
            return;
        }
        this.nodeNameVsTimeRemoved.keySet().removeAll(reallyLostNodes);
        ArrayList addReplicas = new ArrayList();
        newPositions.forEach((collection, positions) -> positions.forEach(position -> {
            CollectionAdminRequest.AddReplica addReplica = CollectionAdminRequest.addReplicaToShard(collection, position.shard, position.type);
            addReplica.setNode(position.node);
            addReplica.setAsyncId(ASYNC_ID_PREFIX + counter.incrementAndGet());
            addReplicas.add(addReplica);
        }));
        addReplicas.forEach(addReplica -> {
            try {
                this.solrClient.request((SolrRequest<?>)addReplica);
            }
            catch (Exception e) {
                log.warn("Exception calling ADDREPLICA {}: {}", (Object)addReplica.getParams().toQueryString(), (Object)e);
            }
        });
    }

    @Override
    public void start() throws Exception {
        this.state = ClusterSingleton.State.STARTING;
        this.waitForExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, new SolrNamedThreadFactory("collectionsRepair_waitFor"));
        this.waitForExecutor.setRemoveOnCancelPolicy(true);
        this.waitForExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.waitForExecutor.scheduleAtFixedRate(this::runRepair, 0L, this.waitForSecond, TimeUnit.SECONDS);
        this.state = ClusterSingleton.State.RUNNING;
    }

    @Override
    public ClusterSingleton.State getState() {
        return this.state;
    }

    @Override
    public void stop() {
        this.state = ClusterSingleton.State.STOPPING;
        this.waitForExecutor.shutdownNow();
        try {
            this.waitForExecutor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Failed to shut down the waitFor executor - interrupted...");
            Thread.currentThread().interrupt();
        }
        this.waitForExecutor = null;
        this.state = ClusterSingleton.State.STOPPED;
    }

    @Override
    public void close() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("-- close() called");
        }
        this.stop();
    }
}

