/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cluster.Cluster;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.Shard;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.util.Pair;

class SimpleClusterAbstractionsImpl {
    SimpleClusterAbstractionsImpl() {
    }

    static class ReplicaImpl
    implements Replica {
        private final String replicaName;
        private final String coreName;
        private final Shard shard;
        private final Replica.ReplicaType replicaType;
        private final Replica.ReplicaState replicaState;
        private final Node node;

        static Pair<Map<String, Replica>, Replica> getReplicas(Collection<org.apache.solr.common.cloud.Replica> sliceReplicas, Shard shard) {
            HashMap<String, ReplicaImpl> replicas = new HashMap<String, ReplicaImpl>();
            ReplicaImpl leader = null;
            for (org.apache.solr.common.cloud.Replica sliceReplica : sliceReplicas) {
                String replicaName = sliceReplica.getName();
                ReplicaImpl replica = new ReplicaImpl(replicaName, shard, sliceReplica);
                replicas.put(replicaName, replica);
                if (!sliceReplica.isLeader()) continue;
                leader = replica;
            }
            return new Pair(replicas, leader);
        }

        private ReplicaImpl(String replicaName, Shard shard, org.apache.solr.common.cloud.Replica sliceReplica) {
            this.replicaName = replicaName;
            this.coreName = sliceReplica.getCoreName();
            this.shard = shard;
            this.replicaType = this.translateType(sliceReplica.getType());
            this.replicaState = this.translateState(sliceReplica.getState());
            this.node = new NodeImpl(sliceReplica.getNodeName());
        }

        private Replica.ReplicaType translateType(Replica.Type type) {
            switch (type) {
                case NRT: {
                    return Replica.ReplicaType.NRT;
                }
                case TLOG: {
                    return Replica.ReplicaType.TLOG;
                }
                case PULL: {
                    return Replica.ReplicaType.PULL;
                }
            }
            throw new RuntimeException("Unexpected " + type);
        }

        private Replica.ReplicaState translateState(Replica.State state) {
            switch (state) {
                case ACTIVE: {
                    return Replica.ReplicaState.ACTIVE;
                }
                case DOWN: {
                    return Replica.ReplicaState.DOWN;
                }
                case RECOVERING: {
                    return Replica.ReplicaState.RECOVERING;
                }
                case RECOVERY_FAILED: {
                    return Replica.ReplicaState.RECOVERY_FAILED;
                }
            }
            throw new RuntimeException("Unexpected " + state);
        }

        @Override
        public Shard getShard() {
            return this.shard;
        }

        @Override
        public Replica.ReplicaType getType() {
            return this.replicaType;
        }

        @Override
        public Replica.ReplicaState getState() {
            return this.replicaState;
        }

        @Override
        public String getReplicaName() {
            return this.replicaName;
        }

        @Override
        public String getCoreName() {
            return this.coreName;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        static Replica.Type toCloudReplicaType(Replica.ReplicaType type) {
            switch (type) {
                case NRT: {
                    return Replica.Type.NRT;
                }
                case TLOG: {
                    return Replica.Type.TLOG;
                }
                case PULL: {
                    return Replica.Type.PULL;
                }
            }
            throw new IllegalArgumentException("Unknown " + type);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ReplicaImpl)) {
                return false;
            }
            ReplicaImpl other = (ReplicaImpl)obj;
            return Objects.equals(this.replicaName, other.replicaName) && Objects.equals(this.coreName, other.coreName) && Objects.equals(this.shard, other.shard) && Objects.equals((Object)this.replicaType, (Object)other.replicaType) && Objects.equals((Object)this.replicaState, (Object)other.replicaState) && Objects.equals(this.node, other.node);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.replicaName, this.coreName, this.shard, this.replicaType, this.replicaState, this.node});
        }

        public String toString() {
            return "ReplicaImpl{replicaName='" + this.replicaName + "', coreName='" + this.coreName + "', shard='" + this.shard.getShardName() + "', replicaType=" + this.replicaType + ", replicaState=" + this.replicaState + ", node='" + this.node + "'}";
        }
    }

    static class ShardImpl
    implements Shard {
        private final String shardName;
        private final SolrCollection collection;
        private final Shard.ShardState shardState;
        private final Map<String, Replica> replicas;
        private final Replica leader;

        static Map<String, Shard> getShards(SolrCollection solrCollection, Collection<Slice> slices) {
            HashMap<String, Shard> shards = new HashMap<String, Shard>();
            for (Slice slice : slices) {
                String shardName = slice.getName();
                shards.put(shardName, new ShardImpl(shardName, solrCollection, slice));
            }
            return shards;
        }

        private ShardImpl(String shardName, SolrCollection collection, Slice slice) {
            this.shardName = shardName;
            this.collection = collection;
            this.shardState = this.translateState(slice.getState());
            Pair<Map<String, Replica>, Replica> pair = ReplicaImpl.getReplicas(slice.getReplicas(), this);
            this.replicas = pair.first();
            this.leader = pair.second();
        }

        private Shard.ShardState translateState(Slice.State state) {
            switch (state) {
                case ACTIVE: {
                    return Shard.ShardState.ACTIVE;
                }
                case INACTIVE: {
                    return Shard.ShardState.INACTIVE;
                }
                case CONSTRUCTION: {
                    return Shard.ShardState.CONSTRUCTION;
                }
                case RECOVERY: {
                    return Shard.ShardState.RECOVERY;
                }
                case RECOVERY_FAILED: {
                    return Shard.ShardState.RECOVERY_FAILED;
                }
            }
            throw new RuntimeException("Unexpected " + state);
        }

        @Override
        public String getShardName() {
            return this.shardName;
        }

        @Override
        public SolrCollection getCollection() {
            return this.collection;
        }

        @Override
        public Replica getReplica(String name) {
            return this.replicas.get(name);
        }

        @Override
        public Iterator<Replica> iterator() {
            return this.replicas.values().iterator();
        }

        @Override
        public Iterable<Replica> replicas() {
            return this::iterator;
        }

        @Override
        public Replica getLeader() {
            return this.leader;
        }

        @Override
        public Shard.ShardState getState() {
            return this.shardState;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ShardImpl)) {
                return false;
            }
            ShardImpl other = (ShardImpl)obj;
            return Objects.equals(this.shardName, other.shardName) && Objects.equals(this.collection, other.collection) && Objects.equals((Object)this.shardState, (Object)other.shardState) && Objects.equals(this.replicas, other.replicas) && Objects.equals(this.leader, other.leader);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.shardName, this.collection, this.shardState});
        }

        public String toString() {
            return "ShardImpl{shardName='" + this.shardName + "', collection='" + this.collection.getName() + "', shardState=" + this.shardState + ", replicas=" + this.replicas.size() + ", leader=" + this.leader + "}";
        }
    }

    static class SolrCollectionImpl
    implements SolrCollection {
        private final String collectionName;
        private final Map<String, Shard> shards;
        private final DocCollection docCollection;

        static SolrCollection createCollectionFacade(ClusterState clusterState, String collectionName) {
            return SolrCollectionImpl.fromDocCollection(clusterState.getCollectionOrNull(collectionName));
        }

        static SolrCollection fromDocCollection(DocCollection docCollection) {
            return docCollection == null ? null : new SolrCollectionImpl(docCollection);
        }

        SolrCollectionImpl(DocCollection docCollection) {
            this.collectionName = docCollection.getName();
            this.shards = ShardImpl.getShards(this, docCollection.getSlices());
            this.docCollection = docCollection;
        }

        @Override
        public String getName() {
            return this.collectionName;
        }

        @Override
        public Shard getShard(String name) {
            return this.shards.get(name);
        }

        @Override
        public Iterator<Shard> iterator() {
            return this.shards.values().iterator();
        }

        @Override
        public Iterable<Shard> shards() {
            return this::iterator;
        }

        @Override
        public Set<String> getShardNames() {
            return this.shards.keySet();
        }

        public String toString() {
            return "SolrCollectionImpl{collectionName='" + this.collectionName + "', shards=" + this.shards.keySet() + ", docCollection=" + this.docCollection + "}";
        }

        @Override
        public String getCustomProperty(String customPropertyName) {
            return this.docCollection.getStr("property." + customPropertyName);
        }
    }

    static class NodeImpl
    implements Node {
        public final String nodeName;

        static Set<Node> getNodes(Collection<String> nodeNames) {
            return nodeNames.stream().map(NodeImpl::new).collect(Collectors.toSet());
        }

        NodeImpl(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public String getName() {
            return this.nodeName;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.getName() + ")";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NodeImpl)) {
                return false;
            }
            NodeImpl other = (NodeImpl)obj;
            return Objects.equals(this.nodeName, other.nodeName);
        }

        public int hashCode() {
            return Objects.hashCode(this.nodeName);
        }
    }

    static class ClusterImpl
    implements Cluster {
        private final Set<Node> liveNodes;
        private final Set<Node> liveNodesWithData;
        private final ClusterState clusterState;

        ClusterImpl(SolrCloudManager solrCloudManager) throws IOException {
            Set<String> liveNodes = solrCloudManager.getClusterStateProvider().getLiveNodes();
            Collection<String> liveNodesWithData = Assign.filterNonDataNodes(solrCloudManager.getDistribStateManager(), liveNodes);
            this.liveNodes = NodeImpl.getNodes(liveNodes);
            this.liveNodesWithData = liveNodesWithData.size() == liveNodes.size() ? this.liveNodes : NodeImpl.getNodes(liveNodesWithData);
            this.clusterState = solrCloudManager.getClusterState();
        }

        @Override
        public Set<Node> getLiveNodes() {
            return this.liveNodes;
        }

        @Override
        public Set<Node> getLiveDataNodes() {
            return this.liveNodesWithData;
        }

        @Override
        public SolrCollection getCollection(String collectionName) {
            return SolrCollectionImpl.createCollectionFacade(this.clusterState, collectionName);
        }

        @Override
        public Iterator<SolrCollection> iterator() {
            return this.clusterState.getCollectionsMap().values().stream().map(SolrCollectionImpl::fromDocCollection).collect(Collectors.toSet()).iterator();
        }

        @Override
        public Iterable<SolrCollection> collections() {
            return this::iterator;
        }
    }
}

