/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.snapshots;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.snapshots.CollectionSnapshotMetaData;
import org.apache.solr.core.snapshots.SolrSnapshotMetaDataManager;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrSnapshotManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String INDEX_DIR_PATH = "indexDirPath";
    public static final String GENERATION_NUM = "generation";
    public static final String SNAPSHOT_STATUS = "status";
    public static final String CREATION_DATE = "creationDate";
    public static final String SNAPSHOT_REPLICAS = "replicas";
    public static final String SNAPSHOTS_INFO = "snapshots";
    public static final String LEADER = "leader";
    public static final String SHARD_ID = "shard_id";
    public static final String FILE_LIST = "files";

    public static boolean snapshotExists(SolrZkClient zkClient, String collectionName, String commitName) throws KeeperException, InterruptedException {
        String zkPath = SolrSnapshotManager.getSnapshotMetaDataZkPath(collectionName, Optional.ofNullable(commitName));
        return zkClient.exists(zkPath, true);
    }

    public static void createCollectionLevelSnapshot(SolrZkClient zkClient, String collectionName, CollectionSnapshotMetaData meta) throws KeeperException, InterruptedException {
        String zkPath = SolrSnapshotManager.getSnapshotMetaDataZkPath(collectionName, Optional.of(meta.getName()));
        zkClient.makePath(zkPath, Utils.toJSON(meta), CreateMode.PERSISTENT, true);
    }

    public static void updateCollectionLevelSnapshot(SolrZkClient zkClient, String collectionName, CollectionSnapshotMetaData meta) throws KeeperException, InterruptedException {
        String zkPath = SolrSnapshotManager.getSnapshotMetaDataZkPath(collectionName, Optional.of(meta.getName()));
        zkClient.setData(zkPath, Utils.toJSON(meta), -1, true);
    }

    public static void deleteCollectionLevelSnapshot(SolrZkClient zkClient, String collectionName, String commitName) throws InterruptedException, KeeperException {
        String zkPath = SolrSnapshotManager.getSnapshotMetaDataZkPath(collectionName, Optional.of(commitName));
        zkClient.delete(zkPath, -1, true);
    }

    public static void cleanupCollectionLevelSnapshots(SolrZkClient zkClient, String collectionName) throws InterruptedException, KeeperException {
        block5: {
            String zkPath = SolrSnapshotManager.getSnapshotMetaDataZkPath(collectionName, Optional.empty());
            try {
                List<String> snapshots = zkClient.getChildren(zkPath, null, true);
                for (String snapshot : snapshots) {
                    String path = SolrSnapshotManager.getSnapshotMetaDataZkPath(collectionName, Optional.of(snapshot));
                    try {
                        zkClient.delete(path, -1, true);
                    }
                    catch (KeeperException ex) {
                        if (ex.code() == KeeperException.Code.NONODE) continue;
                        throw ex;
                    }
                }
                zkClient.delete(zkPath, -1, true);
            }
            catch (KeeperException ex) {
                if (ex.code() == KeeperException.Code.NONODE) break block5;
                throw ex;
            }
        }
    }

    public static Optional<CollectionSnapshotMetaData> getCollectionLevelSnapshot(SolrZkClient zkClient, String collectionName, String commitName) throws InterruptedException, KeeperException {
        String zkPath = SolrSnapshotManager.getSnapshotMetaDataZkPath(collectionName, Optional.of(commitName));
        try {
            Map data = (Map)Utils.fromJSON(zkClient.getData(zkPath, null, null, true));
            return Optional.of(new CollectionSnapshotMetaData(data));
        }
        catch (KeeperException ex) {
            if (ex.code() == KeeperException.Code.NONODE) {
                return Optional.empty();
            }
            throw ex;
        }
    }

    public static Collection<CollectionSnapshotMetaData> listSnapshots(SolrZkClient zkClient, String collectionName) throws InterruptedException, KeeperException {
        ArrayList<CollectionSnapshotMetaData> result;
        block3: {
            result = new ArrayList<CollectionSnapshotMetaData>();
            String zkPath = SolrSnapshotManager.getSnapshotMetaDataZkPath(collectionName, Optional.empty());
            try {
                List<String> snapshots = zkClient.getChildren(zkPath, null, true);
                for (String snapshot : snapshots) {
                    Optional<CollectionSnapshotMetaData> s = SolrSnapshotManager.getCollectionLevelSnapshot(zkClient, collectionName, snapshot);
                    if (!s.isPresent()) continue;
                    result.add(s.get());
                }
            }
            catch (KeeperException ex) {
                if (ex.code() == KeeperException.Code.NONODE) break block3;
                throw ex;
            }
        }
        return result;
    }

    public static void deleteSnapshotIndexFiles(SolrCore core, Directory dir, final long gen) throws IOException {
        SolrSnapshotManager.deleteSnapshotIndexFiles(core, dir, new IndexDeletionPolicy(){

            @Override
            public void onInit(List<? extends IndexCommit> commits) throws IOException {
                for (IndexCommit indexCommit : commits) {
                    if (gen != indexCommit.getGeneration()) continue;
                    if (log.isInfoEnabled()) {
                        log.info("Deleting non-snapshotted index commit with generation {}", (Object)indexCommit.getGeneration());
                    }
                    indexCommit.delete();
                }
            }

            @Override
            public void onCommit(List<? extends IndexCommit> commits) throws IOException {
            }
        });
    }

    public static void deleteNonSnapshotIndexFiles(SolrCore core, Directory dir, Collection<SolrSnapshotMetaDataManager.SnapshotMetaData> snapshots) throws IOException {
        final HashSet<Long> genNumbers = new HashSet<Long>();
        for (SolrSnapshotMetaDataManager.SnapshotMetaData m : snapshots) {
            genNumbers.add(m.getGenerationNumber());
        }
        SolrSnapshotManager.deleteSnapshotIndexFiles(core, dir, new IndexDeletionPolicy(){

            @Override
            public void onInit(List<? extends IndexCommit> commits) throws IOException {
                for (IndexCommit indexCommit : commits) {
                    if (genNumbers.contains(indexCommit.getGeneration())) continue;
                    if (log.isInfoEnabled()) {
                        log.info("Deleting non-snapshotted index commit with generation {}", (Object)indexCommit.getGeneration());
                    }
                    indexCommit.delete();
                }
            }

            @Override
            public void onCommit(List<? extends IndexCommit> commits) throws IOException {
            }
        });
    }

    private static void deleteSnapshotIndexFiles(SolrCore core, Directory dir, IndexDeletionPolicy delPolicy) throws IOException {
        IndexWriterConfig conf = core.getSolrConfig().indexConfig.toIndexWriterConfig(core);
        conf.setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        conf.setMergePolicy(NoMergePolicy.INSTANCE);
        conf.setIndexDeletionPolicy(delPolicy);
        conf.setCodec(core.getCodec());
        SolrIndexWriter iw = new SolrIndexWriter("SolrSnapshotCleaner", dir, conf);
        iw.close();
    }

    private static String getSnapshotMetaDataZkPath(String collectionName, Optional<String> commitName) {
        if (commitName.isPresent()) {
            return "/snapshots/" + collectionName + "/" + commitName.get();
        }
        return "/snapshots/" + collectionName;
    }
}

