/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.snapshots;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrSnapshotMetaDataManager {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SNAPSHOT_METADATA_DIR = "snapshot_metadata";
    public static final String SNAPSHOTS_PREFIX = "snapshots_";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;
    private static final String CODEC_NAME = "solr-snapshots";
    private long nextWriteGen;
    private final Directory dir;
    protected final Map<String, SnapshotMetaData> nameToDetailsMapping = new LinkedHashMap<String, SnapshotMetaData>();
    private final SolrCore solrCore;

    public SolrSnapshotMetaDataManager(SolrCore solrCore, Directory dir) throws IOException {
        this(solrCore, dir, IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
    }

    public SolrSnapshotMetaDataManager(SolrCore solrCore, Directory dir, IndexWriterConfig.OpenMode mode) throws IOException {
        this.solrCore = solrCore;
        this.dir = dir;
        if (mode == IndexWriterConfig.OpenMode.CREATE) {
            this.deleteSnapshotMetadataFiles();
        }
        this.loadFromSnapshotMetadataFile();
        if (mode == IndexWriterConfig.OpenMode.APPEND && this.nextWriteGen == 0L) {
            throw new IllegalStateException("no snapshots stored in this directory");
        }
    }

    public Directory getSnapshotsDir() {
        return this.dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void snapshot(String name, String indexDirPath, long gen) throws IOException {
        Objects.requireNonNull(name);
        if (log.isInfoEnabled()) {
            log.info("Creating the snapshot named {} for core {} associated with index commit with generation {} in directory {}", new Object[]{name, this.solrCore.getName(), gen, indexDirPath});
        }
        if (this.nameToDetailsMapping.containsKey(name)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "A snapshot with name " + name + " already exists");
        }
        SnapshotMetaData d = new SnapshotMetaData(name, indexDirPath, gen);
        this.nameToDetailsMapping.put(name, d);
        boolean success = false;
        try {
            this.persist();
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.release(name);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Optional<SnapshotMetaData> release(String name) throws IOException {
        SnapshotMetaData result;
        if (log.isInfoEnabled()) {
            log.info("Deleting the snapshot named {} for core {}", (Object)name, (Object)this.solrCore.getName());
        }
        if ((result = this.nameToDetailsMapping.remove(Objects.requireNonNull(name))) != null) {
            boolean success = false;
            try {
                this.persist();
                success = true;
            }
            finally {
                if (!success) {
                    this.nameToDetailsMapping.put(name, result);
                }
            }
        }
        return Optional.ofNullable(result);
    }

    public synchronized boolean isSnapshotted(long genNumber) {
        return !this.nameToDetailsMapping.isEmpty() && this.isSnapshotted(this.solrCore.getIndexDir(), genNumber);
    }

    public synchronized boolean isSnapshotted(String indexDirPath, long genNumber) {
        return !this.nameToDetailsMapping.isEmpty() && this.nameToDetailsMapping.values().stream().anyMatch(entry -> entry.getIndexDirPath().equals(indexDirPath) && entry.getGenerationNumber() == genNumber);
    }

    public synchronized Optional<SnapshotMetaData> getSnapshotMetaData(String name) {
        return Optional.ofNullable(this.nameToDetailsMapping.get(name));
    }

    public synchronized List<String> listSnapshots() {
        return new ArrayList<String>(this.nameToDetailsMapping.keySet());
    }

    public synchronized Collection<SnapshotMetaData> listSnapshotsInIndexDir(String indexDirPath) {
        return this.nameToDetailsMapping.values().stream().filter(entry -> indexDirPath.equals(entry.getIndexDirPath())).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<IndexCommit> getIndexCommitByName(String commitName) throws IOException {
        Optional<IndexCommit> result = Optional.empty();
        Optional<SnapshotMetaData> metaData = this.getSnapshotMetaData(commitName);
        if (metaData.isPresent()) {
            String indexDirPath = metaData.get().getIndexDirPath();
            long gen = metaData.get().getGenerationNumber();
            Directory d = this.solrCore.getDirectoryFactory().get(indexDirPath, DirectoryFactory.DirContext.DEFAULT, "none");
            try {
                result = DirectoryReader.listCommits(d).stream().filter(ic -> ic.getGeneration() == gen).findAny();
                if (result.isPresent()) return result;
                log.warn("Unable to find commit with generation {} in the directory {}", (Object)gen, (Object)indexDirPath);
                return result;
            }
            finally {
                this.solrCore.getDirectoryFactory().release(d);
            }
        } else {
            log.warn("Commit with name {} is not persisted for core {}", (Object)commitName, (Object)this.solrCore.getName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void persist() throws IOException {
        String fileName;
        block7: {
            IndexOutput out;
            block6: {
                fileName = SNAPSHOTS_PREFIX + this.nextWriteGen;
                out = this.dir.createOutput(fileName, IOContext.DEFAULT);
                boolean success = false;
                try {
                    CodecUtil.writeHeader(out, CODEC_NAME, 0);
                    out.writeVInt(this.nameToDetailsMapping.size());
                    for (Map.Entry<String, SnapshotMetaData> ent : this.nameToDetailsMapping.entrySet()) {
                        out.writeString(ent.getKey());
                        out.writeString(ent.getValue().getIndexDirPath());
                        out.writeVLong(ent.getValue().getGenerationNumber());
                    }
                    success = true;
                    if (success) break block6;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(out);
                        IOUtils.deleteFilesIgnoringExceptions(this.dir, fileName);
                    } else {
                        IOUtils.close(out);
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(out);
                IOUtils.deleteFilesIgnoringExceptions(this.dir, fileName);
                break block7;
            }
            IOUtils.close(out);
        }
        this.dir.sync(Collections.singletonList(fileName));
        if (this.nextWriteGen > 0L) {
            String lastSaveFile = SNAPSHOTS_PREFIX + (this.nextWriteGen - 1L);
            IOUtils.deleteFilesIgnoringExceptions(this.dir, lastSaveFile);
        }
        ++this.nextWriteGen;
    }

    private synchronized void deleteSnapshotMetadataFiles() throws IOException {
        for (String file : this.dir.listAll()) {
            if (!file.startsWith(SNAPSHOTS_PREFIX)) continue;
            this.dir.deleteFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadFromSnapshotMetadataFile() throws IOException {
        log.debug("Loading from snapshot metadata file...");
        long genLoaded = -1L;
        IOException ioe = null;
        ArrayList<String> snapshotFiles = new ArrayList<String>();
        for (String file : this.dir.listAll()) {
            if (!file.startsWith(SNAPSHOTS_PREFIX)) continue;
            long gen = Long.parseLong(file.substring(SNAPSHOTS_PREFIX.length()));
            if (genLoaded != -1L && gen <= genLoaded) continue;
            snapshotFiles.add(file);
            HashMap<String, SnapshotMetaData> snapshotMetaDataMapping = new HashMap<String, SnapshotMetaData>();
            try (IndexInput in = this.dir.openInput(file, IOContext.DEFAULT);){
                CodecUtil.checkHeader(in, CODEC_NAME, 0, 0);
                int count = in.readVInt();
                for (int i = 0; i < count; ++i) {
                    String name = in.readString();
                    String indexDirPath = in.readString();
                    long commitGen = in.readVLong();
                    snapshotMetaDataMapping.put(name, new SnapshotMetaData(name, indexDirPath, commitGen));
                }
            }
            genLoaded = gen;
            this.nameToDetailsMapping.clear();
            this.nameToDetailsMapping.putAll(snapshotMetaDataMapping);
        }
        if (genLoaded == -1L) {
            if (ioe != null) {
                throw ioe;
            }
        } else {
            if (snapshotFiles.size() > 1) {
                String curFileName = SNAPSHOTS_PREFIX + genLoaded;
                for (String file : snapshotFiles) {
                    if (curFileName.equals(file)) continue;
                    IOUtils.deleteFilesIgnoringExceptions(this.dir, file);
                }
            }
            this.nextWriteGen = 1L + genLoaded;
        }
    }

    public static class SnapshotMetaData {
        private String name;
        private String indexDirPath;
        private long generationNumber;

        public SnapshotMetaData(String name, String indexDirPath, long generationNumber) {
            this.name = name;
            this.indexDirPath = indexDirPath;
            this.generationNumber = generationNumber;
        }

        public String getName() {
            return this.name;
        }

        public String getIndexDirPath() {
            return this.indexDirPath;
        }

        public long getGenerationNumber() {
            return this.generationNumber;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SnapshotMetaData[name=");
            builder.append(this.name);
            builder.append(", indexDirPath=");
            builder.append(this.indexDirPath);
            builder.append(", generation=");
            builder.append(this.generationNumber);
            builder.append("]");
            return builder.toString();
        }
    }
}

