/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;

public abstract class AnalysisRequestHandlerBase
extends RequestHandlerBase {
    public static final Set<BytesRef> EMPTY_BYTES_SET = Collections.emptySet();
    static Map<String, String> ATTRIBUTE_MAPPING = Map.of(OffsetAttribute.class.getName() + "#startOffset", "start", OffsetAttribute.class.getName() + "#endOffset", "end", TypeAttribute.class.getName() + "#type", "type", TokenTrackingAttribute.class.getName() + "#position", "position", TokenTrackingAttribute.class.getName() + "#positionHistory", "positionHistory");

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        rsp.add("analysis", this.doAnalysis(req));
    }

    protected abstract NamedList doAnalysis(SolrQueryRequest var1) throws Exception;

    protected NamedList<? extends Object> analyzeValue(String value, AnalysisContext context) {
        Analyzer analyzer = context.getAnalyzer();
        if (!TokenizerChain.class.isInstance(analyzer)) {
            NamedList<List<NamedList>> namedList;
            block30: {
                TokenStream tokenStream = analyzer.tokenStream(context.getFieldName(), value);
                try {
                    NamedList<List<NamedList>> namedList2 = new NamedList<List<NamedList>>();
                    namedList2.add(tokenStream.getClass().getName(), this.convertTokensToNamedLists(this.analyzeTokenStream(tokenStream), context));
                    namedList = namedList2;
                    if (tokenStream == null) break block30;
                }
                catch (Throwable namedList2) {
                    try {
                        if (tokenStream != null) {
                            try {
                                tokenStream.close();
                            }
                            catch (Throwable throwable) {
                                namedList2.addSuppressed(throwable);
                            }
                        }
                        throw namedList2;
                    }
                    catch (IOException e) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                    }
                }
                tokenStream.close();
            }
            return namedList;
        }
        TokenizerChain tokenizerChain = (TokenizerChain)analyzer;
        CharFilterFactory[] cfiltfacs = tokenizerChain.getCharFilterFactories();
        TokenizerFactory tfac = tokenizerChain.getTokenizerFactory();
        TokenFilterFactory[] filtfacs = tokenizerChain.getTokenFilterFactories();
        NamedList<Object> namedList = new NamedList<Object>();
        if (0 < cfiltfacs.length) {
            String source = value;
            for (CharFilterFactory cfiltfac : cfiltfacs) {
                try (StringReader sreader = new StringReader(source);
                     Reader reader = cfiltfac.create(sreader);){
                    source = this.writeCharStream(namedList, reader);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        TokenStream tokenStream = tfac.create();
        ((Tokenizer)tokenStream).setReader(tokenizerChain.initReader(null, new StringReader(value)));
        List<AttributeSource> tokens = this.analyzeTokenStream(tokenStream);
        namedList.add(tokenStream.getClass().getName(), this.convertTokensToNamedLists(tokens, context));
        ListBasedTokenStream listBasedTokenStream = new ListBasedTokenStream(tokenStream, tokens);
        for (TokenFilterFactory tokenFilterFactory : filtfacs) {
            for (AttributeSource tok : tokens) {
                tok.getAttribute(TokenTrackingAttribute.class).freezeStage();
            }
            tokenStream = tokenFilterFactory.create(listBasedTokenStream);
            tokens = this.analyzeTokenStream(tokenStream);
            namedList.add(tokenStream.getClass().getName(), this.convertTokensToNamedLists(tokens, context));
            try {
                listBasedTokenStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            listBasedTokenStream = new ListBasedTokenStream(listBasedTokenStream, tokens);
        }
        try {
            listBasedTokenStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return namedList;
    }

    protected Set<BytesRef> getQueryTokenSet(String query, Analyzer analyzer) {
        HashSet<BytesRef> hashSet;
        block9: {
            TokenStream tokenStream = analyzer.tokenStream("", query);
            try {
                HashSet<BytesRef> tokens = new HashSet<BytesRef>();
                TermToBytesRefAttribute bytesAtt = tokenStream.getAttribute(TermToBytesRefAttribute.class);
                tokenStream.reset();
                while (tokenStream.incrementToken()) {
                    tokens.add(BytesRef.deepCopyOf(bytesAtt.getBytesRef()));
                }
                tokenStream.end();
                hashSet = tokens;
                if (tokenStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (tokenStream != null) {
                        try {
                            tokenStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Error occurred while iterating over tokenstream", ioe);
                }
            }
            tokenStream.close();
        }
        return hashSet;
    }

    private List<AttributeSource> analyzeTokenStream(TokenStream tokenStream) {
        ArrayList<AttributeSource> tokens = new ArrayList<AttributeSource>();
        PositionIncrementAttribute posIncrAtt = tokenStream.addAttribute(PositionIncrementAttribute.class);
        TokenTrackingAttribute trackerAtt = tokenStream.addAttribute(TokenTrackingAttribute.class);
        tokenStream.addAttribute(OffsetAttribute.class);
        tokenStream.addAttribute(TypeAttribute.class);
        try {
            tokenStream.reset();
            int position = 0;
            while (tokenStream.incrementToken()) {
                trackerAtt.setActPosition(position += posIncrAtt.getPositionIncrement());
                tokens.add(tokenStream.cloneAttributes());
            }
            tokenStream.end();
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException("Error occurred while iterating over tokenstream", ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(tokenStream);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(tokenStream);
        return tokens;
    }

    private List<NamedList> convertTokensToNamedLists(List<AttributeSource> tokenList, AnalysisContext context) {
        ArrayList<NamedList> tokensNamedLists = new ArrayList<NamedList>();
        FieldType fieldType = context.getFieldType();
        AttributeSource[] tokens = tokenList.toArray(new AttributeSource[0]);
        ArrayUtil.timSort(tokens, new Comparator<AttributeSource>(){

            @Override
            public int compare(AttributeSource a, AttributeSource b) {
                return this.arrayCompare(a.getAttribute(TokenTrackingAttribute.class).getPositions(), b.getAttribute(TokenTrackingAttribute.class).getPositions());
            }

            private int arrayCompare(int[] a, int[] b) {
                int stop = Math.min(a.length, b.length);
                for (int p = 0; p < stop; ++p) {
                    int diff = a[p] - b[p];
                    if (diff == 0) continue;
                    return diff;
                }
                return a.length - b.length;
            }
        });
        for (int i = 0; i < tokens.length; ++i) {
            String rawText;
            BytesRef rawBytes;
            AttributeSource token = tokens[i];
            final SimpleOrderedMap<Object> tokenNamedList = new SimpleOrderedMap<Object>();
            if (token.hasAttribute(BytesTermAttribute.class)) {
                BytesTermAttribute bytesAtt = token.getAttribute(BytesTermAttribute.class);
                rawBytes = bytesAtt.getBytesRef();
            } else {
                TermToBytesRefAttribute termAtt = token.getAttribute(TermToBytesRefAttribute.class);
                rawBytes = termAtt.getBytesRef();
            }
            String text = fieldType.indexedToReadable(rawBytes, new CharsRefBuilder()).toString();
            tokenNamedList.add("text", text);
            if (token.hasAttribute(CharTermAttribute.class) && !(rawText = token.getAttribute(CharTermAttribute.class).toString()).equals(text)) {
                tokenNamedList.add("raw_text", rawText);
            }
            tokenNamedList.add("raw_bytes", rawBytes.toString());
            if (context.getTermsToMatch().contains(rawBytes)) {
                tokenNamedList.add("match", true);
            }
            token.reflectWith(new AttributeReflector(){

                @Override
                public void reflect(Class<? extends Attribute> attClass, String key, Object value) {
                    if (TermToBytesRefAttribute.class.isAssignableFrom(attClass)) {
                        return;
                    }
                    if (CharTermAttribute.class.isAssignableFrom(attClass)) {
                        return;
                    }
                    if (PositionIncrementAttribute.class.isAssignableFrom(attClass)) {
                        return;
                    }
                    Object k = attClass.getName() + "#" + key;
                    if (ATTRIBUTE_MAPPING.containsKey(k)) {
                        k = ATTRIBUTE_MAPPING.get(k);
                    }
                    if (value instanceof BytesRef) {
                        BytesRef p = (BytesRef)value;
                        value = p.toString();
                    }
                    tokenNamedList.add((String)k, value);
                }
            });
            tokensNamedLists.add(tokenNamedList);
        }
        return tokensNamedLists;
    }

    private String writeCharStream(NamedList<Object> out, Reader input) {
        int BUFFER_SIZE = 1024;
        char[] buf = new char[1024];
        int len = 0;
        StringBuilder sb = new StringBuilder();
        do {
            try {
                len = input.read(buf, 0, 1024);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            if (len <= 0) continue;
            sb.append(buf, 0, len);
        } while (len == 1024);
        out.add(input.getClass().getName(), sb.toString());
        return sb.toString();
    }

    protected static class AnalysisContext {
        private final String fieldName;
        private final FieldType fieldType;
        private final Analyzer analyzer;
        private final Set<BytesRef> termsToMatch;

        public AnalysisContext(FieldType fieldType, Analyzer analyzer, Set<BytesRef> termsToMatch) {
            this(null, fieldType, analyzer, termsToMatch);
        }

        public AnalysisContext(String fieldName, FieldType fieldType, Analyzer analyzer) {
            this(fieldName, fieldType, analyzer, EMPTY_BYTES_SET);
        }

        public AnalysisContext(String fieldName, FieldType fieldType, Analyzer analyzer, Set<BytesRef> termsToMatch) {
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.analyzer = analyzer;
            this.termsToMatch = termsToMatch;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public FieldType getFieldType() {
            return this.fieldType;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }

        public Set<BytesRef> getTermsToMatch() {
            return this.termsToMatch;
        }
    }

    public static final class TokenTrackingAttributeImpl
    extends AttributeImpl
    implements TokenTrackingAttribute {
        private int[] basePositions = new int[0];
        private int position = 0;
        private transient int[] cachedPositions = null;

        @Override
        public void freezeStage() {
            this.basePositions = this.getPositions();
            this.position = 0;
            this.cachedPositions = null;
        }

        @Override
        public void setActPosition(int pos) {
            this.position = pos;
            this.cachedPositions = null;
        }

        @Override
        public int[] getPositions() {
            if (this.cachedPositions == null) {
                int[] tmpPositions = new int[this.basePositions.length + 1];
                System.arraycopy(this.basePositions, 0, tmpPositions, 0, this.basePositions.length);
                tmpPositions[this.basePositions.length] = this.position;
                this.cachedPositions = tmpPositions;
            }
            return this.cachedPositions;
        }

        @Override
        public void reset(int[] basePositions, int position) {
            this.basePositions = basePositions;
            this.position = position;
            this.cachedPositions = null;
        }

        @Override
        public void clear() {
        }

        @Override
        public void reflectWith(AttributeReflector reflector) {
            reflector.reflect(TokenTrackingAttribute.class, "position", this.position);
            reflector.reflect(TokenTrackingAttribute.class, "positionHistory", Arrays.stream(this.getPositions()).boxed().toArray(Integer[]::new));
        }

        @Override
        public void copyTo(AttributeImpl target) {
            TokenTrackingAttribute t = (TokenTrackingAttribute)((Object)target);
            t.reset(this.basePositions, this.position);
        }
    }

    public static interface TokenTrackingAttribute
    extends Attribute {
        public void freezeStage();

        public void setActPosition(int var1);

        public int[] getPositions();

        public void reset(int[] var1, int var2);
    }

    protected static final class ListBasedTokenStream
    extends TokenStream {
        private final List<AttributeSource> tokens;
        private Iterator<AttributeSource> tokenIterator;

        ListBasedTokenStream(AttributeSource attributeSource, List<AttributeSource> tokens) {
            super(attributeSource.getAttributeFactory());
            this.tokens = tokens;
            this.addAttributes(attributeSource);
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            this.tokenIterator = this.tokens.iterator();
        }

        @Override
        public boolean incrementToken() {
            if (this.tokenIterator.hasNext()) {
                this.clearAttributes();
                AttributeSource next = this.tokenIterator.next();
                this.addAttributes(next);
                next.copyTo(this);
                return true;
            }
            return false;
        }

        private void addAttributes(AttributeSource attributeSource) {
            Iterator<AttributeImpl> atts = attributeSource.getAttributeImplsIterator();
            while (atts.hasNext()) {
                this.addAttributeImpl(atts.next());
            }
        }
    }
}

