/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.request.FieldAnalysisRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.AnalysisRequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;

public class FieldAnalysisRequestHandler
extends AnalysisRequestHandlerBase {
    @Override
    protected NamedList doAnalysis(SolrQueryRequest req) throws Exception {
        FieldAnalysisRequest analysisRequest = this.resolveAnalysisRequest(req);
        IndexSchema indexSchema = req.getSchema();
        return this.handleAnalysisRequest(analysisRequest, indexSchema);
    }

    @Override
    public String getDescription() {
        return "Provide a breakdown of the analysis process of field/query text";
    }

    FieldAnalysisRequest resolveAnalysisRequest(SolrQueryRequest req) throws SolrException {
        Iterator<ContentStream> iterator;
        SolrParams solrParams = req.getParams();
        FieldAnalysisRequest analysisRequest = new FieldAnalysisRequest();
        boolean useDefaultSearchField = true;
        if (solrParams.get("analysis.fieldtype") != null) {
            analysisRequest.setFieldTypes(Arrays.asList(solrParams.get("analysis.fieldtype").split(",")));
            useDefaultSearchField = false;
        }
        if (solrParams.get("analysis.fieldname") != null) {
            analysisRequest.setFieldNames(Arrays.asList(solrParams.get("analysis.fieldname").split(",")));
            useDefaultSearchField = false;
        }
        if (useDefaultSearchField) {
            if (solrParams.get("df") != null) {
                analysisRequest.addFieldName(solrParams.get("df"));
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field analysis request must contain one of analysis.fieldtype, analysis.fieldname or df.");
            }
        }
        analysisRequest.setQuery(solrParams.get("analysis.query", solrParams.get("q")));
        String value = solrParams.get("analysis.fieldvalue");
        if (analysisRequest.getQuery() == null && value == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "One of analysis.fieldvalue, q, or analysis.query parameters must be specified");
        }
        Iterable<ContentStream> streams = req.getContentStreams();
        if (streams != null && (iterator = streams.iterator()).hasNext()) {
            ContentStream stream = iterator.next();
            try {
                value = StrUtils.stringFromReader(stream.getReader());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        analysisRequest.setFieldValue(value);
        analysisRequest.setShowMatch(solrParams.getBool("analysis.showmatch", false));
        return analysisRequest;
    }

    protected NamedList<NamedList> handleAnalysisRequest(FieldAnalysisRequest request, IndexSchema schema) {
        SimpleOrderedMap<NamedList> analysisResults = new SimpleOrderedMap<NamedList>();
        SimpleOrderedMap<NamedList<NamedList>> fieldTypeAnalysisResults = new SimpleOrderedMap<NamedList<NamedList>>();
        if (request.getFieldTypes() != null) {
            for (String fieldTypeName : request.getFieldTypes()) {
                FieldType fieldType = schema.getFieldTypes().get(fieldTypeName);
                fieldTypeAnalysisResults.add(fieldTypeName, this.analyzeValues(request, fieldType, null));
            }
        }
        SimpleOrderedMap<NamedList<NamedList>> fieldNameAnalysisResults = new SimpleOrderedMap<NamedList<NamedList>>();
        if (request.getFieldNames() != null) {
            for (String fieldName : request.getFieldNames()) {
                FieldType fieldType = schema.getFieldType(fieldName);
                fieldNameAnalysisResults.add(fieldName, this.analyzeValues(request, fieldType, fieldName));
            }
        }
        analysisResults.add("field_types", fieldTypeAnalysisResults);
        analysisResults.add("field_names", fieldNameAnalysisResults);
        return analysisResults;
    }

    NamedList<NamedList> analyzeValues(FieldAnalysisRequest analysisRequest, FieldType fieldType, String fieldName) {
        NamedList<? extends Object> analyzedTokens;
        AnalysisRequestHandlerBase.AnalysisContext context;
        String queryValue = analysisRequest.getQuery();
        Set<BytesRef> termsToMatch = queryValue != null && analysisRequest.isShowMatch() ? this.getQueryTokenSet(queryValue, fieldType.getQueryAnalyzer()) : EMPTY_BYTES_SET;
        SimpleOrderedMap<NamedList> analyzeResults = new SimpleOrderedMap<NamedList>();
        if (analysisRequest.getFieldValue() != null) {
            context = new AnalysisRequestHandlerBase.AnalysisContext(fieldName, fieldType, fieldType.getIndexAnalyzer(), termsToMatch);
            analyzedTokens = this.analyzeValue(analysisRequest.getFieldValue(), context);
            analyzeResults.add("index", analyzedTokens);
        }
        if (analysisRequest.getQuery() != null) {
            context = new AnalysisRequestHandlerBase.AnalysisContext(fieldName, fieldType, fieldType.getQueryAnalyzer());
            analyzedTokens = this.analyzeValue(analysisRequest.getQuery(), context);
            analyzeResults.add("query", analyzedTokens);
        }
        return analyzeResults;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }
}

