/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.solr.api.AnnotatedApi;
import org.apache.solr.api.Api;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.CoreAdminOperation;
import org.apache.solr.handler.admin.api.AllCoresStatusAPI;
import org.apache.solr.handler.admin.api.CoreSnapshot;
import org.apache.solr.handler.admin.api.CreateCoreAPI;
import org.apache.solr.handler.admin.api.CreateCoreBackup;
import org.apache.solr.handler.admin.api.GetNodeCommandStatus;
import org.apache.solr.handler.admin.api.InstallCoreData;
import org.apache.solr.handler.admin.api.MergeIndexes;
import org.apache.solr.handler.admin.api.OverseerOperationAPI;
import org.apache.solr.handler.admin.api.PrepareCoreRecoveryAPI;
import org.apache.solr.handler.admin.api.RejoinLeaderElectionAPI;
import org.apache.solr.handler.admin.api.ReloadCore;
import org.apache.solr.handler.admin.api.RenameCore;
import org.apache.solr.handler.admin.api.RequestApplyCoreUpdatesAPI;
import org.apache.solr.handler.admin.api.RequestBufferUpdatesAPI;
import org.apache.solr.handler.admin.api.RequestCoreRecoveryAPI;
import org.apache.solr.handler.admin.api.RequestSyncShardAPI;
import org.apache.solr.handler.admin.api.RestoreCore;
import org.apache.solr.handler.admin.api.SingleCoreStatusAPI;
import org.apache.solr.handler.admin.api.SplitCoreAPI;
import org.apache.solr.handler.admin.api.SwapCores;
import org.apache.solr.handler.admin.api.UnloadCore;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.stats.MetricUtils;
import org.apache.solr.util.tracing.TraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CoreAdminHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    protected final CoreAdminAsyncTracker coreAdminAsyncTracker;
    protected final Map<String, CoreAdminOp> opMap;
    public static String RESPONSE_STATUS = "STATUS";
    public static String RESPONSE_MESSAGE = "msg";
    public static String OPERATION_RESPONSE = "response";
    public static Map<String, String> paramToProp = Map.ofEntries(Map.entry("config", "config"), Map.entry("schema", "schema"), Map.entry("dataDir", "dataDir"), Map.entry("ulogDir", "ulogDir"), Map.entry("configSet", "configSet"), Map.entry("loadOnStartup", "loadOnStartup"), Map.entry("transient", "transient"), Map.entry("shard", "shard"), Map.entry("collection", "collection"), Map.entry("roles", "roles"), Map.entry("coreNodeName", "coreNodeName"), Map.entry("numShards", "numShards"), Map.entry("replicaType", "replicaType"));

    public CoreAdminHandler() {
        this.coreContainer = null;
        this.coreAdminAsyncTracker = new CoreAdminAsyncTracker();
        this.opMap = CoreAdminHandler.initializeOpMap();
    }

    public CoreAdminHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.coreAdminAsyncTracker = new CoreAdminAsyncTracker();
        this.opMap = CoreAdminHandler.initializeOpMap();
    }

    @Override
    public final void init(NamedList<?> args) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreAdminHandler should not be configured in solrconf.xml\nit is a special Handler configured directly by the RequestDispatcher");
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        super.initializeMetrics(parentContext, scope);
        this.coreAdminAsyncTracker.standardExecutor = MetricUtils.instrumentedExecutorService(this.coreAdminAsyncTracker.standardExecutor, this, this.solrMetricsContext.getMetricRegistry(), SolrMetricManager.mkName("parallelCoreAdminExecutor", this.getCategory().name(), scope, "threadPool"));
        this.coreAdminAsyncTracker.expensiveExecutor = MetricUtils.instrumentedExecutorService(this.coreAdminAsyncTracker.expensiveExecutor, this, this.solrMetricsContext.getMetricRegistry(), SolrMetricManager.mkName("parallelCoreExpensiveAdminExecutor", this.getCategory().name(), scope, "threadPool"));
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    public final void registerCustomActions(Map<String, CoreAdminOp> customActions) {
        for (Map.Entry<String, CoreAdminOp> entry : customActions.entrySet()) {
            String action = entry.getKey().toLowerCase(Locale.ROOT);
            CoreAdminOp operation = entry.getValue();
            if (this.opMap.containsKey(action)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreAdminHandler already registered action " + action);
            }
            this.opMap.put(action, operation);
        }
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    public CoreAdminAsyncTracker getCoreAdminAsyncTracker() {
        return this.coreAdminAsyncTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        try {
            CoreContainer cores = this.getCoreContainer();
            if (cores == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
            }
            String taskId = req.getParams().get("async");
            String action = req.getParams().get("action", CoreAdminParams.CoreAdminAction.STATUS.toString()).toLowerCase(Locale.ROOT);
            CoreAdminOp op = this.opMap.get(action);
            if (op == null) {
                log.warn("action '{}' not found, calling custom action handler. If original intention was to target some custom behaviour use custom actions defined in 'solr.xml' instead", (Object)action);
                this.handleCustomAction(req, rsp);
                return;
            }
            CallInfo callInfo = new CallInfo(this, req, rsp, op);
            String coreName = req.getParams().get("core", req.getParams().get("name"));
            MDCLoggingContext.setCoreName(coreName);
            TraceUtils.setDbInstance(req, coreName);
            if (taskId == null) {
                callInfo.call();
            } else {
                Callable<SolrQueryResponse> task = () -> {
                    callInfo.call();
                    return callInfo.rsp;
                };
                CoreAdminAsyncTracker.TaskObject taskObject = new CoreAdminAsyncTracker.TaskObject(taskId, action, op.isExpensive(), task);
                this.coreAdminAsyncTracker.submitAsyncTask(taskObject);
            }
        }
        finally {
            rsp.setHttpCaching(false);
        }
    }

    @Deprecated
    protected void handleCustomAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported operation: " + req.getParams().get("action"));
    }

    private static Map<String, CoreAdminOp> initializeOpMap() {
        HashMap<String, CoreAdminOp> opMap = new HashMap<String, CoreAdminOp>();
        for (CoreAdminOperation op : CoreAdminOperation.values()) {
            opMap.put(op.action.toString().toLowerCase(Locale.ROOT), op);
        }
        return opMap;
    }

    protected static Map<String, String> buildCoreParams(SolrParams params) {
        HashMap<String, String> coreParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : paramToProp.entrySet()) {
            String value = params.get(entry.getKey(), null);
            if (!StrUtils.isNotNullOrEmpty(value)) continue;
            coreParams.put(entry.getValue(), value);
        }
        Iterator<String> paramsIt = params.getParameterNamesIterator();
        while (paramsIt.hasNext()) {
            String param = paramsIt.next();
            if (param.startsWith("property.")) {
                String propName = param.substring("property.".length());
                String propValue = params.get(param);
                coreParams.put(propName, propValue);
            }
            if (!param.startsWith("collection.")) continue;
            coreParams.put(param, params.get(param));
        }
        return coreParams;
    }

    protected static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        path = path.replace('/', File.separatorChar);
        path = path.replace('\\', File.separatorChar);
        return path;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], params[i + 1]);
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage Multiple Solr Cores";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        String action = ctx.getParams().get("action");
        if (action == null) {
            return PermissionNameProvider.Name.CORE_READ_PERM;
        }
        CoreAdminParams.CoreAdminAction coreAction = CoreAdminParams.CoreAdminAction.get(action);
        if (coreAction == null) {
            return PermissionNameProvider.Name.CORE_READ_PERM;
        }
        return coreAction.isRead ? PermissionNameProvider.Name.CORE_READ_PERM : PermissionNameProvider.Name.CORE_EDIT_PERM;
    }

    public void shutdown() {
        this.coreAdminAsyncTracker.shutdown();
    }

    @Override
    public Collection<Api> getApis() {
        ArrayList<Api> apis = new ArrayList<Api>();
        apis.addAll(AnnotatedApi.getApis(new AllCoresStatusAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new SingleCoreStatusAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new CreateCoreAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RejoinLeaderElectionAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new OverseerOperationAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new SplitCoreAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RequestCoreRecoveryAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new PrepareCoreRecoveryAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RequestApplyCoreUpdatesAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RequestSyncShardAPI(this)));
        apis.addAll(AnnotatedApi.getApis(new RequestBufferUpdatesAPI(this)));
        return apis;
    }

    @Override
    public Collection<Class<? extends JerseyResource>> getJerseyResources() {
        return List.of(CoreSnapshot.class, InstallCoreData.class, CreateCoreBackup.class, RestoreCore.class, ReloadCore.class, UnloadCore.class, SwapCores.class, RenameCore.class, MergeIndexes.class, GetNodeCommandStatus.class);
    }

    public static class CoreAdminAsyncTracker {
        private static final int MAX_TRACKED_REQUESTS = 100;
        public static final String RUNNING = "running";
        public static final String COMPLETED = "completed";
        public static final String FAILED = "failed";
        public final Map<String, Map<String, TaskObject>> requestStatusMap;
        private ExecutorService standardExecutor = ExecutorUtil.newMDCAwareFixedThreadPool(50, new SolrNamedThreadFactory("parallelCoreAdminAPIBaseExecutor"));
        private ExecutorService expensiveExecutor = ExecutorUtil.newMDCAwareCachedThreadPool(5, Integer.MAX_VALUE, new SolrNamedThreadFactory("parallelCoreAdminAPIExpensiveExecutor"));

        public CoreAdminAsyncTracker() {
            HashMap map = new HashMap(3, 1.0f);
            map.put(RUNNING, Collections.synchronizedMap(new LinkedHashMap()));
            map.put(COMPLETED, Collections.synchronizedMap(new LinkedHashMap()));
            map.put(FAILED, Collections.synchronizedMap(new LinkedHashMap()));
            this.requestStatusMap = Collections.unmodifiableMap(map);
        }

        public void shutdown() {
            ExecutorUtil.shutdownAndAwaitTermination(this.standardExecutor);
            ExecutorUtil.shutdownAndAwaitTermination(this.expensiveExecutor);
        }

        public Map<String, TaskObject> getRequestStatusMap(String key) {
            return this.requestStatusMap.get(key);
        }

        public void submitAsyncTask(TaskObject taskObject) throws SolrException {
            this.ensureTaskIdNotInUse(taskObject.taskId);
            this.addTask(RUNNING, taskObject);
            Runnable command = () -> {
                boolean exceptionCaught = false;
                try {
                    SolrQueryResponse response = taskObject.task.call();
                    taskObject.setRspObject(response);
                    taskObject.setOperationRspObject(response);
                    this.finishTask(taskObject, !exceptionCaught);
                }
                catch (Exception e) {
                    try {
                        exceptionCaught = true;
                        taskObject.setRspObjectFromException(e);
                        this.finishTask(taskObject, !exceptionCaught);
                    }
                    catch (Throwable throwable) {
                        this.finishTask(taskObject, !exceptionCaught);
                        throw throwable;
                    }
                }
            };
            try {
                MDC.put((String)"CoreAdminHandler.asyncId", (String)taskObject.taskId);
                MDC.put((String)"CoreAdminHandler.action", (String)taskObject.action);
                if (taskObject.expensive) {
                    this.expensiveExecutor.execute(command);
                } else {
                    this.standardExecutor.execute(command);
                }
            }
            finally {
                MDC.remove((String)"CoreAdminHandler.asyncId");
                MDC.remove((String)"CoreAdminHandler.action");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addTask(String type, TaskObject o, boolean limit) {
            Map<String, TaskObject> map = this.getRequestStatusMap(type);
            synchronized (map) {
                if (limit && this.getRequestStatusMap(type).size() == 100) {
                    String key = this.getRequestStatusMap(type).entrySet().iterator().next().getKey();
                    this.getRequestStatusMap(type).remove(key);
                }
                this.addTask(type, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addTask(String type, TaskObject o) {
            Map<String, TaskObject> map = this.getRequestStatusMap(type);
            synchronized (map) {
                this.getRequestStatusMap(type).put(o.taskId, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeTask(String map, String taskId) {
            Map<String, TaskObject> map2 = this.getRequestStatusMap(map);
            synchronized (map2) {
                this.getRequestStatusMap(map).remove(taskId);
            }
        }

        private void ensureTaskIdNotInUse(String taskId) throws SolrException {
            if (this.getRequestStatusMap(RUNNING).containsKey(taskId) || this.getRequestStatusMap(COMPLETED).containsKey(taskId) || this.getRequestStatusMap(FAILED).containsKey(taskId)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Duplicate request with the same requestid found.");
            }
        }

        private void finishTask(TaskObject taskObject, boolean successful) {
            this.removeTask(RUNNING, taskObject.taskId);
            this.addTask(successful ? COMPLETED : FAILED, taskObject, true);
        }

        public static class TaskObject {
            final String taskId;
            final String action;
            final boolean expensive;
            final Callable<SolrQueryResponse> task;
            public String rspInfo;
            public Object operationRspInfo;

            public TaskObject(String taskId, String action, boolean expensive, Callable<SolrQueryResponse> task) {
                this.taskId = taskId;
                this.action = action;
                this.expensive = expensive;
                this.task = task;
            }

            public String getRspObject() {
                return this.rspInfo;
            }

            public void setRspObject(SolrQueryResponse rspObject) {
                this.rspInfo = rspObject.getToLogAsString("TaskId: " + this.taskId);
            }

            public void setRspObjectFromException(Exception e) {
                this.rspInfo = e.getMessage();
            }

            public Object getOperationRspObject() {
                return this.operationRspInfo;
            }

            public void setOperationRspObject(SolrQueryResponse rspObject) {
                this.operationRspInfo = rspObject.getResponse();
            }
        }
    }

    public static interface CoreAdminOp {
        default public boolean isExpensive() {
            return false;
        }

        public void execute(CallInfo var1) throws Exception;
    }

    public static class CallInfo {
        public final CoreAdminHandler handler;
        public final SolrQueryRequest req;
        public final SolrQueryResponse rsp;
        public final CoreAdminOp op;

        CallInfo(CoreAdminHandler handler, SolrQueryRequest req, SolrQueryResponse rsp, CoreAdminOp op) {
            this.handler = handler;
            this.req = req;
            this.rsp = rsp;
            this.op = op;
        }

        void call() throws Exception {
            this.op.execute(this);
        }
    }
}

