/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.api.model.GetNodeCommandStatusResponse;
import org.apache.solr.client.api.model.ListCoreSnapshotsResponse;
import org.apache.solr.client.api.model.ReloadCoreRequestBody;
import org.apache.solr.client.api.model.RenameCoreRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.SwapCoresRequestBody;
import org.apache.solr.client.api.model.UnloadCoreRequestBody;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.PropertiesUtil;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.BackupCoreOp;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.CreateSnapshotOp;
import org.apache.solr.handler.admin.DeleteSnapshotOp;
import org.apache.solr.handler.admin.InstallCoreDataOp;
import org.apache.solr.handler.admin.LukeRequestHandler;
import org.apache.solr.handler.admin.MergeIndexesOp;
import org.apache.solr.handler.admin.PrepRecoveryOp;
import org.apache.solr.handler.admin.RequestApplyUpdatesOp;
import org.apache.solr.handler.admin.RequestSyncShardOp;
import org.apache.solr.handler.admin.RestoreCoreOp;
import org.apache.solr.handler.admin.SplitOp;
import org.apache.solr.handler.admin.StatusOp;
import org.apache.solr.handler.admin.api.CoreSnapshot;
import org.apache.solr.handler.admin.api.GetNodeCommandStatus;
import org.apache.solr.handler.admin.api.ReloadCore;
import org.apache.solr.handler.admin.api.RenameCore;
import org.apache.solr.handler.admin.api.SwapCores;
import org.apache.solr.handler.admin.api.UnloadCore;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.NumberUtils;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.TestInjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CoreAdminOperation
extends Enum<CoreAdminOperation>
implements CoreAdminHandler.CoreAdminOp {
    public static final /* enum */ CoreAdminOperation CREATE_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.CREATE, it -> {
        Path instancePath;
        assert (TestInjection.injectRandomDelayInCoreCreation());
        SolrParams params = it.req.getParams();
        CoreAdminOperation.log().info("core create command {}", (Object)params);
        String coreName = params.required().get("name");
        Map<String, String> coreParams = CoreAdminHandler.buildCoreParams(params);
        CoreContainer coreContainer = it.handler.coreContainer;
        String instanceDir = it.req.getParams().get("instanceDir");
        if (instanceDir == null) {
            instanceDir = it.req.getParams().get("property.instanceDir");
        }
        if (instanceDir != null) {
            instanceDir = PropertiesUtil.substituteProperty(instanceDir, coreContainer.getContainerProperties());
            instancePath = coreContainer.getCoreRootDirectory().resolve(instanceDir).normalize();
        } else {
            instancePath = coreContainer.getCoreRootDirectory().resolve(coreName);
        }
        boolean newCollection = params.getBool("newCollection", false);
        coreContainer.create(coreName, instancePath, coreParams, newCollection);
        it.rsp.add("core", coreName);
    });
    public static final /* enum */ CoreAdminOperation UNLOAD_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.UNLOAD, it -> {
        SolrParams params = it.req.getParams();
        String cname = params.required().get("core");
        UnloadCoreRequestBody unloadCoreRequestBody = new UnloadCoreRequestBody();
        unloadCoreRequestBody.deleteIndex = params.getBool("deleteIndex", false);
        unloadCoreRequestBody.deleteDataDir = params.getBool("deleteDataDir", false);
        unloadCoreRequestBody.deleteInstanceDir = params.getBool("deleteInstanceDir", false);
        UnloadCore unloadCoreAPI = new UnloadCore(it.handler.coreContainer, it.handler.getCoreAdminAsyncTracker(), it.req, it.rsp);
        SolrJerseyResponse response = unloadCoreAPI.unloadCore(cname, unloadCoreRequestBody);
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(it.rsp, response);
    });
    public static final /* enum */ CoreAdminOperation RELOAD_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.RELOAD, it -> {
        SolrParams params = it.req.getParams();
        String cname = params.required().get("core");
        ReloadCore reloadCoreAPI = new ReloadCore(it.req, it.rsp, it.handler.coreContainer, it.handler.getCoreAdminAsyncTracker());
        ReloadCoreRequestBody reloadCoreRequestBody = new ReloadCoreRequestBody();
        SolrJerseyResponse response = reloadCoreAPI.reloadCore(cname, reloadCoreRequestBody);
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(it.rsp, response);
    });
    public static final /* enum */ CoreAdminOperation STATUS_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.STATUS, new StatusOp());
    public static final /* enum */ CoreAdminOperation SWAP_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.SWAP, it -> {
        SolrParams params = it.req.getParams();
        String cname = params.required().get("core");
        SwapCoresRequestBody swapCoresRequestBody = new SwapCoresRequestBody();
        swapCoresRequestBody.with = params.required().get("other");
        SwapCores swapCoresApi = new SwapCores(it.handler.coreContainer, it.handler.getCoreAdminAsyncTracker(), it.req, it.rsp);
        SolrJerseyResponse response = swapCoresApi.swapCores(cname, swapCoresRequestBody);
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(it.rsp, response);
    });
    public static final /* enum */ CoreAdminOperation RENAME_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.RENAME, it -> {
        SolrParams params = it.req.getParams();
        String cname = params.required().get("core");
        String name = params.required().get("other");
        RenameCoreRequestBody renameCoreRequestBody = new RenameCoreRequestBody();
        renameCoreRequestBody.to = name;
        RenameCore renameCoreApi = new RenameCore(it.handler.coreContainer, it.handler.getCoreAdminAsyncTracker(), it.req, it.rsp);
        SolrJerseyResponse response = renameCoreApi.renameCore(cname, renameCoreRequestBody);
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(it.rsp, response);
    });
    public static final /* enum */ CoreAdminOperation MERGEINDEXES_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.MERGEINDEXES, new MergeIndexesOp());
    public static final /* enum */ CoreAdminOperation SPLIT_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.SPLIT, new SplitOp());
    public static final /* enum */ CoreAdminOperation PREPRECOVERY_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.PREPRECOVERY, new PrepRecoveryOp());
    public static final /* enum */ CoreAdminOperation REQUESTRECOVERY_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.REQUESTRECOVERY, it -> {
        block7: {
            SolrParams params = it.req.getParams();
            String cname = params.required().get("core");
            CoreAdminOperation.log().info("It has been requested that we recover: core=" + cname);
            try (SolrCore core = it.handler.coreContainer.getCore(cname);){
                if (core != null) {
                    core.getUpdateHandler().getSolrCoreState().doRecovery(it.handler.coreContainer, core.getCoreDescriptor());
                    break block7;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to locate core " + cname);
            }
        }
    });
    public static final /* enum */ CoreAdminOperation REQUESTSYNCSHARD_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.REQUESTSYNCSHARD, new RequestSyncShardOp());
    public static final /* enum */ CoreAdminOperation REQUESTBUFFERUPDATES_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.REQUESTBUFFERUPDATES, it -> {
        SolrParams params = it.req.getParams();
        String cname = params.required().get("name");
        CoreAdminOperation.log().info("Starting to buffer updates on core:" + cname);
        try (SolrCore core = it.handler.coreContainer.getCore(cname);){
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core [" + cname + "] does not exist");
            }
            UpdateLog updateLog = core.getUpdateHandler().getUpdateLog();
            if (updateLog.getState() != UpdateLog.State.ACTIVE) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core " + cname + " not in active state");
            }
            updateLog.bufferUpdates();
            it.rsp.add("core", cname);
            it.rsp.add("status", "BUFFERING");
        }
        catch (Throwable e) {
            if (e instanceof SolrException) {
                throw (SolrException)e;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not start buffering updates", e);
        }
        finally {
            if (it.req != null) {
                it.req.close();
            }
        }
    });
    public static final /* enum */ CoreAdminOperation REQUESTAPPLYUPDATES_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES, new RequestApplyUpdatesOp());
    public static final /* enum */ CoreAdminOperation REQUESTSTATUS_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.REQUESTSTATUS, it -> {
        SolrParams params = it.req.getParams();
        String requestId = params.required().get("requestid");
        CoreAdminOperation.log().info("Checking request status for : " + requestId);
        GetNodeCommandStatus requestCoreCommandStatusApi = new GetNodeCommandStatus(it.handler.coreContainer, it.handler.coreAdminAsyncTracker, it.req, it.rsp);
        GetNodeCommandStatusResponse response = requestCoreCommandStatusApi.getCommandStatus(requestId);
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(it.rsp, response);
    });
    public static final /* enum */ CoreAdminOperation OVERSEEROP_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.OVERSEEROP, it -> {
        ZkController zkController = it.handler.coreContainer.getZkController();
        if (zkController != null) {
            String op = it.req.getParams().get("op");
            String electionNode = it.req.getParams().get("electionNode");
            if (electionNode != null) {
                zkController.rejoinOverseerElection(electionNode, "rejoinAtHead".equals(op));
            } else {
                CoreAdminOperation.log().info("electionNode is required param");
            }
        }
    });
    public static final /* enum */ CoreAdminOperation REJOINLEADERELECTION_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.REJOINLEADERELECTION, it -> {
        ZkController zkController = it.handler.coreContainer.getZkController();
        if (zkController != null) {
            zkController.rejoinShardLeaderElection(it.req.getParams());
        } else {
            CoreAdminOperation.log().warn("zkController is null in CoreAdminHandler.handleRequestInternal:REJOINLEADERELECTION. No action taken.");
        }
    });
    public static final /* enum */ CoreAdminOperation BACKUPCORE_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.BACKUPCORE, new BackupCoreOp());
    public static final /* enum */ CoreAdminOperation RESTORECORE_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.RESTORECORE, new RestoreCoreOp());
    public static final /* enum */ CoreAdminOperation INSTALLCOREDATA_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.INSTALLCOREDATA, new InstallCoreDataOp());
    public static final /* enum */ CoreAdminOperation CREATESNAPSHOT_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.CREATESNAPSHOT, new CreateSnapshotOp());
    public static final /* enum */ CoreAdminOperation DELETESNAPSHOT_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.DELETESNAPSHOT, new DeleteSnapshotOp());
    public static final /* enum */ CoreAdminOperation LISTSNAPSHOTS_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.LISTSNAPSHOTS, it -> {
        SolrParams params = it.req.getParams();
        String coreName = params.required().get("core");
        CoreContainer coreContainer = it.handler.getCoreContainer();
        CoreSnapshot coreSnapshotAPI = new CoreSnapshot(it.req, it.rsp, coreContainer, it.handler.getCoreAdminAsyncTracker());
        ListCoreSnapshotsResponse response = coreSnapshotAPI.listSnapshots(coreName);
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(it.rsp, response);
    });
    final CoreAdminParams.CoreAdminAction action;
    final CoreAdminHandler.CoreAdminOp fun;
    private static final Logger log;
    private static final /* synthetic */ CoreAdminOperation[] $VALUES;

    public static CoreAdminOperation[] values() {
        return (CoreAdminOperation[])$VALUES.clone();
    }

    public static CoreAdminOperation valueOf(String name) {
        return Enum.valueOf(CoreAdminOperation.class, name);
    }

    private CoreAdminOperation(CoreAdminParams.CoreAdminAction action, CoreAdminHandler.CoreAdminOp fun) {
        this.action = action;
        this.fun = fun;
    }

    static Logger log() {
        return log;
    }

    @Override
    public boolean isExpensive() {
        return this.fun.isExpensive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedList<Object> getCoreStatus(CoreContainer cores, String cname, boolean isIndexInfoNeeded) throws IOException {
        SimpleOrderedMap<Object> info;
        block18: {
            info = new SimpleOrderedMap<Object>();
            if (cores.isCoreLoading(cname)) {
                info.add("name", cname);
                info.add("isLoaded", "false");
                info.add("isLoading", "true");
            } else if (!cores.isLoaded(cname)) {
                CoreDescriptor desc = cores.getCoreDescriptor(cname);
                if (desc != null) {
                    info.add("name", desc.getName());
                    info.add("instanceDir", desc.getInstanceDir());
                    String tmp = desc.getDataDir();
                    if (StrUtils.isNotBlank(tmp)) {
                        info.add("dataDir", tmp);
                    }
                    if (StrUtils.isNotBlank(tmp = desc.getConfigName())) {
                        info.add("config", tmp);
                    }
                    if (StrUtils.isNotBlank(tmp = desc.getSchemaName())) {
                        info.add("schema", tmp);
                    }
                    info.add("isLoaded", "false");
                }
            } else {
                try (SolrCore core = cores.getCore(cname);){
                    if (core == null) break block18;
                    info.add("name", core.getName());
                    info.add("instanceDir", core.getInstancePath().toString());
                    info.add("dataDir", CoreAdminHandler.normalizePath(core.getDataDir()));
                    info.add("config", core.getConfigResource());
                    info.add("schema", core.getSchemaResource());
                    info.add("startTime", core.getStartTimeStamp());
                    info.add("uptime", core.getUptimeMs());
                    if (cores.isZooKeeperAware()) {
                        info.add("lastPublished", core.getCoreDescriptor().getCloudDescriptor().getLastPublished().toString().toLowerCase(Locale.ROOT));
                        info.add("configVersion", core.getSolrConfig().getZnodeVersion());
                        SimpleOrderedMap<String> cloudInfo = new SimpleOrderedMap<String>();
                        cloudInfo.add("collection", core.getCoreDescriptor().getCloudDescriptor().getCollectionName());
                        cloudInfo.add("shard", core.getCoreDescriptor().getCloudDescriptor().getShardId());
                        cloudInfo.add("replica", core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
                        cloudInfo.add("replicaType", core.getCoreDescriptor().getCloudDescriptor().getReplicaType().name());
                        info.add("cloud", cloudInfo);
                    }
                    if (!isIndexInfoNeeded) break block18;
                    RefCounted<SolrIndexSearcher> searcher = core.getSearcher();
                    try {
                        SimpleOrderedMap<Object> indexInfo = LukeRequestHandler.getIndexInfo(searcher.get().getIndexReader());
                        long size = core.getIndexSize();
                        indexInfo.add("sizeInBytes", size);
                        indexInfo.add("size", NumberUtils.readableSize(size));
                        info.add("index", indexInfo);
                    }
                    finally {
                        searcher.decref();
                    }
                }
            }
        }
        return info;
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        try {
            this.fun.execute(it);
        }
        catch (InterruptedException | SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error handling '" + this.action.name() + "' action", (Throwable)e);
        }
    }

    static {
        $VALUES = new CoreAdminOperation[]{CREATE_OP, UNLOAD_OP, RELOAD_OP, STATUS_OP, SWAP_OP, RENAME_OP, MERGEINDEXES_OP, SPLIT_OP, PREPRECOVERY_OP, REQUESTRECOVERY_OP, REQUESTSYNCSHARD_OP, REQUESTBUFFERUPDATES_OP, REQUESTAPPLYUPDATES_OP, REQUESTSTATUS_OP, OVERSEEROP_OP, REJOINLEADERELECTION_OP, BACKUPCORE_OP, RESTORECORE_OP, INSTALLCOREDATA_OP, CREATESNAPSHOT_OP, DELETESNAPSHOT_OP, LISTSNAPSHOTS_OP};
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

