/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.CoreAdminOperation;

class StatusOp
implements CoreAdminHandler.CoreAdminOp {
    StatusOp() {
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        SolrParams params = it.req.getParams();
        String cname = params.get("core");
        String indexInfo = params.get("indexInfo");
        boolean isIndexInfoNeeded = Boolean.parseBoolean(null == indexInfo ? "true" : indexInfo);
        SimpleOrderedMap<NamedList<Object>> status = new SimpleOrderedMap<NamedList<Object>>();
        Map<String, Exception> failures = new HashMap<String, Exception>();
        for (Map.Entry<String, CoreContainer.CoreLoadFailure> failure : it.handler.coreContainer.getCoreInitFailures().entrySet()) {
            failures.put(failure.getKey(), failure.getValue().exception);
        }
        if (cname == null) {
            List<String> nameList = it.handler.coreContainer.getAllCoreNames();
            nameList.sort(null);
            for (String name : nameList) {
                status.add(name, CoreAdminOperation.getCoreStatus(it.handler.coreContainer, name, isIndexInfoNeeded));
            }
            it.rsp.add("initFailures", failures);
        } else {
            failures = failures.containsKey(cname) ? Collections.singletonMap(cname, (Exception)failures.get(cname)) : Collections.emptyMap();
            it.rsp.add("initFailures", failures);
            status.add(cname, CoreAdminOperation.getCoreStatus(it.handler.coreContainer, cname, isIndexInfoNeeded));
        }
        it.rsp.add("status", status);
    }
}

