/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.io.IOException;
import java.net.URI;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.backup.BackupFilePaths;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public abstract class BackupAPIBase
extends AdminAPIBase {
    public BackupAPIBase(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    protected String getAndValidateBackupLocation(String repositoryName, String location) throws IOException {
        try (BackupRepository repository = this.createBackupRepository(repositoryName);){
            String string = this.getAndValidateBackupLocation(repository, location);
            return string;
        }
    }

    protected String getAndValidateIncrementalBackupLocation(String repositoryName, String location, String backupName) throws IOException {
        try (BackupRepository repository = this.createBackupRepository(repositoryName);){
            String fetchedLocation = this.getAndValidateBackupLocation(repository, location);
            this.ensureBackupLocationIsIncremental(repository, fetchedLocation, backupName);
            String string = fetchedLocation;
            return string;
        }
    }

    protected BackupRepository createBackupRepository(String repositoryName) {
        return this.coreContainer.newBackupRepository(repositoryName);
    }

    private String getLocation(BackupRepository repository, String location) throws IOException {
        if ((location = repository.getBackupLocation(location)) != null) {
            return location;
        }
        location = new ClusterProperties(this.coreContainer.getZkController().getZkClient()).getClusterProperty("location", null);
        if (location != null) {
            return location;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' is not specified as a query parameter or as a default repository property or as a cluster property.");
    }

    private void ensureBackupLocationExists(BackupRepository repository, String location) {
        URI uri = repository.createDirectoryURI(location);
        try {
            if (!repository.exists(uri)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "specified location " + uri + " does not exist.");
            }
        }
        catch (IOException ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to check the existence of " + uri + ". Is it valid?", (Throwable)ex);
        }
    }

    private String getAndValidateBackupLocation(BackupRepository backupRepository, String location) throws IOException {
        location = this.getLocation(backupRepository, location);
        this.ensureBackupLocationExists(backupRepository, location);
        return location;
    }

    private void ensureBackupLocationIsIncremental(BackupRepository repository, String location, String backupName) throws IOException {
        URI locationURI = repository.createDirectoryURI(location);
        URI locationAndNameUri = BackupFilePaths.buildExistingBackupLocationURI(repository, locationURI, backupName);
        if (repository.exists(repository.resolve(locationAndNameUri, "backup.properties"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The backup name [" + backupName + "] at location [" + location + "] holds a non-incremental (legacy) backup, but backup-listing is only supported on incremental backups");
        }
    }
}

