/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.solr.client.api.endpoint.CreateCoreBackupApi;
import org.apache.solr.client.api.model.CreateCoreBackupRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.backup.BackupFilePaths;
import org.apache.solr.core.backup.ShardBackupId;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.IncrementalShardBackup;
import org.apache.solr.handler.SnapShooter;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.CoreAdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class CreateCoreBackup
extends CoreAdminAPIBase
implements CreateCoreBackupApi {
    @Inject
    public CreateCoreBackup(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse, CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker) {
        super(coreContainer, coreAdminAsyncTracker, solrQueryRequest, solrQueryResponse);
    }

    @Override
    boolean isExpensive() {
        return true;
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse createBackup(String coreName, CreateCoreBackupRequestBody backupCoreRequestBody) throws Exception {
        this.ensureRequiredParameterProvided("coreName", coreName);
        return this.handlePotentiallyAsynchronousTask(null, coreName, backupCoreRequestBody.async, "backup", () -> {
            try (BackupRepository repository = this.coreContainer.newBackupRepository(backupCoreRequestBody.repository);){
                URI locationUri;
                SolrCore core;
                block21: {
                    core = this.coreContainer.getCore(coreName);
                    try {
                        String location = repository.getBackupLocation(backupCoreRequestBody.location);
                        if (location == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' parameter is not specified in the request body or as a default repository property");
                        }
                        locationUri = repository.createDirectoryURI(location);
                        repository.createDirectory(locationUri);
                        if (!Boolean.TRUE.equals(backupCoreRequestBody.incremental)) break block21;
                        if ("file".equals(locationUri.getScheme())) {
                            core.getCoreContainer().assertPathAllowed(Paths.get(locationUri));
                        }
                        this.ensureRequiredParameterProvided("shardBackupId", backupCoreRequestBody.shardBackupId);
                        ShardBackupId shardBackupId = ShardBackupId.from(backupCoreRequestBody.shardBackupId);
                        ShardBackupId prevShardBackupId = backupCoreRequestBody.prevShardBackupId != null ? ShardBackupId.from(backupCoreRequestBody.prevShardBackupId) : null;
                        BackupFilePaths incBackupFiles = new BackupFilePaths(repository, locationUri);
                        IncrementalShardBackup incSnapShooter = new IncrementalShardBackup(repository, core, incBackupFiles, prevShardBackupId, shardBackupId, Optional.ofNullable(backupCoreRequestBody.commitName));
                        IncrementalShardBackup.IncrementalShardSnapshotResponse incrementalShardSnapshotResponse = incSnapShooter.backup();
                        if (core != null) {
                            core.close();
                        }
                        return incrementalShardSnapshotResponse;
                    }
                    catch (Throwable throwable) {
                        if (core != null) {
                            try {
                                core.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                SnapShooter snapShooter = new SnapShooter(repository, core, locationUri, backupCoreRequestBody.backupName, backupCoreRequestBody.commitName);
                if (!snapShooter.getBackupRepository().exists(snapShooter.getLocation())) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Directory to contain snapshots doesn't exist: " + snapShooter.getLocation() + ". Note that Backup/Restore of a SolrCloud collection requires a shared file system mounted at the same path on all nodes!");
                }
                snapShooter.validateCreateSnapshot();
                SnapShooter.CoreSnapshotResponse coreSnapshotResponse = snapShooter.createSnapshot();
                if (core != null) {
                    core.close();
                }
                return coreSnapshotResponse;
            }
            catch (Exception exp) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to backup core=" + coreName + " because " + exp, (Throwable)exp);
            }
        });
    }
}

