/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.client.api.endpoint.CreateShardApi;
import org.apache.solr.client.api.model.CreateShardRequestBody;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.admin.api.CreateCollection;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class CreateShard
extends AdminAPIBase
implements CreateShardApi {
    @Inject
    public CreateShard(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse createShard(String collectionName, CreateShardRequestBody requestBody) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required request-body is missing");
        }
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("shard", requestBody.shardName);
        SolrIdentifierValidator.validateShardName(requestBody.shardName);
        String resolvedCollectionName = this.resolveAndValidateAliasIfEnabled(collectionName, Boolean.TRUE.equals(requestBody.followAliases));
        this.ensureCollectionUsesImplicitRouter(resolvedCollectionName);
        ZkNodeProps remoteMessage = CreateShard.createRemoteMessage(resolvedCollectionName, requestBody);
        this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.CREATESHARD, remoteMessage, requestBody.async);
        return response;
    }

    public static CreateShardRequestBody createRequestBodyFromV1Params(SolrParams params) {
        params.required().check("collection", "shard");
        CreateShardRequestBody requestBody = new CreateShardRequestBody();
        requestBody.shardName = params.get("shard");
        requestBody.replicationFactor = params.getInt("replicationFactor");
        requestBody.nrtReplicas = params.getInt("nrtReplicas");
        requestBody.tlogReplicas = params.getInt("tlogReplicas");
        requestBody.pullReplicas = params.getInt("pullReplicas");
        if (params.get("createNodeSet") != null) {
            String nodeSetStr = params.get("createNodeSet");
            if ("EMPTY".equals(nodeSetStr)) {
                requestBody.createReplicas = false;
            } else {
                requestBody.nodeSet = Arrays.asList(nodeSetStr.split(","));
            }
        }
        requestBody.waitForFinalState = params.getBool("waitForFinalState");
        requestBody.followAliases = params.getBool("followAliases");
        requestBody.async = params.get("async");
        requestBody.properties = CreateCollection.copyPrefixedPropertiesWithoutPrefix(params, new HashMap<String, String>(), "property.");
        return requestBody;
    }

    public static void invokeFromV1Params(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) throws Exception {
        CreateShardRequestBody requestBody = CreateShard.createRequestBodyFromV1Params(solrQueryRequest.getParams());
        CreateShard createShardApi = new CreateShard(coreContainer, solrQueryRequest, solrQueryResponse);
        SubResponseAccumulatingJerseyResponse response = createShardApi.createShard(solrQueryRequest.getParams().get("collection"), requestBody);
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(solrQueryResponse, response);
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, CreateShardRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.CREATESHARD.toLower());
        remoteMessage.put("collection", collectionName);
        remoteMessage.put("shard", requestBody.shardName);
        if (requestBody.createReplicas == null || requestBody.createReplicas.booleanValue()) {
            if (requestBody.nodeSet != null) {
                remoteMessage.put("createNodeSet", String.join((CharSequence)",", requestBody.nodeSet));
            }
        } else {
            remoteMessage.put("createNodeSet", "EMPTY");
        }
        CreateShard.insertIfNotNull(remoteMessage, "replicationFactor", requestBody.replicationFactor);
        CreateShard.insertIfNotNull(remoteMessage, "nrtReplicas", requestBody.nrtReplicas);
        CreateShard.insertIfNotNull(remoteMessage, "tlogReplicas", requestBody.tlogReplicas);
        CreateShard.insertIfNotNull(remoteMessage, "pullReplicas", requestBody.pullReplicas);
        CreateShard.insertIfNotNull(remoteMessage, "waitForFinalState", requestBody.waitForFinalState);
        CreateShard.insertIfNotNull(remoteMessage, "followAliases", requestBody.followAliases);
        CreateShard.insertIfNotNull(remoteMessage, "async", requestBody.async);
        if (requestBody.properties != null) {
            requestBody.properties.entrySet().forEach(entry -> remoteMessage.put("property." + (String)entry.getKey(), entry.getValue()));
        }
        return new ZkNodeProps(remoteMessage);
    }

    private void ensureCollectionUsesImplicitRouter(String collectionName) {
        ClusterState clusterState = this.coreContainer.getZkController().getClusterState();
        if (!"implicit".equals(((Map)clusterState.getCollection(collectionName).get("router")).get("name"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards can be added only to 'implicit' collections");
        }
    }
}

