/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.HashMap;
import org.apache.solr.client.api.endpoint.DeleteAliasApi;
import org.apache.solr.client.api.model.AsyncJerseyResponse;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class DeleteAlias
extends AdminAPIBase
implements DeleteAliasApi {
    @Inject
    public DeleteAlias(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse deleteAlias(String aliasName, String asyncId) throws Exception {
        AsyncJerseyResponse response = this.instantiateJerseyResponse(AsyncJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        ZkNodeProps remoteMessage = DeleteAlias.createRemoteMessage(aliasName, asyncId);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.DELETEALIAS, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        if (asyncId != null) {
            response.requestId = asyncId;
        }
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String aliasName, String asyncId) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.DELETEALIAS.toLower());
        remoteMessage.put("name", aliasName);
        if (asyncId != null) {
            remoteMessage.put("async", asyncId);
        }
        return new ZkNodeProps(remoteMessage);
    }
}

