/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.api.endpoint.DeleteCollectionBackupApi;
import org.apache.solr.client.api.model.BackupDeletionData;
import org.apache.solr.client.api.model.BackupDeletionResponseBody;
import org.apache.solr.client.api.model.PurgeUnusedFilesRequestBody;
import org.apache.solr.client.api.model.PurgeUnusedResponse;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.BackupAPIBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJacksonMapper;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class DeleteCollectionBackup
extends BackupAPIBase
implements DeleteCollectionBackupApi {
    private final ObjectMapper objectMapper = SolrJacksonMapper.getObjectMapper();

    @Inject
    public DeleteCollectionBackup(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public BackupDeletionResponseBody deleteSingleBackupById(String backupName, String backupId, String location, String repositoryName, String asyncId) throws Exception {
        BackupDeletionResponseBody response = this.instantiateJerseyResponse(BackupDeletionResponseBody.class);
        DeleteCollectionBackup.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        this.ensureRequiredParameterProvided("name", backupName);
        this.ensureRequiredParameterProvided("backupId", backupId);
        location = this.getAndValidateBackupLocation(repositoryName, location);
        ZkNodeProps remoteMessage = DeleteCollectionBackup.createRemoteMessage(backupName, backupId, null, null, location, repositoryName, asyncId);
        SolrResponse remoteResponse = this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.DELETEBACKUP, remoteMessage, asyncId);
        response.deleted = DeleteCollectionBackup.fromRemoteResponse(this.objectMapper, remoteResponse);
        response.collection = (String)remoteResponse.getResponse().get("collection");
        return response;
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public BackupDeletionResponseBody deleteMultipleBackupsByRecency(String backupName, Integer versionsToRetain, String location, String repositoryName, String asyncId) throws Exception {
        BackupDeletionResponseBody response = this.instantiateJerseyResponse(BackupDeletionResponseBody.class);
        DeleteCollectionBackup.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        this.ensureRequiredParameterProvided("name", backupName);
        this.ensureRequiredParameterProvided("retainLatest", versionsToRetain);
        location = this.getAndValidateBackupLocation(repositoryName, location);
        ZkNodeProps remoteMessage = DeleteCollectionBackup.createRemoteMessage(backupName, null, versionsToRetain, null, location, repositoryName, asyncId);
        SolrResponse remoteResponse = this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.DELETEBACKUP, remoteMessage, asyncId);
        response.deleted = DeleteCollectionBackup.fromRemoteResponse(this.objectMapper, remoteResponse);
        response.collection = (String)remoteResponse.getResponse().get("collection");
        return response;
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public PurgeUnusedResponse garbageCollectUnusedBackupFiles(String backupName, PurgeUnusedFilesRequestBody requestBody) throws Exception {
        PurgeUnusedResponse response = this.instantiateJerseyResponse(PurgeUnusedResponse.class);
        DeleteCollectionBackup.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required request body is missing");
        }
        this.ensureRequiredParameterProvided("name", backupName);
        requestBody.location = this.getAndValidateBackupLocation(requestBody.repositoryName, requestBody.location);
        ZkNodeProps remoteMessage = DeleteCollectionBackup.createRemoteMessage(backupName, null, null, Boolean.TRUE, requestBody.location, requestBody.repositoryName, requestBody.async);
        SolrResponse remoteResponse = this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.DELETEBACKUP, remoteMessage, requestBody.async);
        Object remoteDeleted = remoteResponse.getResponse().get("deleted");
        if (remoteDeleted != null) {
            response.deleted = (PurgeUnusedResponse.PurgeUnusedStats)this.objectMapper.convertValue(remoteDeleted, PurgeUnusedResponse.PurgeUnusedStats.class);
        }
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String backupName, String backupId, Integer versionsToRetain, Boolean purgeUnused, String location, String repositoryName, String asyncId) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.DELETEBACKUP.toLower());
        remoteMessage.put("name", backupName);
        assert (backupId != null || versionsToRetain != null || purgeUnused != null);
        DeleteCollectionBackup.insertIfNotNull(remoteMessage, "backupId", backupId);
        DeleteCollectionBackup.insertIfNotNull(remoteMessage, "maxNumBackupPoints", versionsToRetain);
        DeleteCollectionBackup.insertIfNotNull(remoteMessage, "purgeUnused", purgeUnused);
        DeleteCollectionBackup.insertIfNotNull(remoteMessage, "location", location);
        DeleteCollectionBackup.insertIfNotNull(remoteMessage, "repository", repositoryName);
        DeleteCollectionBackup.insertIfNotNull(remoteMessage, "async", asyncId);
        return new ZkNodeProps(remoteMessage);
    }

    public static void invokeFromV1Params(CoreContainer coreContainer, SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        int deletionModesProvided = 0;
        if (req.getParams().get("maxNumBackupPoints") != null) {
            ++deletionModesProvided;
        }
        if (req.getParams().get("purgeUnused") != null) {
            ++deletionModesProvided;
        }
        if (req.getParams().get("backupId") != null) {
            ++deletionModesProvided;
        }
        if (deletionModesProvided != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Exactly one of %s, %s, and %s parameters must be provided", "maxNumBackupPoints", "purgeUnused", "backupId"));
        }
        DeleteCollectionBackup deleteApi = new DeleteCollectionBackup(coreContainer, req, rsp);
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, DeleteCollectionBackup.invokeApi(deleteApi, req.getParams()));
    }

    public static List<BackupDeletionData> fromRemoteResponse(ObjectMapper objectMapper, SolrResponse response) {
        List deleted = (List)response.getResponse().get("deleted");
        if (deleted == null) {
            return null;
        }
        ArrayList<BackupDeletionData> statList = new ArrayList<BackupDeletionData>();
        for (SimpleOrderedMap remoteStat : deleted) {
            statList.add((BackupDeletionData)objectMapper.convertValue((Object)remoteStat, BackupDeletionData.class));
        }
        return statList;
    }

    private static SolrJerseyResponse invokeApi(DeleteCollectionBackup api, SolrParams params) throws Exception {
        if (params.get("maxNumBackupPoints") != null) {
            return api.deleteMultipleBackupsByRecency(params.get("name"), params.getInt("maxNumBackupPoints"), params.get("location"), params.get("repository"), params.get("async"));
        }
        if (params.get("purgeUnused") != null) {
            PurgeUnusedFilesRequestBody requestBody = new PurgeUnusedFilesRequestBody();
            requestBody.location = params.get("location");
            requestBody.repositoryName = params.get("repository");
            requestBody.async = params.get("async");
            return api.garbageCollectUnusedBackupFiles(params.get("name"), requestBody);
        }
        return api.deleteSingleBackupById(params.get("name"), params.get("backupId"), params.get("location"), params.get("repository"), params.get("async"));
    }
}

