/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.HashMap;
import org.apache.solr.client.api.endpoint.DeleteNodeApi;
import org.apache.solr.client.api.model.DeleteNodeRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class DeleteNode
extends AdminAPIBase
implements DeleteNodeApi {
    @Inject
    public DeleteNode(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse deleteNode(String nodeName, DeleteNodeRequestBody requestBody) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        CoreContainer coreContainer = this.fetchAndValidateZooKeeperAwareCoreContainer();
        ZkNodeProps remoteMessage = DeleteNode.createRemoteMessage(nodeName, requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(coreContainer, coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.DELETENODE, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        this.disableResponseCaching();
        return response;
    }

    public static SolrJerseyResponse invokeUsingV1Inputs(DeleteNode apiInstance, SolrParams params) throws Exception {
        RequiredSolrParams requiredParams = params.required();
        DeleteNodeRequestBody requestBody = new DeleteNodeRequestBody();
        requestBody.async = params.get("async");
        return apiInstance.deleteNode(requiredParams.get("node"), requestBody);
    }

    public static ZkNodeProps createRemoteMessage(String nodeName, DeleteNodeRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("node", nodeName);
        if (requestBody != null && requestBody.async != null) {
            remoteMessage.put("async", requestBody.async);
        }
        remoteMessage.put("operation", CollectionParams.CollectionAction.DELETENODE.toLower());
        return new ZkNodeProps(remoteMessage);
    }
}

