/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.HashMap;
import org.apache.solr.client.api.endpoint.DeleteShardApi;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class DeleteShard
extends AdminAPIBase
implements DeleteShardApi {
    @Inject
    public DeleteShard(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse deleteShard(String collectionName, String shardName, Boolean deleteInstanceDir, Boolean deleteDataDir, Boolean deleteIndex, Boolean followAliases, String asyncId) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("shard", shardName);
        this.fetchAndValidateZooKeeperAwareCoreContainer();
        DeleteShard.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = DeleteShard.createRemoteMessage(collectionName, shardName, deleteInstanceDir, deleteDataDir, deleteIndex, followAliases, asyncId);
        this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.DELETESHARD, remoteMessage, asyncId);
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, String shardName, Boolean deleteInstanceDir, Boolean deleteDataDir, Boolean deleteIndex, Boolean followAliases, String asyncId) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.DELETESHARD.toLower());
        remoteMessage.put("collection", collectionName);
        remoteMessage.put("shard", shardName);
        DeleteShard.insertIfNotNull(remoteMessage, "followAliases", followAliases);
        DeleteShard.insertIfNotNull(remoteMessage, "deleteInstanceDir", deleteInstanceDir);
        DeleteShard.insertIfNotNull(remoteMessage, "deleteDataDir", deleteDataDir);
        DeleteShard.insertIfNotNull(remoteMessage, "deleteIndex", deleteIndex);
        DeleteShard.insertIfNotNull(remoteMessage, "async", asyncId);
        return new ZkNodeProps(remoteMessage);
    }

    public static void invokeWithV1Params(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) throws Exception {
        SolrParams v1Params = solrQueryRequest.getParams();
        v1Params.required().check("collection", "shard");
        DeleteShard deleteShardApi = new DeleteShard(coreContainer, solrQueryRequest, solrQueryResponse);
        SubResponseAccumulatingJerseyResponse v2Response = deleteShardApi.deleteShard(v1Params.get("collection"), v1Params.get("shard"), v1Params.getBool("deleteInstanceDir"), v1Params.getBool("deleteDataDir"), v1Params.getBool("deleteIndex"), v1Params.getBool("followAliases"), v1Params.get("async"));
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(solrQueryResponse, v2Response);
    }
}

