/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Map;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrClassLoader;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.pkg.PackageListeningClassLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.security.PermissionNameProvider;

@Path(value="/{a:cores|collections}/{collectionName}/schema")
public class GetSchemaFieldAPI
extends JerseyResource {
    private final IndexSchema indexSchema;
    private final SolrParams params;

    @Inject
    public GetSchemaFieldAPI(IndexSchema indexSchema, SolrParams params) {
        this.indexSchema = indexSchema;
        this.params = params;
    }

    @GET
    @Path(value="/fields")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaListFieldsResponse listSchemaFields() {
        SchemaListFieldsResponse response = this.instantiateJerseyResponse(SchemaListFieldsResponse.class);
        String realName = "fields";
        response.fields = this.listAllFieldsOfType("fields", this.params);
        return response;
    }

    @GET
    @Path(value="/fields/{fieldName}")
    @Produces(value={"application/json", "application/atom+xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaGetFieldInfoResponse getFieldInfo(@PathParam(value="fieldName") String fieldName) {
        if (fieldName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field name must not be null");
        }
        SchemaGetFieldInfoResponse response = this.instantiateJerseyResponse(SchemaGetFieldInfoResponse.class);
        String realName = "fields";
        SimpleOrderedMap<Object> fieldInfo = this.retrieveFieldInfoOfType("fields", fieldName, this.params);
        if (fieldInfo != null) {
            response.fieldInfo = fieldInfo;
            return response;
        }
        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No such field [" + fieldName + "]");
    }

    @GET
    @Path(value="/copyfields")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaListCopyFieldsResponse listCopyFields() {
        SchemaListCopyFieldsResponse response = this.instantiateJerseyResponse(SchemaListCopyFieldsResponse.class);
        String realName = "copyfields";
        response.copyFields = this.listAllFieldsOfType("copyfields", this.params);
        return response;
    }

    @GET
    @Path(value="/dynamicfields")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaListDynamicFieldsResponse listDynamicFields() {
        SchemaListDynamicFieldsResponse response = this.instantiateJerseyResponse(SchemaListDynamicFieldsResponse.class);
        String realName = "dynamicfields";
        response.dynamicFields = this.listAllFieldsOfType("dynamicfields", this.params);
        return response;
    }

    @GET
    @Path(value="/dynamicfields/{fieldName}")
    @Produces(value={"application/json", "application/atom+xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaGetDynamicFieldInfoResponse getDynamicFieldInfo(@PathParam(value="fieldName") String fieldName) {
        if (fieldName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Dynamic field name must not be null");
        }
        SchemaGetDynamicFieldInfoResponse response = this.instantiateJerseyResponse(SchemaGetDynamicFieldInfoResponse.class);
        String realName = "dynamicfields";
        SimpleOrderedMap<Object> dynamicFieldInfo = this.retrieveFieldInfoOfType("dynamicfields", fieldName, this.params);
        if (dynamicFieldInfo != null) {
            response.dynamicFieldInfo = dynamicFieldInfo;
            return response;
        }
        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No such dynamic field [" + fieldName + "]");
    }

    @GET
    @Path(value="/fieldtypes")
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaListFieldTypesResponse listSchemaFieldTypes() {
        SchemaListFieldTypesResponse response = this.instantiateJerseyResponse(SchemaListFieldTypesResponse.class);
        String realName = "fieldtypes";
        response.fieldTypes = this.listAllFieldsOfType("fieldtypes", this.params);
        return response;
    }

    @GET
    @Path(value="/fieldtypes/{fieldTypeName}")
    @Produces(value={"application/json", "application/atom+xml", "application/vnd.apache.solr.javabin"})
    @PermissionName(value=PermissionNameProvider.Name.SCHEMA_READ_PERM)
    public SchemaGetFieldTypeInfoResponse getFieldTypeInfo(@PathParam(value="fieldTypeName") String fieldTypeName) {
        if (fieldTypeName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field type name must not be null");
        }
        SchemaGetFieldTypeInfoResponse response = this.instantiateJerseyResponse(SchemaGetFieldTypeInfoResponse.class);
        String realName = "fieldtypes";
        SimpleOrderedMap<Object> fieldTypeInfo = this.retrieveFieldInfoOfType("fieldtypes", fieldTypeName, this.params);
        if (fieldTypeInfo != null) {
            response.fieldTypeInfo = fieldTypeInfo;
            return response;
        }
        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No such field type [" + fieldTypeName + "]");
    }

    private List<Object> listAllFieldsOfType(String realName, SolrParams params) {
        String camelCaseRealName = IndexSchema.nameMapping.get(realName);
        Map<String, Object> propertyValues = this.indexSchema.getNamedPropertyValues(realName, params);
        List list = (List)propertyValues.get(camelCaseRealName);
        if (params.getBool("meta", false)) {
            this.insertPackageInfo(list);
        }
        return list;
    }

    private SimpleOrderedMap<Object> retrieveFieldInfoOfType(String realName, String fieldName, SolrParams params) {
        SimpleOrderedMap returnFieldInfo = null;
        String camelCaseRealName = IndexSchema.nameMapping.get(realName);
        Map<String, Object> propertyValues = this.indexSchema.getNamedPropertyValues(realName, params);
        Object o = propertyValues.get(camelCaseRealName);
        if (o instanceof List) {
            List list = (List)o;
            for (Object obj : list) {
                SimpleOrderedMap fieldInfo;
                if (!(obj instanceof SimpleOrderedMap) || !fieldName.equals((fieldInfo = (SimpleOrderedMap)obj).get("name"))) continue;
                returnFieldInfo = fieldInfo;
                if (!params.getBool("meta", false)) break;
                this.insertPackageInfo(returnFieldInfo);
                break;
            }
        }
        return returnFieldInfo;
    }

    private void insertPackageInfo(Object o) {
        if (o instanceof List) {
            List l = (List)o;
            for (Object o1 : l) {
                if (!(o1 instanceof NamedList) && !(o1 instanceof List)) continue;
                this.insertPackageInfo(o1);
            }
        } else if (o instanceof NamedList) {
            NamedList nl = (NamedList)o;
            nl.forEach((n, v) -> {
                if (v instanceof NamedList || v instanceof List) {
                    this.insertPackageInfo(v);
                }
            });
            Object v2 = nl.get("class");
            if (v2 instanceof String) {
                String klas = (String)v2;
                PluginInfo.ClassName parsedClassName = new PluginInfo.ClassName(klas);
                if (parsedClassName.pkg != null) {
                    MapWriter mw;
                    SolrClassLoader solrClassLoader = this.indexSchema.getSolrClassLoader();
                    MapWriter mapWriter = mw = solrClassLoader instanceof PackageListeningClassLoader ? ((PackageListeningClassLoader)solrClassLoader).getPackageVersion(parsedClassName) : null;
                    if (mw != null) {
                        nl.add("_packageinfo_", mw);
                    }
                }
            }
        }
    }

    public static class SchemaGetFieldTypeInfoResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="fieldType")
        public SimpleOrderedMap<?> fieldTypeInfo;
    }

    public static class SchemaListFieldTypesResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="fieldTypes")
        public List<Object> fieldTypes;
    }

    public static class SchemaGetDynamicFieldInfoResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="dynamicField")
        public SimpleOrderedMap<?> dynamicFieldInfo;
    }

    public static class SchemaListDynamicFieldsResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="dynamicFields")
        public List<Object> dynamicFields;
    }

    public static class SchemaListCopyFieldsResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="copyFields")
        public List<Object> copyFields;
    }

    public static class SchemaGetFieldInfoResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="field")
        public SimpleOrderedMap<?> fieldInfo;
    }

    public static class SchemaListFieldsResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="fields")
        public List<Object> fields;
    }
}

