/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.ModifyCollectionPayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/c/{collection}", "/collections/{collection}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
public class ModifyCollectionAPI {
    private static final String V2_MODIFY_COLLECTION_CMD = "modify";
    private final CollectionsHandler collectionsHandler;

    public ModifyCollectionAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @Command(name="modify")
    public void modifyCollection(PayloadObj<ModifyCollectionPayload> obj) throws Exception {
        ModifyCollectionPayload v2Body = obj.get();
        Map<String, Object> v1Params = v2Body.toMap(new HashMap<String, Object>());
        v1Params.put("action", CollectionParams.CollectionAction.MODIFYCOLLECTION.toLower());
        v1Params.put("collection", obj.getRequest().getPathTemplateValues().get("collection"));
        if (v2Body.config != null) {
            v1Params.remove("config");
            v1Params.put("collection.configName", v2Body.config);
        }
        if (v2Body.properties != null && !v2Body.properties.isEmpty()) {
            v1Params.remove("properties");
            V2ApiUtils.flattenMapWithPrefix(v2Body.properties, v1Params, "property.");
        }
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }
}

