/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.MoveReplicaPayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/c/{collection}", "/collections/{collection}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
public class MoveReplicaAPI {
    private static final String V2_MOVE_REPLICA_CMD = "move-replica";
    private final CollectionsHandler collectionsHandler;

    public MoveReplicaAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @Command(name="move-replica")
    public void moveReplica(PayloadObj<MoveReplicaPayload> obj) throws Exception {
        MoveReplicaPayload v2Body = obj.get();
        Map<String, Object> v1Params = v2Body.toMap(new HashMap<String, Object>());
        v1Params.put("action", CollectionParams.CollectionAction.MOVEREPLICA.toLower());
        v1Params.put("collection", obj.getRequest().getPathTemplateValues().get("collection"));
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }
}

