/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.jersey.JacksonReflectMapWriter;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/node/logging")
public class NodeLoggingAPI
extends JerseyResource {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CoreContainer coreContainer;
    private final LogWatcher<?> watcher;

    @Inject
    public NodeLoggingAPI(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.watcher = coreContainer.getLogging();
    }

    @Path(value="/levels")
    @GET
    @PermissionName(value=PermissionNameProvider.Name.CONFIG_READ_PERM)
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    public ListLevelsResponse listAllLoggersAndLevels() {
        this.ensureLogWatcherEnabled();
        ListLevelsResponse response = this.instantiateLoggingResponse(ListLevelsResponse.class);
        response.levels = this.watcher.getAllLevels();
        List loggerInfo = this.watcher.getAllLoggers().stream().sorted().map(li -> new LogLevelInfo(li.getName(), li.getLevel(), li.isSet())).collect(Collectors.toList());
        response.loggers = loggerInfo;
        return response;
    }

    @Path(value="/levels")
    @PUT
    @PermissionName(value=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    public LoggingResponse modifyLocalLogLevel(List<LogLevelChange> requestBody) {
        this.ensureLogWatcherEnabled();
        LoggingResponse response = this.instantiateLoggingResponse(LoggingResponse.class);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing request body");
        }
        for (LogLevelChange change : requestBody) {
            this.watcher.setLogLevel(change.logger, change.level);
        }
        return response;
    }

    @Path(value="/messages")
    @GET
    @PermissionName(value=PermissionNameProvider.Name.CONFIG_READ_PERM)
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    public LogMessagesResponse fetchLocalLogMessages(@QueryParam(value="since") Long boundingTimeMillis) {
        this.ensureLogWatcherEnabled();
        LogMessagesResponse response = this.instantiateLoggingResponse(LogMessagesResponse.class);
        if (boundingTimeMillis == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter, 'since'.");
        }
        AtomicBoolean found = new AtomicBoolean(false);
        SolrDocumentList docs = this.watcher.getHistory(boundingTimeMillis, found);
        if (docs == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "History not enabled");
        }
        LogMessageInfo info = new LogMessageInfo();
        if (boundingTimeMillis > 0L) {
            info.boundingTimeMillis = boundingTimeMillis;
            info.found = found.get();
        } else {
            info.levels = this.watcher.getAllLevels();
        }
        info.lastRecordTimestampMillis = this.watcher.getLastEvent();
        info.buffer = this.watcher.getHistorySize();
        response.info = info;
        response.docs = docs;
        return response;
    }

    @Path(value="/messages/threshold")
    @PUT
    @PermissionName(value=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    @Produces(value={"application/json", "application/xml", "application/vnd.apache.solr.javabin"})
    public LoggingResponse setMessageThreshold(SetThresholdRequestBody requestBody) {
        this.ensureLogWatcherEnabled();
        LoggingResponse response = this.instantiateLoggingResponse(LoggingResponse.class);
        if (requestBody == null || requestBody.level == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required parameter 'level' missing");
        }
        this.watcher.setThreshold(requestBody.level);
        return response;
    }

    public static void writeLogsForTesting() {
        log.trace("trace message");
        log.debug("debug message");
        RuntimeException exc = new RuntimeException("test");
        log.info("info (with exception) INFO", (Throwable)exc);
        log.warn("warn (with exception) WARN", (Throwable)exc);
        log.error("error (with exception) ERROR", (Throwable)exc);
    }

    private void ensureLogWatcherEnabled() {
        if (this.watcher == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Logging Not Initialized");
        }
    }

    private <T extends LoggingResponse> T instantiateLoggingResponse(Class<T> clazz) {
        LoggingResponse response = (LoggingResponse)this.instantiateJerseyResponse(clazz);
        response.watcherName = this.watcher.getName();
        return (T)response;
    }

    public static class LogLevelInfo
    implements JacksonReflectMapWriter {
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="level")
        public String level;
        @JsonProperty(value="set")
        public boolean set;

        public LogLevelInfo() {
        }

        public LogLevelInfo(String name, String level, boolean set) {
            this.name = name;
            this.level = level;
            this.set = set;
        }
    }

    public static class ListLevelsResponse
    extends LoggingResponse {
        @JsonProperty
        public List<String> levels;
        @JsonProperty
        public List<LogLevelInfo> loggers;
    }

    public static class LogMessageInfo
    implements JacksonReflectMapWriter {
        @JsonProperty(value="since")
        public Long boundingTimeMillis;
        @JsonProperty
        public Boolean found;
        @JsonProperty
        public List<String> levels;
        @JsonProperty(value="last")
        public long lastRecordTimestampMillis;
        @JsonProperty
        public int buffer;
        @JsonProperty
        public String threshold;
    }

    public static class LogMessagesResponse
    extends LoggingResponse {
        @JsonProperty
        public LogMessageInfo info;
        @JsonProperty(value="history")
        public SolrDocumentList docs;
    }

    public static class SetThresholdRequestBody
    implements JacksonReflectMapWriter {
        @JsonProperty(required=true)
        public String level;

        public SetThresholdRequestBody() {
        }

        public SetThresholdRequestBody(String level) {
            this.level = level;
        }
    }

    public static class LogLevelChange
    implements JacksonReflectMapWriter {
        @JsonProperty
        public String logger;
        @JsonProperty
        public String level;

        public LogLevelChange() {
        }

        public LogLevelChange(String logger, String level) {
            this.logger = logger;
            this.level = level;
        }

        public static List<LogLevelChange> createRequestBodyFromV1Params(String[] rawChangeValues) {
            ArrayList<LogLevelChange> changes = new ArrayList<LogLevelChange>();
            for (String rawChange : rawChangeValues) {
                String[] split = rawChange.split(":");
                if (split.length != 2) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid format, expected level:value, got " + rawChange);
                }
                changes.add(new LogLevelChange(split[0], split[1]));
            }
            return changes;
        }
    }

    public static class LoggingResponse
    extends SolrJerseyResponse {
        @JsonProperty(value="watcher")
        public String watcherName;
    }
}

