/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import org.apache.solr.client.api.endpoint.ReloadCollectionApi;
import org.apache.solr.client.api.model.ReloadCollectionRequestBody;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadCollectionAPI
extends AdminAPIBase
implements ReloadCollectionApi {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public ReloadCollectionAPI(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse reloadCollection(String collectionName, ReloadCollectionRequestBody requestBody) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.fetchAndValidateZooKeeperAwareCoreContainer();
        ReloadCollectionAPI.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = ReloadCollectionAPI.createRemoteMessage(collectionName, requestBody);
        this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.RELOAD, remoteMessage, requestBody != null ? requestBody.async : null);
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, ReloadCollectionRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.RELOAD.toLower());
        remoteMessage.put("name", collectionName);
        if (requestBody != null) {
            ReloadCollectionAPI.insertIfNotNull(remoteMessage, "async", requestBody.async);
        }
        return new ZkNodeProps(remoteMessage);
    }

    public static void invokeFromV1Params(CoreContainer coreContainer, SolrQueryRequest request, SolrQueryResponse response) throws Exception {
        ReloadCollectionAPI api = new ReloadCollectionAPI(coreContainer, request, response);
        SolrParams params = request.getParams();
        params.required().check("name");
        ReloadCollectionRequestBody requestBody = new ReloadCollectionRequestBody();
        requestBody.async = params.get("async");
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(response, api.reloadCollection(params.get("name"), requestBody));
    }
}

