/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.HashMap;
import org.apache.solr.client.api.endpoint.RenameCollectionApi;
import org.apache.solr.client.api.model.RenameCollectionRequestBody;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class RenameCollection
extends AdminAPIBase
implements RenameCollectionApi {
    @Inject
    public RenameCollection(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse renameCollection(String collectionName, RenameCollectionRequestBody requestBody) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required request body");
        }
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("to", requestBody.to);
        this.fetchAndValidateZooKeeperAwareCoreContainer();
        RenameCollection.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        ZkNodeProps remoteMessage = RenameCollection.createRemoteMessage(collectionName, requestBody);
        this.submitRemoteMessageAndHandleResponse(response, CollectionParams.CollectionAction.RENAME, remoteMessage, requestBody != null ? requestBody.async : null);
        return response;
    }

    public static ZkNodeProps createRemoteMessage(String collectionName, RenameCollectionRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.RENAME.toLower());
        remoteMessage.put("name", collectionName);
        remoteMessage.put("target", requestBody.to);
        RenameCollection.insertIfNotNull(remoteMessage, "followAliases", requestBody.followAliases);
        RenameCollection.insertIfNotNull(remoteMessage, "async", requestBody.async);
        return new ZkNodeProps(remoteMessage);
    }

    public static void invokeFromV1Params(CoreContainer coreContainer, SolrQueryRequest request, SolrQueryResponse response) throws Exception {
        RenameCollection api = new RenameCollection(coreContainer, request, response);
        SolrParams params = request.getParams();
        params.required().check("collection", "target");
        RenameCollectionRequestBody requestBody = new RenameCollectionRequestBody();
        requestBody.to = params.get("target");
        requestBody.async = params.get("async");
        requestBody.followAliases = params.getBool("followAliases");
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(response, api.renameCollection(params.get("collection"), requestBody));
    }
}

