/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.RequestSyncShardPayload;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/cores/{core}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.CORE_EDIT_PERM)
public class RequestSyncShardAPI {
    public static final String V2_REQUEST_SYNC_SHARD_CMD = "request-sync-shard";
    private final CoreAdminHandler coreAdminHandler;

    public RequestSyncShardAPI(CoreAdminHandler coreAdminHandler) {
        this.coreAdminHandler = coreAdminHandler;
    }

    @Command(name="request-sync-shard")
    public void requestSyncShard(PayloadObj<RequestSyncShardPayload> obj) throws Exception {
        RequestSyncShardPayload v2Body = obj.get();
        Map<String, Object> v1Params = v2Body.toMap(new HashMap<String, Object>());
        v1Params.put("action", CoreAdminParams.CoreAdminAction.REQUESTSYNCSHARD.name().toLowerCase(Locale.ROOT));
        v1Params.put("core", obj.getRequest().getPathTemplateValues().get("core"));
        this.coreAdminHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }
}

