/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.net.URI;
import org.apache.solr.client.api.endpoint.RestoreCoreApi;
import org.apache.solr.client.api.model.RestoreCoreRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.backup.ShardBackupId;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.admin.api.CoreAdminAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.update.UpdateLog;

public class RestoreCore
extends CoreAdminAPIBase
implements RestoreCoreApi {
    @Inject
    public RestoreCore(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse, CoreAdminHandler.CoreAdminAsyncTracker coreAdminAsyncTracker) {
        super(coreContainer, coreAdminAsyncTracker, solrQueryRequest, solrQueryResponse);
    }

    @Override
    boolean isExpensive() {
        return true;
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.CORE_EDIT_PERM)
    public SolrJerseyResponse restoreCore(String coreName, RestoreCoreRequestBody requestBody) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        this.ensureRequiredParameterProvided("coreName", coreName);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required request body");
        }
        RestoreCore.validateRequestBody(requestBody);
        AdminAPIBase.validateZooKeeperAwareCoreContainer(this.coreContainer);
        return this.handlePotentiallyAsynchronousTask(response, coreName, requestBody.async, "restoreCore", () -> {
            try {
                this.doRestore(coreName, requestBody);
                return response;
            }
            catch (Exception e) {
                throw new CoreAdminAPIBase.CoreAdminAPIBaseException(e);
            }
        });
    }

    private void doRestore(String coreName, RestoreCoreRequestBody requestBody) throws Exception {
        try (BackupRepository repository = this.coreContainer.newBackupRepository(requestBody.backupRepository);
             SolrCore core = this.coreContainer.getCore(coreName);){
            org.apache.solr.handler.RestoreCore restoreCore;
            String location = repository.getBackupLocation(requestBody.location);
            if (location == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'location' is not specified as a query parameter or as a default repository property");
            }
            URI locationUri = repository.createDirectoryURI(location);
            CloudDescriptor cd = core.getCoreDescriptor().getCloudDescriptor();
            Slice slice = this.coreContainer.getZkController().getClusterState().getCollection(cd.getCollectionName()).getSlice(cd.getShardId());
            if (slice.getReplicas().size() != 1 && !core.readOnly) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to restore core=" + core.getName() + ", the core must be the only replica in its shard or it must be read only");
            }
            if (requestBody.shardBackupId != null) {
                ShardBackupId shardBackupId = ShardBackupId.from(requestBody.shardBackupId);
                restoreCore = org.apache.solr.handler.RestoreCore.createWithMetaFile(repository, core, locationUri, shardBackupId);
            } else {
                restoreCore = org.apache.solr.handler.RestoreCore.create(repository, core, locationUri, requestBody.name);
            }
            boolean success = restoreCore.doRestore();
            if (!success) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to restore core=" + core.getName());
            }
            this.coreContainer.getZkController().getShardTerms(cd.getCollectionName(), cd.getShardId()).ensureHighestTermsAreNotZero();
            UpdateLog updateLog = core.getUpdateHandler().getUpdateLog();
            if (updateLog != null) {
                updateLog.applyBufferedUpdates();
            }
        }
    }

    public static void validateRequestBody(RestoreCoreRequestBody requestBody) {
        if (requestBody.shardBackupId == null && requestBody.name == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either 'name' or 'shardBackupId' must be specified");
        }
    }
}

