/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.annotation.JsonProperty;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.util.ReflectMapWriter;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/cores/{core}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.CORE_EDIT_PERM)
public class SplitCoreAPI {
    private static final String V2_SPLIT_CORE_CMD = "split";
    private final CoreAdminHandler coreHandler;

    public SplitCoreAPI(CoreAdminHandler coreHandler) {
        this.coreHandler = coreHandler;
    }

    @Command(name="split")
    public void splitCore(PayloadObj<SplitCorePayload> obj) throws Exception {
        SplitCorePayload v2Body = obj.get();
        Map<String, Object> v1Params = v2Body.toMap(new HashMap<String, Object>());
        v1Params.put("action", CoreAdminParams.CoreAdminAction.SPLIT.name().toLowerCase(Locale.ROOT));
        v1Params.put("core", obj.getRequest().getPathTemplateValues().get("core"));
        if (v2Body.path != null && !v2Body.path.isEmpty()) {
            v1Params.put("path", v2Body.path.toArray(new String[0]));
        }
        if (v2Body.targetCore != null && !v2Body.targetCore.isEmpty()) {
            v1Params.put("targetCore", v2Body.targetCore.toArray(new String[0]));
        }
        if (v2Body.splitKey != null) {
            v1Params.put("split.key", v1Params.remove("splitKey"));
        }
        this.coreHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }

    public static class SplitCorePayload
    implements ReflectMapWriter {
        @JsonProperty
        public List<String> path;
        @JsonProperty
        public List<String> targetCore;
        @JsonProperty
        public String splitKey;
        @JsonProperty
        public String splitMethod;
        @JsonProperty
        public Boolean getRanges;
        @JsonProperty
        public String ranges;
        @JsonProperty
        public String async;
    }
}

