/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.SplitShardPayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/c/{collection}/shards", "/collections/{collection}/shards"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
public class SplitShardAPI {
    private static final String V2_SPLIT_CMD = "split";
    private final CollectionsHandler collectionsHandler;

    public SplitShardAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @Command(name="split")
    public void splitShard(PayloadObj<SplitShardPayload> obj) throws Exception {
        SplitShardPayload v2Body = obj.get();
        Map<String, Object> v1Params = v2Body.toMap(new HashMap<String, Object>());
        v1Params.put("action", CollectionParams.CollectionAction.SPLITSHARD.toLower());
        v1Params.put("collection", obj.getRequest().getPathTemplateValues().get("collection"));
        if (StrUtils.isNotNullOrEmpty(v2Body.splitKey)) {
            v1Params.put("split.key", v2Body.splitKey);
        }
        V2ApiUtils.flattenMapWithPrefix(v2Body.coreProperties, v1Params, "property.");
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }
}

