/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.api.endpoint.SyncShardApi;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class SyncShard
extends AdminAPIBase
implements SyncShardApi {
    @Inject
    public SyncShard(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @Override
    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse syncShard(String collectionName, String shardName) throws Exception {
        SolrJerseyResponse response = this.instantiateJerseyResponse(SolrJerseyResponse.class);
        this.ensureRequiredParameterProvided("collection", collectionName);
        this.ensureRequiredParameterProvided("shard", shardName);
        this.fetchAndValidateZooKeeperAwareCoreContainer();
        SyncShard.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        this.doSyncShard(collectionName, shardName);
        return response;
    }

    private void doSyncShard(String extCollectionName, String shardName) throws IOException, SolrServerException {
        String collection = this.coreContainer.getAliases().resolveSimpleAlias(extCollectionName);
        ClusterState clusterState = this.coreContainer.getZkController().getClusterState();
        DocCollection docCollection = clusterState.getCollection(collection);
        Replica leaderProps = docCollection.getLeader(shardName);
        ZkCoreNodeProps nodeProps = new ZkCoreNodeProps(leaderProps);
        try (HttpSolrClient client = ((HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(nodeProps.getBaseUrl()).withConnectionTimeout(15000, TimeUnit.MILLISECONDS)).withSocketTimeout(60000, TimeUnit.MILLISECONDS)).build();){
            CoreAdminRequest.RequestSyncShard reqSyncShard = new CoreAdminRequest.RequestSyncShard();
            reqSyncShard.setCollection(collection);
            reqSyncShard.setShard(shardName);
            reqSyncShard.setCoreName(nodeProps.getCoreName());
            client.request(reqSyncShard);
        }
    }

    public static void invokeFromV1Params(CoreContainer coreContainer, SolrQueryRequest request, SolrQueryResponse response) throws Exception {
        SyncShard api = new SyncShard(coreContainer, request, response);
        SolrParams params = request.getParams();
        params.required().check("collection", "shard");
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(response, api.syncShard(params.get("collection"), params.get("shard")));
    }
}

