/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;

public class ActiveTasksListComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "activetaskslist";
    private boolean shouldProcess;

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.isTaskListRequest()) {
            this.shouldProcess = true;
        }
    }

    @Override
    public void process(ResponseBuilder rb) {
        if (!this.shouldProcess) {
            return;
        }
        if (rb.getTaskStatusCheckUUID() != null) {
            boolean isActiveOnThisShard = rb.req.getCore().getCancellableQueryTracker().isQueryIdActive(rb.getTaskStatusCheckUUID());
            rb.rsp.add("taskStatus", isActiveOnThisShard);
            return;
        }
        rb.rsp.add("taskList", ew -> {
            Iterator<Map.Entry<String, String>> iterator = rb.req.getCore().getCancellableQueryTracker().getActiveQueriesGenerated();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                ew.put((CharSequence)entry.getKey(), entry.getValue());
            }
        });
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!this.shouldProcess) {
            return;
        }
        NamedList<String> resultList = new NamedList<String>();
        for (ShardResponse r : sreq.responses) {
            if (rb.getTaskStatusCheckUUID() != null) {
                boolean isTaskActiveOnShard = r.getSolrResponse().getResponse().getBooleanArg("taskStatus");
                if (!isTaskActiveOnShard) continue;
                rb.rsp.getValues().add("taskStatus", "id:" + rb.getTaskStatusCheckUUID() + ", status: active");
                return;
            }
            LinkedHashMap result = (LinkedHashMap)r.getSolrResponse().getResponse().get("taskList");
            for (Map.Entry entry : result.entrySet()) {
                resultList.add((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (rb.getTaskStatusCheckUUID() != null) {
            rb.rsp.getValues().add("taskStatus", "id:" + rb.getTaskStatusCheckUUID() + ", status: inactive");
            return;
        }
        rb.rsp.getValues().add("taskList", resultList);
    }

    @Override
    public String getDescription() {
        return "Responsible for listing all active cancellable tasks and also supports checking the status of a particular task";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.OTHER;
    }
}

