/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.handler.component.StatsField;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;

public class FieldFacetStats {
    public final String name;
    final StatsField statsField;
    final SchemaField facet_sf;
    public final Map<String, StatsValues> facetStatsValues;
    private final Map<Integer, Integer> missingStats;
    List<HashMap<String, Integer>> facetStatsTerms;
    final LeafReader topLevelReader;
    LeafReaderContext leave;
    final ValueSource valueSource;
    LeafReaderContext context;
    FunctionValues values;
    SortedDocValues topLevelSortedValues = null;

    public FieldFacetStats(SolrIndexSearcher searcher, SchemaField facet_sf, StatsField statsField) {
        this.statsField = statsField;
        this.facet_sf = facet_sf;
        this.name = facet_sf.getName();
        this.topLevelReader = searcher.getSlowAtomicReader();
        this.valueSource = facet_sf.getType().getValueSource(facet_sf, null);
        this.facetStatsValues = new HashMap<String, StatsValues>();
        this.facetStatsTerms = new ArrayList<HashMap<String, Integer>>();
        this.missingStats = new HashMap<Integer, Integer>();
    }

    private StatsValues getStatsValues(String key) throws IOException {
        StatsValues stats = this.facetStatsValues.get(key);
        if (stats == null) {
            stats = StatsValuesFactory.createStatsValues(this.statsField);
            this.facetStatsValues.put(key, stats);
            stats.setNextReader(this.context);
        }
        return stats;
    }

    public void facet(int docID) throws IOException {
        String key = this.values.exists(docID) ? this.values.strVal(docID) : null;
        StatsValues stats = this.getStatsValues(key);
        stats.accumulate(docID);
    }

    public boolean facetTermNum(int docID, int statsTermNum) throws IOException {
        int term;
        int arrIdx;
        if (this.topLevelSortedValues == null) {
            this.topLevelSortedValues = DocValues.getSorted(this.topLevelReader, this.name);
        }
        if (docID > this.topLevelSortedValues.docID()) {
            this.topLevelSortedValues.advance(docID);
        }
        if ((arrIdx = (term = docID == this.topLevelSortedValues.docID() ? this.topLevelSortedValues.ordValue() : -1)) >= 0 && arrIdx < this.topLevelSortedValues.getValueCount()) {
            String key = term == -1 ? null : this.topLevelSortedValues.lookupOrd(term).utf8ToString();
            while (this.facetStatsTerms.size() <= statsTermNum) {
                this.facetStatsTerms.add(new HashMap());
            }
            Map statsTermCounts = this.facetStatsTerms.get(statsTermNum);
            Integer statsTermCount = (Integer)statsTermCounts.get(key);
            if (statsTermCount == null) {
                statsTermCounts.put(key, 1);
            } else {
                statsTermCounts.put(key, statsTermCount + 1);
            }
            return true;
        }
        return false;
    }

    public boolean accumulateTermNum(int statsTermNum, BytesRef value) throws IOException {
        if (value == null) {
            return false;
        }
        while (this.facetStatsTerms.size() <= statsTermNum) {
            this.facetStatsTerms.add(new HashMap());
        }
        for (Map.Entry<String, Integer> pairs : this.facetStatsTerms.get(statsTermNum).entrySet()) {
            Integer count;
            String key = pairs.getKey();
            StatsValues facetStats = this.facetStatsValues.get(key);
            if (facetStats == null) {
                facetStats = StatsValuesFactory.createStatsValues(this.statsField);
                this.facetStatsValues.put(key, facetStats);
            }
            if ((count = pairs.getValue()) == null) continue;
            facetStats.accumulate(value, count);
        }
        return true;
    }

    public void setNextReader(LeafReaderContext ctx) throws IOException {
        this.context = ctx;
        this.values = this.valueSource.getValues(Collections.emptyMap(), ctx);
        for (StatsValues stats : this.facetStatsValues.values()) {
            stats.setNextReader(ctx);
        }
    }

    public void facetMissingNum(int docID) throws IOException {
        if (this.topLevelSortedValues == null) {
            this.topLevelSortedValues = DocValues.getSorted(this.topLevelReader, this.name);
        }
        if (docID > this.topLevelSortedValues.docID()) {
            this.topLevelSortedValues.advance(docID);
        }
        if (docID == this.topLevelSortedValues.docID()) {
            int ord = this.topLevelSortedValues.ordValue();
            Integer missingCount = this.missingStats.get(ord);
            if (missingCount == null) {
                this.missingStats.put(ord, 1);
            } else {
                this.missingStats.put(ord, missingCount + 1);
            }
        }
    }

    public void accumulateMissing() throws IOException {
        for (Map.Entry<Integer, Integer> entry : this.missingStats.entrySet()) {
            String key;
            StatsValues statsValue;
            if (entry.getKey() < 0 || (statsValue = this.facetStatsValues.get(key = this.topLevelSortedValues.lookupOrd(entry.getKey()).utf8ToString())) == null) continue;
            statsValue.addMissing(entry.getValue());
        }
    }
}

