/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.BitSet;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.PivotFacetField;
import org.apache.solr.handler.component.PivotFacetHelper;
import org.apache.solr.handler.component.RangeFacetRequest;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.StatsComponent;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.util.PivotListEntry;

public class PivotFacetValue {
    private final BitSet sourceShards = new BitSet();
    private final PivotFacetField parentPivot;
    private final Comparable value;
    private PivotFacetField childPivot = null;
    private int count;
    private Map<String, StatsValues> statsValues = null;
    private NamedList<Number> queryCounts;
    private LinkedHashMap<String, RangeFacetRequest.DistribRangeFacet> rangeCounts;

    private PivotFacetValue(PivotFacetField parent, Comparable val) {
        this.parentPivot = parent;
        this.value = val;
    }

    public Comparable getValue() {
        return this.value;
    }

    public int getCount() {
        return this.count;
    }

    public PivotFacetField getChildPivot() {
        return this.childPivot;
    }

    public List<String> getValuePath() {
        List<String> out = this.parentPivot.getValuePath();
        if (null == this.value) {
            out.add(null);
        } else if (this.value instanceof Date) {
            out.add(((Date)this.value).toInstant().toString());
        } else {
            out.add(this.value.toString());
        }
        return out;
    }

    public static PivotFacetValue createFromNamedList(int shardNumber, ResponseBuilder rb, PivotFacetField parentField, NamedList<Object> pivotData) {
        Comparable pivotVal = null;
        int pivotCount = 0;
        List childPivotData = null;
        NamedList statsValues = null;
        NamedList queryCounts = null;
        SimpleOrderedMap ranges = null;
        block9: for (int i = 0; i < pivotData.size(); ++i) {
            String key = pivotData.getName(i);
            Object value = pivotData.getVal(i);
            PivotListEntry entry = PivotListEntry.get(key);
            switch (entry) {
                case VALUE: {
                    pivotVal = (Comparable)value;
                    continue block9;
                }
                case FIELD: {
                    assert (parentField.field.equals(value)) : "Parent Field mismatch: " + parentField.field + "!=" + value;
                    continue block9;
                }
                case COUNT: {
                    pivotCount = (Integer)value;
                    continue block9;
                }
                case PIVOT: {
                    childPivotData = (List)value;
                    continue block9;
                }
                case STATS: {
                    statsValues = (NamedList)value;
                    continue block9;
                }
                case QUERIES: {
                    queryCounts = (NamedList)value;
                    continue block9;
                }
                case RANGES: {
                    ranges = (SimpleOrderedMap)value;
                    continue block9;
                }
                default: {
                    throw new RuntimeException("PivotListEntry contains unaccounted for item: " + entry);
                }
            }
        }
        PivotFacetValue newPivotFacet = new PivotFacetValue(parentField, pivotVal);
        newPivotFacet.count = pivotCount;
        newPivotFacet.sourceShards.set(shardNumber);
        if (statsValues != null) {
            newPivotFacet.statsValues = PivotFacetHelper.mergeStats(null, statsValues, rb._statsInfo);
        }
        if (queryCounts != null) {
            newPivotFacet.queryCounts = PivotFacetHelper.mergeQueryCounts(null, queryCounts);
        }
        if (ranges != null) {
            newPivotFacet.rangeCounts = new LinkedHashMap();
            RangeFacetRequest.DistribRangeFacet.mergeFacetRangesFromShardResponse(newPivotFacet.rangeCounts, ranges);
        }
        newPivotFacet.childPivot = PivotFacetField.createFromListOfNamedLists(shardNumber, rb, newPivotFacet, childPivotData);
        return newPivotFacet;
    }

    public boolean shardHasContributed(int shardNum) {
        return this.sourceShards.get(shardNum);
    }

    public NamedList<Object> convertToNamedList() {
        SimpleOrderedMap<Object> newList = new SimpleOrderedMap<Object>();
        newList.add(PivotListEntry.FIELD.getName(), this.parentPivot.field);
        newList.add(PivotListEntry.VALUE.getName(), this.value);
        newList.add(PivotListEntry.COUNT.getName(), this.count);
        if (this.queryCounts != null) {
            newList.add(PivotListEntry.QUERIES.getName(), this.queryCounts);
        }
        if (this.rangeCounts != null) {
            SimpleOrderedMap<SimpleOrderedMap<Object>> rangeFacetOutput = new SimpleOrderedMap<SimpleOrderedMap<Object>>();
            for (Map.Entry<String, RangeFacetRequest.DistribRangeFacet> entry : this.rangeCounts.entrySet()) {
                String key = entry.getKey();
                RangeFacetRequest.DistribRangeFacet value = entry.getValue();
                rangeFacetOutput.add(key, value.rangeFacet);
            }
            newList.add(PivotListEntry.RANGES.getName(), rangeFacetOutput);
        }
        if (this.childPivot != null && this.childPivot.convertToListOfNamedLists() != null) {
            newList.add(PivotListEntry.PIVOT.getName(), this.childPivot.convertToListOfNamedLists());
        }
        if (null != this.statsValues) {
            newList.add(PivotListEntry.STATS.getName(), StatsComponent.convertToResponse(this.statsValues));
        }
        return newList;
    }

    public void mergeContributionFromShard(int shardNumber, ResponseBuilder rb, NamedList<Object> value) {
        assert (null != value) : "can't merge in null data";
        if (!this.shardHasContributed(shardNumber)) {
            SimpleOrderedMap<SimpleOrderedMap<Object>> shardRanges;
            NamedList<Number> shardQueryCounts;
            this.sourceShards.set(shardNumber);
            this.count += PivotFacetHelper.getCount(value).intValue();
            NamedList<NamedList<NamedList<?>>> stats = PivotFacetHelper.getStats(value);
            if (stats != null) {
                this.statsValues = PivotFacetHelper.mergeStats(this.statsValues, stats, rb._statsInfo);
            }
            if ((shardQueryCounts = PivotFacetHelper.getQueryCounts(value)) != null) {
                this.queryCounts = PivotFacetHelper.mergeQueryCounts(this.queryCounts, shardQueryCounts);
            }
            if ((shardRanges = PivotFacetHelper.getRanges(value)) != null) {
                if (this.rangeCounts == null) {
                    this.rangeCounts = CollectionUtil.newLinkedHashMap(shardRanges.size() / 2);
                }
                RangeFacetRequest.DistribRangeFacet.mergeFacetRangesFromShardResponse(this.rangeCounts, shardRanges);
            }
        }
        List<NamedList<Object>> shardChildPivots = PivotFacetHelper.getPivots(value);
        if (null == this.childPivot) {
            this.childPivot = PivotFacetField.createFromListOfNamedLists(shardNumber, rb, this, shardChildPivots);
        } else {
            this.childPivot.contributeFromShard(shardNumber, rb, shardChildPivots);
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "F:%s V:%s Co:%d Ch?:%s", this.parentPivot.field, this.value, this.count, this.childPivot != null);
    }
}

