/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.DebugComponent;
import org.apache.solr.handler.component.ExpandComponent;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.HighlightComponent;
import org.apache.solr.handler.component.MoreLikeThisComponent;
import org.apache.solr.handler.component.QueryComponent;
import org.apache.solr.handler.component.RealTimeGetComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.StatsComponent;
import org.apache.solr.handler.component.TermsComponent;
import org.apache.solr.metrics.SolrMetricsContext;
import org.apache.solr.search.facet.FacetModule;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;

public abstract class SearchComponent
implements SolrInfoBean,
NamedListInitializedPlugin {
    private String name = this.getClass().getName();
    protected SolrMetricsContext solrMetricsContext;
    public static final Map<String, Class<? extends SearchComponent>> standard_components;

    public abstract void prepare(ResponseBuilder var1) throws IOException;

    public abstract void process(ResponseBuilder var1) throws IOException;

    public int distributedProcess(ResponseBuilder rb) throws IOException {
        return ResponseBuilder.STAGE_DONE;
    }

    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
    }

    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
    }

    public void finishStage(ResponseBuilder rb) {
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public abstract String getDescription();

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.OTHER;
    }

    @Override
    public SolrMetricsContext getSolrMetricsContext() {
        return this.solrMetricsContext;
    }

    @Override
    public void initializeMetrics(SolrMetricsContext parentContext, String scope) {
        this.solrMetricsContext = parentContext.getChildContext(this);
    }

    static {
        HashMap<String, Class> map = new HashMap<String, Class>();
        map.put("highlight", HighlightComponent.class);
        map.put("query", QueryComponent.class);
        map.put("facet", FacetComponent.class);
        map.put("facet_module", FacetModule.class);
        map.put("mlt", MoreLikeThisComponent.class);
        map.put("stats", StatsComponent.class);
        map.put("debug", DebugComponent.class);
        map.put("get", RealTimeGetComponent.class);
        map.put("expand", ExpandComponent.class);
        map.put("terms", TermsComponent.class);
        standard_components = Collections.unmodifiableMap(map);
    }
}

