/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.CloudReplicaSource;
import org.apache.solr.handler.component.ReplicaSource;
import org.apache.solr.security.AllowListUrlChecker;

class StandaloneReplicaSource
implements ReplicaSource {
    private final List<String>[] replicas;

    public StandaloneReplicaSource(Builder builder) {
        List<String> list = StrUtils.splitSmart(builder.shardsParam, ",", true);
        this.replicas = (List[])Array.newInstance(List.class, list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.replicas[i] = StrUtils.splitSmart(list.get(i), "|", true);
            CloudReplicaSource.checkUrlsAllowList(builder.urlChecker, null, builder.shardsParam, this.replicas[i]);
        }
    }

    @Override
    public List<String> getSliceNames() {
        return Collections.emptyList();
    }

    @Override
    public int getSliceCount() {
        return this.replicas.length;
    }

    @Override
    public List<String> getReplicasBySlice(int sliceNumber) {
        assert (sliceNumber >= 0 && sliceNumber < this.replicas.length);
        return this.replicas[sliceNumber];
    }

    static class Builder {
        private String shardsParam;
        private AllowListUrlChecker urlChecker;

        Builder() {
        }

        public Builder shards(String shardsParam) {
            this.shardsParam = shardsParam;
            return this;
        }

        public Builder allowListUrlChecker(AllowListUrlChecker urlChecker) {
            this.urlChecker = urlChecker;
            return this;
        }

        public StandaloneReplicaSource build() {
            return new StandaloneReplicaSource(this);
        }
    }
}

