/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.hash.HashFunction;
import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.TDigest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.EnumFieldValue;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.SortedDateStatsValues;
import org.apache.solr.handler.component.SortedNumericStatsValues;
import org.apache.solr.handler.component.StatsField;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.schema.AbstractEnumField;
import org.apache.solr.schema.DatePointField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.PointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.util.hll.HLL;
import org.apache.solr.util.hll.HLLType;

public class StatsValuesFactory {
    public static StatsValues createStatsValues(StatsField statsField) {
        SchemaField sf = statsField.getSchemaField();
        if (null == sf) {
            return new NumericStatsValues(statsField);
        }
        FieldType fieldType = sf.getType();
        if (TrieDateField.class.isInstance(fieldType) || DatePointField.class.isInstance(fieldType)) {
            DateStatsValues statsValues = new DateStatsValues(statsField);
            if (sf.multiValued()) {
                return new SortedDateStatsValues(statsValues, statsField);
            }
            return statsValues;
        }
        if (TrieField.class.isInstance(fieldType) || PointField.class.isInstance(fieldType)) {
            NumericStatsValues statsValue = new NumericStatsValues(statsField);
            if (sf.multiValued()) {
                return new SortedNumericStatsValues(statsValue, statsField);
            }
            return statsValue;
        }
        if (StrField.class.isInstance(fieldType)) {
            return new StringStatsValues(statsField);
        }
        if (AbstractEnumField.class.isInstance(fieldType)) {
            return new EnumStatsValues(statsField);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field type " + fieldType + " is not currently supported");
    }

    private static class StringStatsValues
    extends AbstractStatsValues<String> {
        public StringStatsValues(StatsField statsField) {
            super(statsField);
        }

        @Override
        public long hash(String v) {
            return this.hasher.hashString((CharSequence)v, StandardCharsets.UTF_8).asLong();
        }

        @Override
        public void accumulate(int docID) throws IOException {
            if (this.values.exists(docID)) {
                String value = this.values.strVal(docID);
                if (value != null) {
                    this.accumulate(value, 1);
                } else {
                    this.missing();
                }
            } else {
                this.missing();
            }
        }

        @Override
        protected void updateTypeSpecificStats(NamedList<?> stv) {
        }

        @Override
        protected void updateTypeSpecificStats(String value, int count) {
        }

        @Override
        protected void updateMinMax(String min, String max) {
            if (this.computeMin) {
                this.min = StringStatsValues.min((String)this.min, min);
            }
            if (this.computeMax) {
                this.max = StringStatsValues.max((String)this.max, max);
            }
        }

        @Override
        protected void addTypeSpecificStats(NamedList<Object> res) {
        }

        private static String max(String str1, String str2) {
            if (str1 == null) {
                return str2;
            }
            if (str2 == null) {
                return str1;
            }
            return str1.compareTo(str2) > 0 ? str1 : str2;
        }

        private static String min(String str1, String str2) {
            if (str1 == null) {
                return str2;
            }
            if (str2 == null) {
                return str1;
            }
            return str1.compareTo(str2) < 0 ? str1 : str2;
        }
    }

    static class DateStatsValues
    extends AbstractStatsValues<Date> {
        private double sum = 0.0;
        double sumOfSquares = 0.0;
        protected final boolean computeSum;
        protected final boolean computeSumOfSquares;

        public DateStatsValues(StatsField statsField) {
            super(statsField);
            this.computeSum = statsField.calculateStats(StatsField.Stat.sum);
            this.computeSumOfSquares = statsField.calculateStats(StatsField.Stat.sumOfSquares);
        }

        @Override
        public long hash(Date v) {
            return this.hasher.hashLong(v.getTime()).asLong();
        }

        @Override
        public void accumulate(int docID) throws IOException {
            if (this.values.exists(docID)) {
                this.accumulate((Date)this.values.objectVal(docID), 1);
            } else {
                this.missing();
            }
        }

        @Override
        protected void updateTypeSpecificStats(NamedList<?> stv) {
            if (this.computeSum) {
                this.sum += ((Number)stv.get("sum")).doubleValue();
            }
            if (this.computeSumOfSquares) {
                this.sumOfSquares += ((Number)stv.get("sumOfSquares")).doubleValue();
            }
        }

        @Override
        public void updateTypeSpecificStats(Date v, int count) {
            long value = v.getTime();
            if (this.computeSumOfSquares) {
                this.sumOfSquares += (double)value * (double)value * (double)count;
            }
            if (this.computeSum) {
                this.sum += (double)(value * (long)count);
            }
        }

        @Override
        protected void updateMinMax(Date min, Date max) {
            if (this.computeMin && null != min && (this.min == null || ((Date)this.min).after(min))) {
                this.min = min;
            }
            if (this.computeMax && null != max && (this.max == null || ((Date)this.max).before(max))) {
                this.max = max;
            }
        }

        @Override
        protected void addTypeSpecificStats(NamedList<Object> res) {
            if (this.statsField.includeInResponse(StatsField.Stat.sum)) {
                res.add("sum", this.sum);
            }
            if (this.statsField.includeInResponse(StatsField.Stat.mean)) {
                res.add("mean", this.count > 0L ? new Date((long)(this.sum / (double)this.count)) : null);
            }
            if (this.statsField.includeInResponse(StatsField.Stat.sumOfSquares)) {
                res.add("sumOfSquares", this.sumOfSquares);
            }
            if (this.statsField.includeInResponse(StatsField.Stat.stddev)) {
                res.add("stddev", this.getStandardDeviation());
            }
        }

        private double getStandardDeviation() {
            if (this.count <= 1L) {
                return 0.0;
            }
            return Math.sqrt(((double)this.count * this.sumOfSquares - this.sum * this.sum) / ((double)this.count * ((double)this.count - 1.0)));
        }
    }

    private static class EnumStatsValues
    extends AbstractStatsValues<EnumFieldValue> {
        public EnumStatsValues(StatsField statsField) {
            super(statsField);
        }

        @Override
        public long hash(EnumFieldValue v) {
            return this.hasher.hashInt(v.toInt().intValue()).asLong();
        }

        @Override
        public void accumulate(int docID) throws IOException {
            if (this.values.exists(docID)) {
                Integer intValue = (Integer)this.values.objectVal(docID);
                String stringValue = this.values.strVal(docID);
                EnumFieldValue enumFieldValue = new EnumFieldValue(intValue, stringValue);
                this.accumulate(enumFieldValue, 1);
            } else {
                this.missing();
            }
        }

        @Override
        protected void updateMinMax(EnumFieldValue min, EnumFieldValue max) {
            if (this.computeMin && null != min && (null == this.min || min.compareTo((EnumFieldValue)this.min) < 0)) {
                this.min = min;
            }
            if (this.computeMax && null != max && (null == this.max || max.compareTo((EnumFieldValue)this.max) > 0)) {
                this.max = max;
            }
        }

        @Override
        protected void updateTypeSpecificStats(NamedList<?> stv) {
        }

        @Override
        protected void updateTypeSpecificStats(EnumFieldValue value, int count) {
        }

        @Override
        protected void addTypeSpecificStats(NamedList<Object> res) {
        }
    }

    static class NumericStatsValues
    extends AbstractStatsValues<Number> {
        double sum;
        double sumOfSquares;
        AVLTreeDigest tdigest;
        double minD;
        double maxD;
        protected final boolean computeSum;
        protected final boolean computeSumOfSquares;
        protected final boolean computePercentiles;

        public NumericStatsValues(StatsField statsField) {
            super(statsField);
            this.computeSum = statsField.calculateStats(StatsField.Stat.sum);
            this.computeSumOfSquares = statsField.calculateStats(StatsField.Stat.sumOfSquares);
            this.computePercentiles = statsField.calculateStats(StatsField.Stat.percentiles);
            if (this.computePercentiles) {
                this.tdigest = new AVLTreeDigest(statsField.getTdigestCompression());
            }
        }

        @Override
        public long hash(Number v) {
            if (v instanceof Long) {
                return this.hasher.hashLong(v.longValue()).asLong();
            }
            if (v instanceof Integer) {
                return this.hasher.hashInt(v.intValue()).asLong();
            }
            if (v instanceof Double) {
                return this.hasher.hashLong(Double.doubleToRawLongBits(v.doubleValue())).asLong();
            }
            if (v instanceof Float) {
                return this.hasher.hashInt(Float.floatToRawIntBits(v.floatValue())).asLong();
            }
            if (v instanceof Byte) {
                return this.hasher.newHasher().putByte(v.byteValue()).hash().asLong();
            }
            if (v instanceof Short) {
                return this.hasher.newHasher().putShort(v.shortValue()).hash().asLong();
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported Numeric Type (" + v.getClass() + ") for hashing: " + this.statsField);
        }

        @Override
        public void accumulate(int docID) throws IOException {
            if (this.values.exists(docID)) {
                Number value = (Number)this.values.objectVal(docID);
                this.accumulate(value, 1);
            } else {
                this.missing();
            }
        }

        @Override
        public void updateTypeSpecificStats(NamedList<?> stv) {
            if (this.computeSum) {
                this.sum += ((Number)stv.get("sum")).doubleValue();
            }
            if (this.computeSumOfSquares) {
                this.sumOfSquares += ((Number)stv.get("sumOfSquares")).doubleValue();
            }
            if (this.computePercentiles) {
                byte[] data = (byte[])stv.get("percentiles");
                ByteBuffer buf = ByteBuffer.wrap(data);
                this.tdigest.add((TDigest)AVLTreeDigest.fromBytes((ByteBuffer)buf));
            }
        }

        @Override
        public void updateTypeSpecificStats(Number v, int count) {
            double value = v.doubleValue();
            if (this.computeSumOfSquares) {
                this.sumOfSquares += value * value * (double)count;
            }
            if (this.computeSum) {
                this.sum += value * (double)count;
            }
            if (this.computePercentiles) {
                this.tdigest.add(value, count);
            }
        }

        @Override
        protected void updateMinMax(Number min, Number max) {
            if (this.computeMin && null != min) {
                double minD = min.doubleValue();
                if (null == this.min || minD < this.minD) {
                    this.minD = minD;
                    this.min = this.minD;
                }
            }
            if (this.computeMax && null != max) {
                double maxD = max.doubleValue();
                if (null == this.max || this.maxD < maxD) {
                    this.maxD = maxD;
                    this.max = this.maxD;
                }
            }
        }

        @Override
        protected void addTypeSpecificStats(NamedList<Object> res) {
            if (this.statsField.includeInResponse(StatsField.Stat.sum)) {
                res.add("sum", this.sum);
            }
            if (this.statsField.includeInResponse(StatsField.Stat.sumOfSquares)) {
                res.add("sumOfSquares", this.sumOfSquares);
            }
            if (this.statsField.includeInResponse(StatsField.Stat.mean)) {
                res.add("mean", this.sum / (double)this.count);
            }
            if (this.statsField.includeInResponse(StatsField.Stat.stddev)) {
                res.add("stddev", this.getStandardDeviation());
            }
            if (this.statsField.includeInResponse(StatsField.Stat.percentiles)) {
                if (this.statsField.getIsShard()) {
                    ByteBuffer buf = ByteBuffer.allocate(this.tdigest.byteSize());
                    this.tdigest.asSmallBytes(buf);
                    res.add("percentiles", Arrays.copyOf(buf.array(), buf.position()));
                } else {
                    NamedList<Double> percentileNameList = new NamedList<Double>();
                    for (Double percentile : this.statsField.getPercentilesList()) {
                        if (this.tdigest.size() == 0L) {
                            percentileNameList.add(percentile.toString(), null);
                            continue;
                        }
                        Double cutoff = this.tdigest.quantile(percentile / 100.0);
                        percentileNameList.add(percentile.toString(), cutoff);
                    }
                    res.add("percentiles", percentileNameList);
                }
            }
        }

        private double getStandardDeviation() {
            if ((double)this.count <= 1.0) {
                return 0.0;
            }
            return Math.sqrt(((double)this.count * this.sumOfSquares - this.sum * this.sum) / ((double)this.count * ((double)this.count - 1.0)));
        }
    }

    private static abstract class AbstractStatsValues<T>
    implements StatsValues {
        private static final String FACETS = "facets";
        protected final StatsField statsField;
        protected final SchemaField sf;
        protected final FieldType ft;
        protected final boolean computeCount;
        protected final boolean computeMissing;
        protected final boolean computeCalcDistinct;
        protected final boolean computeMin;
        protected final boolean computeMax;
        protected final boolean computeMinOrMax;
        protected final boolean computeCardinality;
        private ValueSource valueSource;
        private Map<Object, Object> vsContext;
        protected FunctionValues values;
        protected T max;
        protected T min;
        protected long missing;
        protected long count;
        protected long countDistinct;
        protected final Set<T> distinctValues;
        protected final HashFunction hasher;
        private HLL hll;
        protected Map<String, Map<String, StatsValues>> facets = new HashMap<String, Map<String, StatsValues>>();

        protected AbstractStatsValues(StatsField statsField) {
            this.statsField = statsField;
            this.computeCount = statsField.calculateStats(StatsField.Stat.count);
            this.computeMissing = statsField.calculateStats(StatsField.Stat.missing);
            this.computeCalcDistinct = statsField.calculateStats(StatsField.Stat.countDistinct) || statsField.calculateStats(StatsField.Stat.distinctValues);
            this.computeMin = statsField.calculateStats(StatsField.Stat.min);
            this.computeMax = statsField.calculateStats(StatsField.Stat.max);
            this.computeMinOrMax = this.computeMin || this.computeMax;
            this.distinctValues = this.computeCalcDistinct ? new TreeSet() : null;
            this.computeCardinality = statsField.calculateStats(StatsField.Stat.cardinality);
            if (this.computeCardinality) {
                this.hasher = statsField.getHllOptions().getHasher();
                this.hll = statsField.getHllOptions().newHLL();
                assert (null != this.hll) : "Cardinality requires an HLL";
            } else {
                this.hll = null;
                this.hasher = null;
            }
            if (null != statsField.getSchemaField()) {
                assert (null == statsField.getValueSource());
                this.sf = statsField.getSchemaField();
                this.ft = this.sf.getType();
            } else {
                assert (null != statsField.getValueSource());
                assert (null == statsField.getSchemaField());
                this.sf = null;
                this.ft = null;
            }
        }

        @Override
        public void accumulate(NamedList<?> stv) {
            if (this.computeCount) {
                this.count += ((Long)stv.get("count")).longValue();
            }
            if (this.computeMissing) {
                this.missing += ((Long)stv.get("missing")).longValue();
            }
            if (this.computeCalcDistinct) {
                this.distinctValues.addAll((Collection)stv.get("distinctValues"));
                this.countDistinct = this.distinctValues.size();
            }
            if (this.computeMinOrMax) {
                this.updateMinMax(stv.get("min"), stv.get("max"));
            }
            if (this.computeCardinality) {
                byte[] data = (byte[])stv.get("cardinality");
                HLL other = HLL.fromBytes(data);
                if (this.hll.getType().equals((Object)HLLType.EMPTY)) {
                    this.hll = other;
                } else {
                    this.hll.union(other);
                }
            }
            this.updateTypeSpecificStats(stv);
            NamedList f = (NamedList)stv.get(FACETS);
            if (f == null) {
                return;
            }
            for (int i = 0; i < f.size(); ++i) {
                String field = f.getName(i);
                NamedList vals = (NamedList)f.getVal(i);
                Map<String, StatsValues> addTo = this.facets.get(field);
                if (addTo == null) {
                    addTo = new HashMap<String, StatsValues>();
                    this.facets.put(field, addTo);
                }
                for (int j = 0; j < vals.size(); ++j) {
                    String val = vals.getName(j);
                    StatsValues vvals = addTo.get(val);
                    if (vvals == null) {
                        vvals = StatsValuesFactory.createStatsValues(this.statsField);
                        addTo.put(val, vvals);
                    }
                    vvals.accumulate((NamedList)vals.getVal(j));
                }
            }
        }

        @Override
        public void accumulate(BytesRef value, int count) {
            if (null == this.ft) {
                throw new IllegalStateException("Can't collect & convert BytesRefs on stats that do't use a a FieldType: " + this.statsField);
            }
            Object typedValue = this.ft.toObject(this.sf, value);
            this.accumulate(typedValue, count);
        }

        public void accumulate(T value, int count) {
            assert (null != value) : "Can't accumulate null";
            if (this.computeCount) {
                this.count += (long)count;
            }
            if (this.computeCalcDistinct) {
                this.distinctValues.add(value);
                this.countDistinct = this.distinctValues.size();
            }
            if (this.computeMinOrMax) {
                this.updateMinMax(value, value);
            }
            if (this.computeCardinality) {
                if (null == this.hasher) {
                    assert (value instanceof Number) : "pre-hashed value support only works with numeric longs";
                    this.hll.addRaw(((Number)value).longValue());
                } else {
                    this.hll.addRaw(this.hash(value));
                }
            }
            this.updateTypeSpecificStats(value, count);
        }

        @Override
        public void missing() {
            if (this.computeMissing) {
                ++this.missing;
            }
        }

        @Override
        public void addMissing(int count) {
            this.missing += (long)count;
        }

        @Override
        public void addFacet(String facetName, Map<String, StatsValues> facetValues) {
            this.facets.put(facetName, facetValues);
        }

        @Override
        public NamedList<?> getStatsValues() {
            SimpleOrderedMap<Object> res = new SimpleOrderedMap<Object>();
            if (this.statsField.includeInResponse(StatsField.Stat.min)) {
                res.add("min", this.min);
            }
            if (this.statsField.includeInResponse(StatsField.Stat.max)) {
                res.add("max", this.max);
            }
            if (this.statsField.includeInResponse(StatsField.Stat.count)) {
                res.add("count", this.count);
            }
            if (this.statsField.includeInResponse(StatsField.Stat.missing)) {
                res.add("missing", this.missing);
            }
            if (this.statsField.includeInResponse(StatsField.Stat.distinctValues)) {
                res.add("distinctValues", this.distinctValues);
            }
            if (this.statsField.includeInResponse(StatsField.Stat.countDistinct)) {
                res.add("countDistinct", this.countDistinct);
            }
            if (this.statsField.includeInResponse(StatsField.Stat.cardinality)) {
                if (this.statsField.getIsShard()) {
                    res.add("cardinality", this.hll.toBytes());
                } else {
                    res.add("cardinality", this.hll.cardinality());
                }
            }
            this.addTypeSpecificStats(res);
            if (!this.facets.isEmpty()) {
                SimpleOrderedMap nl = new SimpleOrderedMap();
                for (Map.Entry<String, Map<String, StatsValues>> entry : this.facets.entrySet()) {
                    SimpleOrderedMap nl2 = new SimpleOrderedMap();
                    nl.add(entry.getKey(), nl2);
                    for (Map.Entry<String, StatsValues> e2 : entry.getValue().entrySet()) {
                        nl2.add(e2.getKey(), e2.getValue().getStatsValues());
                    }
                }
                res.add(FACETS, nl);
            }
            return res;
        }

        @Override
        public void setNextReader(LeafReaderContext ctx) throws IOException {
            if (this.valueSource == null) {
                this.valueSource = null == this.ft ? this.statsField.getValueSource() : this.ft.getValueSource(this.sf, null);
                this.vsContext = ValueSource.newContext(this.statsField.getSearcher());
            }
            this.values = this.valueSource.getValues(this.vsContext, ctx);
        }

        protected abstract long hash(T var1);

        protected abstract void updateMinMax(T var1, T var2);

        protected abstract void updateTypeSpecificStats(T var1, int var2);

        protected abstract void updateTypeSpecificStats(NamedList<?> var1);

        protected abstract void addTypeSpecificStats(NamedList<Object> var1);
    }
}

