/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.FieldOptions;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrDocumentFetcher;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.SolrResponseUtil;

public class TermVectorComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "tv";
    public static final String TERM_VECTORS = "termVectors";
    private static final String TV_KEY_WARNINGS = "warnings";
    protected NamedList<?> initParams;

    private Set<String> getFields(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        String[] fldLst = params.getParams("tv.fl");
        if (null == fldLst || 0 == fldLst.length || 1 == fldLst.length && 0 == fldLst[0].length()) {
            SolrReturnFields rf = new SolrReturnFields(params.getParams("fl"), rb.req);
            if (((ReturnFields)rf).wantsAllFields()) {
                return null;
            }
            Set<String> fieldNames = ((ReturnFields)rf).getLuceneFieldNames();
            return null != fieldNames ? fieldNames : Collections.emptySet();
        }
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        for (String fl : fldLst) {
            fieldNames.addAll(Arrays.asList(SolrPluginUtils.split(fl)));
        }
        return fieldNames;
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        DocIterator iter;
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        NamedList termVectors = new NamedList();
        rb.rsp.add(TERM_VECTORS, termVectors);
        IndexSchema schema = rb.req.getSchema();
        SchemaField keyField = schema.getUniqueKeyField();
        String uniqFieldName = null;
        if (keyField != null) {
            uniqFieldName = keyField.getName();
        }
        FieldOptions allFields = new FieldOptions();
        allFields.termFreq = params.getBool("tv.tf", false);
        allFields.positions = params.getBool("tv.positions", false);
        allFields.offsets = params.getBool("tv.offsets", false);
        allFields.payloads = params.getBool("tv.payloads", false);
        allFields.docFreq = params.getBool("tv.df", false);
        allFields.tfIdf = params.getBool("tv.tf_idf", false);
        if (params.getBool("tv.all", false)) {
            allFields.termFreq = true;
            allFields.positions = true;
            allFields.offsets = true;
            allFields.payloads = true;
            allFields.docFreq = true;
            allFields.tfIdf = true;
        }
        HashMap<String, FieldOptions> fieldOptions = new HashMap<String, FieldOptions>();
        NamedList warnings = new NamedList();
        ArrayList<String> noTV = new ArrayList<String>();
        ArrayList<String> noPos = new ArrayList<String>();
        ArrayList<String> noOff = new ArrayList<String>();
        ArrayList<String> noPay = new ArrayList<String>();
        Set<String> fields = this.getFields(rb);
        if (null != fields) {
            for (String field : fields) {
                if (null == field || "score".equals(field)) continue;
                boolean fieldIsUniqueKey = field.equals(uniqFieldName);
                SchemaField sf = schema.getFieldOrNull(field);
                if (sf != null) {
                    if (sf.storeTermVector()) {
                        FieldOptions option = (FieldOptions)fieldOptions.get(field);
                        if (option == null) {
                            option = new FieldOptions();
                            option.fieldName = field;
                            fieldOptions.put(field, option);
                        }
                        option.termFreq = params.getFieldBool(field, "tv.tf", allFields.termFreq);
                        option.docFreq = params.getFieldBool(field, "tv.df", allFields.docFreq);
                        option.tfIdf = params.getFieldBool(field, "tv.tf_idf", allFields.tfIdf);
                        option.positions = params.getFieldBool(field, "tv.positions", allFields.positions);
                        if (option.positions && !sf.storeTermPositions() && !fieldIsUniqueKey) {
                            noPos.add(field);
                        }
                        option.offsets = params.getFieldBool(field, "tv.offsets", allFields.offsets);
                        if (option.offsets && !sf.storeTermOffsets() && !fieldIsUniqueKey) {
                            noOff.add(field);
                        }
                        option.payloads = params.getFieldBool(field, "tv.payloads", allFields.payloads);
                        if (!option.payloads || sf.storeTermPayloads() || fieldIsUniqueKey) continue;
                        noPay.add(field);
                        continue;
                    }
                    if (fieldIsUniqueKey) continue;
                    noTV.add(field);
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "undefined field: " + field);
            }
        }
        if (!noTV.isEmpty()) {
            warnings.add("noTermVectors", noTV);
        }
        if (!noPos.isEmpty()) {
            warnings.add("noPositions", noPos);
        }
        if (!noOff.isEmpty()) {
            warnings.add("noOffsets", noOff);
        }
        if (!noPay.isEmpty()) {
            warnings.add("noPayloads", noPay);
        }
        if (warnings.size() > 0) {
            termVectors.add(TV_KEY_WARNINGS, warnings);
        }
        DocListAndSet listAndSet = rb.getResults();
        List<Integer> docIds = this.getInts(params.getParams("tv.docIds"));
        if (docIds != null && !docIds.isEmpty()) {
            iter = docIds.iterator();
        } else {
            DocList list = listAndSet.docList;
            iter = list.iterator();
        }
        SolrIndexSearcher searcher = rb.req.getSearcher();
        DirectoryReader reader = searcher.getIndexReader();
        SolrDocumentFetcher docFetcher = searcher.getDocFetcher();
        SolrReturnFields srf = new SolrReturnFields(uniqFieldName, rb.req);
        while (iter.hasNext()) {
            TermsEnum termsEnum;
            Integer docId = (Integer)iter.next();
            NamedList<Object> docNL = new NamedList<Object>();
            if (keyField != null) {
                SolrDocument solrDoc = docFetcher.solrDoc(docId, srf);
                String string = schema.printableUniqueKey(solrDoc);
                assert (null != string);
                docNL.add("uniqueKey", string);
                termVectors.add(string, docNL);
            } else {
                termVectors.add("doc-" + docId, docNL);
            }
            if (null != fields) {
                for (Map.Entry entry : fieldOptions.entrySet()) {
                    String field = (String)entry.getKey();
                    Terms vector = reader.getTermVector(docId, field);
                    if (vector == null) continue;
                    termsEnum = vector.iterator();
                    this.mapOneVector(docNL, (FieldOptions)entry.getValue(), reader, docId, termsEnum, field);
                }
                continue;
            }
            Fields vectors = ((IndexReader)reader).getTermVectors(docId);
            if (vectors == null) continue;
            for (String field : vectors) {
                Terms terms = vectors.terms(field);
                if (terms == null) continue;
                termsEnum = terms.iterator();
                this.mapOneVector(docNL, allFields, reader, docId, termsEnum, field);
            }
        }
    }

    private void mapOneVector(NamedList<Object> docNL, FieldOptions fieldOptions, IndexReader reader, int docID, TermsEnum termsEnum, String field) throws IOException {
        BytesRef text;
        NamedList fieldNL = new NamedList();
        docNL.add(field, fieldNL);
        PostingsEnum dpEnum = null;
        while ((text = termsEnum.next()) != null) {
            String term = text.utf8ToString();
            NamedList<Serializable> termInfo = new NamedList<Serializable>();
            fieldNL.add(term, termInfo);
            int freq = (int)termsEnum.totalTermFreq();
            if (fieldOptions.termFreq) {
                termInfo.add("tf", Integer.valueOf(freq));
            }
            int dpEnumFlags = 0;
            dpEnumFlags |= fieldOptions.positions ? 24 : 0;
            dpEnumFlags |= fieldOptions.offsets || fieldOptions.payloads ? 56 : 0;
            dpEnum = termsEnum.postings(dpEnum, dpEnumFlags |= fieldOptions.payloads ? 88 : 0);
            boolean atNextDoc = false;
            if (dpEnum != null) {
                dpEnum.nextDoc();
                atNextDoc = true;
            }
            if (atNextDoc && dpEnumFlags != 0) {
                NamedList<Integer> positionsNL = null;
                NamedList<Integer> theOffsets = null;
                NamedList<String> thePayloads = null;
                for (int i = 0; i < freq; ++i) {
                    BytesRef payload;
                    int startOffset;
                    int pos = dpEnum.nextPosition();
                    if (fieldOptions.positions && pos >= 0) {
                        if (positionsNL == null) {
                            positionsNL = new NamedList<Integer>();
                            termInfo.add("positions", positionsNL);
                        }
                        positionsNL.add("position", pos);
                    }
                    int n = startOffset = fieldOptions.offsets ? dpEnum.startOffset() : -1;
                    if (startOffset >= 0) {
                        if (theOffsets == null) {
                            theOffsets = new NamedList<Integer>();
                            termInfo.add("offsets", theOffsets);
                        }
                        theOffsets.add("start", dpEnum.startOffset());
                        theOffsets.add("end", dpEnum.endOffset());
                    }
                    BytesRef bytesRef = payload = fieldOptions.payloads ? dpEnum.getPayload() : null;
                    if (payload == null) continue;
                    if (thePayloads == null) {
                        thePayloads = new NamedList<String>();
                        termInfo.add("payloads", thePayloads);
                    }
                    thePayloads.add("payload", new String(Base64.getEncoder().encode(ByteBuffer.wrap(payload.bytes, payload.offset, payload.length)).array(), StandardCharsets.ISO_8859_1));
                }
            }
            int df = 0;
            if (fieldOptions.docFreq || fieldOptions.tfIdf) {
                df = reader.docFreq(new Term(field, text));
            }
            if (fieldOptions.docFreq) {
                termInfo.add("df", Integer.valueOf(df));
            }
            if (!fieldOptions.tfIdf) continue;
            double tfIdfVal = (double)freq / (double)df;
            termInfo.add("tf-idf", Double.valueOf(tfIdfVal));
        }
    }

    private List<Integer> getInts(String[] vals) {
        ArrayList<Integer> result = null;
        if (vals != null && vals.length > 0) {
            result = new ArrayList<Integer>(vals.length);
            for (int i = 0; i < vals.length; ++i) {
                try {
                    result.add(Integer.valueOf(vals[i]));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            NamedList termVectorsNL = new NamedList();
            NamedList.NamedListEntry[] arr = (NamedList.NamedListEntry[])Array.newInstance(NamedList.NamedListEntry.class, rb.resultIds.size());
            for (ShardRequest sreq : rb.finished) {
                if ((sreq.purpose & 0x40) == 0 || !sreq.params.getBool(COMPONENT_NAME, false)) continue;
                for (ShardResponse srsp : sreq.responses) {
                    NamedList nl = (NamedList)SolrResponseUtil.getSubsectionFromShardResponse(rb, srsp, TERM_VECTORS, false);
                    if (nl == null) continue;
                    Object warningsNL = nl.get(TV_KEY_WARNINGS);
                    if (warningsNL != null && termVectorsNL.indexOf(TV_KEY_WARNINGS, 0) < 0) {
                        termVectorsNL.add(TV_KEY_WARNINGS, warningsNL);
                    }
                    SolrPluginUtils.copyNamedListIntoArrayByDocPosInResponse(nl, rb.resultIds, arr);
                }
            }
            SolrPluginUtils.removeNulls(arr, termVectorsNL);
            rb.rsp.add(TERM_VECTORS, termVectorsNL);
        }
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        SolrParams params = rb.req.getParams();
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        if ((sreq.purpose & 0x40) == 0) {
            sreq.params.set(COMPONENT_NAME, "false");
        }
    }

    @Override
    public void init(NamedList<?> args) {
        super.init(args);
        this.initParams = args;
    }

    @Override
    public String getDescription() {
        return "A Component for working with Term Vectors";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.QUERY;
    }
}

