/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.designer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudLegacySolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.schema.FieldTypeDefinition;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkMaintenanceUtils;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.designer.DefaultSampleDocumentsLoader;
import org.apache.solr.handler.designer.SchemaDesignerAPI;
import org.apache.solr.handler.designer.SchemaDesignerConstants;
import org.apache.solr.handler.designer.SchemaSuggester;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.ManagedIndexSchemaFactory;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TextField;
import org.apache.solr.util.RTimer;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaDesignerConfigSetHelper
implements SchemaDesignerConstants {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Set<String> removeFieldProps = new HashSet<String>(Arrays.asList("href", "id", "copyDest"));
    private static final List<String> includeLangIds = Arrays.asList("ws", "general", "rev", "sort");
    private static final String ZNODE_PATH_DELIM = "/";
    private static final String MULTIVALUED = "multiValued";
    private static final int TEXT_PREFIX_LEN = "text_".length();
    private final CoreContainer cc;
    private final SchemaSuggester schemaSuggester;

    SchemaDesignerConfigSetHelper(CoreContainer cc, SchemaSuggester schemaSuggester) {
        this.cc = cc;
        this.schemaSuggester = schemaSuggester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Object> analyzeField(String configSet, String fieldName, String fieldText) throws IOException {
        URI uri;
        String mutableId = SchemaDesignerAPI.getMutableId(configSet);
        try {
            uri = this.collectionApiEndpoint(mutableId, "analysis", "field").setParameter("wt", "json").setParameter("analysis.showmatch", "true").setParameter("analysis.fieldname", fieldName).setParameter("analysis.fieldvalue", "POST").build();
        }
        catch (URISyntaxException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        Map analysis = Collections.emptyMap();
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", "text/plain");
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(fieldText.getBytes(StandardCharsets.UTF_8)));
        try {
            HttpResponse resp = ((CloudLegacySolrClient)this.cloudClient()).getHttpClient().execute((HttpUriRequest)httpPost);
            int statusCode = resp.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new SolrException(SolrException.ErrorCode.getErrorCode(statusCode), EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)StandardCharsets.UTF_8));
            }
            Map response = (Map)Utils.fromJSONString(EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)StandardCharsets.UTF_8));
            if (response != null) {
                analysis = (Map)response.get("analysis");
            }
        }
        finally {
            httpPost.releaseConnection();
        }
        return analysis;
    }

    List<String> listCollectionsForConfig(String configSet) {
        ArrayList<String> collections = new ArrayList<String>();
        Map<String, ClusterState.CollectionRef> states = this.zkStateReader().getClusterState().getCollectionStates();
        for (Map.Entry<String, ClusterState.CollectionRef> e : states.entrySet()) {
            String coll = e.getKey();
            if (coll.startsWith("._designer_")) continue;
            try {
                if (!configSet.equals(e.getValue().get().getConfigName()) || e.getValue().get() == null) continue;
                collections.add(coll);
            }
            catch (Exception exc) {
                log.warn("Failed to get config name for {}", (Object)coll, (Object)exc);
            }
        }
        return collections;
    }

    public String addSchemaObject(String configSet, Map<String, Object> addJson) throws IOException, SolrServerException {
        SchemaRequest.SingleUpdate addAction;
        Map fieldAttrs;
        String action;
        String mutableId = SchemaDesignerAPI.getMutableId(configSet);
        String objectName = null;
        if (addJson.containsKey("add-field")) {
            action = "add-field";
            fieldAttrs = (Map)addJson.get(action);
            objectName = (String)fieldAttrs.get("name");
            addAction = new SchemaRequest.AddField(fieldAttrs);
        } else if (addJson.containsKey("add-dynamic-field")) {
            action = "add-dynamic-field";
            fieldAttrs = (Map)addJson.get(action);
            objectName = (String)fieldAttrs.get("name");
            addAction = new SchemaRequest.AddDynamicField(fieldAttrs);
        } else if (addJson.containsKey("add-copy-field")) {
            action = "add-copy-field";
            Map map = (Map)addJson.get(action);
            Object dest = map.get("dest");
            ArrayList destFields = null;
            if (dest instanceof String) {
                destFields = Collections.singletonList((String)dest);
            } else if (dest instanceof List) {
                destFields = (ArrayList)dest;
            } else if (dest instanceof Collection) {
                Collection destColl = (Collection)dest;
                destFields = new ArrayList(destColl);
            }
            addAction = new SchemaRequest.AddCopyField((String)map.get("source"), destFields);
        } else if (addJson.containsKey("add-field-type")) {
            action = "add-field-type";
            fieldAttrs = (Map)addJson.get(action);
            objectName = (String)fieldAttrs.get("name");
            FieldTypeDefinition ftDef = new FieldTypeDefinition();
            ftDef.setAttributes(fieldAttrs);
            addAction = new SchemaRequest.AddFieldType(ftDef);
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported action in request body! " + addJson);
        }
        log.info("Sending {} request for configSet {}: {}", new Object[]{action, mutableId, addJson});
        SchemaResponse.UpdateResponse schemaResponse = (SchemaResponse.UpdateResponse)addAction.process(this.cloudClient(), mutableId);
        Exception exc = schemaResponse.getException();
        if (exc instanceof SolrException) {
            throw (SolrException)exc;
        }
        if (schemaResponse.getStatus() != 0) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)exc);
        }
        return objectName;
    }

    void reloadTempCollection(String mutableId, boolean delete) throws IOException, SolrServerException {
        if (delete) {
            log.debug("Deleting and re-creating existing collection {} after schema update", (Object)mutableId);
            CollectionAdminRequest.deleteCollection(mutableId).process(this.cloudClient());
            try {
                this.zkStateReader().waitForState(mutableId, 30L, TimeUnit.SECONDS, Objects::isNull);
            }
            catch (InterruptedException | TimeoutException e) {
                throw new IOException("Failed to see deleted collection " + mutableId + " reflected in cluster state", SolrZkClient.checkInterrupted(e));
            }
            this.createCollection(mutableId, mutableId);
            log.debug("Deleted and re-created existing collection: {}", (Object)mutableId);
        } else {
            CollectionAdminRequest.reloadCollection(mutableId).process(this.cloudClient());
            log.debug("Reloaded existing collection: {}", (Object)mutableId);
        }
    }

    Map<String, Object> updateSchemaObject(String configSet, Map<String, Object> updateJson, ManagedIndexSchema schemaBeforeUpdate) throws IOException, SolrServerException {
        String updateType;
        String name = (String)updateJson.get("name");
        String mutableId = SchemaDesignerAPI.getMutableId(configSet);
        boolean needsRebuild = false;
        SolrException solrExc = null;
        String updateError = null;
        if (updateJson.get("type") != null) {
            updateType = schemaBeforeUpdate.isDynamicField(name) ? "dynamicField" : "field";
            try {
                needsRebuild = this.updateField(configSet, updateJson, schemaBeforeUpdate);
            }
            catch (SolrException exc) {
                if (exc.code() != 400) {
                    throw exc;
                }
                solrExc = exc;
                updateError = solrExc.getMessage() + " Previous settings will be restored.";
            }
        } else {
            updateType = "type";
            needsRebuild = this.updateFieldType(configSet, name, updateJson, schemaBeforeUpdate);
        }
        this.reloadTempCollection(mutableId, needsRebuild);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("rebuild", needsRebuild);
        results.put("updateType", updateType);
        if (updateError != null) {
            results.put("updateError", updateError);
        }
        if (solrExc != null) {
            results.put("solrExc", solrExc);
        }
        return results;
    }

    protected boolean updateFieldType(String configSet, String typeName, Map<String, Object> updateJson, ManagedIndexSchema schemaBeforeUpdate) {
        String synonymQueryStyle;
        boolean needsRebuild = false;
        Map<String, Object> typeAttrs = updateJson.entrySet().stream().filter(e -> !removeFieldProps.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        FieldType fieldType = schemaBeforeUpdate.getFieldTypeByName(typeName);
        Object multiValued = typeAttrs.get(MULTIVALUED);
        if (this.typeHasMultiValuedChange(multiValued, fieldType)) {
            needsRebuild = true;
            log.warn("Re-building the temp collection for {} after type {} updated to multi-valued {}", new Object[]{configSet, typeName, multiValued});
        }
        if (typeAttrs.get("synonymQueryStyle") instanceof String && (synonymQueryStyle = (String)typeAttrs.get("synonymQueryStyle")).lastIndexOf(58) != -1) {
            typeAttrs.put("synonymQueryStyle", synonymQueryStyle.substring(synonymQueryStyle.lastIndexOf(58) + 1));
        }
        IndexSchema updatedSchema = schemaBeforeUpdate.replaceFieldType(fieldType.getTypeName(), (String)typeAttrs.get("class"), (Map)typeAttrs);
        ((ManagedIndexSchema)updatedSchema).persistManagedSchema(false);
        return needsRebuild;
    }

    boolean updateField(String configSet, Map<String, Object> updateField, ManagedIndexSchema schemaBeforeUpdate) throws IOException, SolrServerException {
        SimpleOrderedMap<Object> fromTypeProps;
        String mutableId = SchemaDesignerAPI.getMutableId(configSet);
        String name = (String)updateField.get("name");
        String type = (String)updateField.get("type");
        String copyDest = (String)updateField.get("copyDest");
        Map<String, Object> fieldAttributes = updateField.entrySet().stream().filter(e -> !removeFieldProps.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        boolean needsRebuild = false;
        SchemaField schemaField = schemaBeforeUpdate.getField(name);
        boolean isDynamic = schemaBeforeUpdate.isDynamicField(name);
        String currentType = schemaField.getType().getTypeName();
        if (type.equals(currentType)) {
            fromTypeProps = schemaBeforeUpdate.getFieldTypeByName(currentType).getNamedPropertyValues(true);
        } else {
            FieldType newType = schemaBeforeUpdate.getFieldTypeByName(type);
            if (newType == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid update request for field " + name + "! Field type " + type + " doesn't exist!");
            }
            this.validateTypeChange(configSet, schemaField, newType);
            fromTypeProps = newType.getNamedPropertyValues(true);
        }
        HashMap<String, Object> diff = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : fieldAttributes.entrySet()) {
            String attr = entry.getKey();
            Object attrValue = entry.getValue();
            if ("name".equals(attr) || "type".equals(attr)) continue;
            if ("required".equals(attr)) {
                diff.put(attr, attrValue != null ? attrValue : Boolean.valueOf(false));
                continue;
            }
            Object fromType = fromTypeProps.get(attr);
            if (fromType != null && fromType.equals(attrValue)) continue;
            diff.put(attr, attrValue);
        }
        Object multiValued = diff.get(MULTIVALUED);
        if (multiValued == null) {
            multiValued = type.equals(currentType) ? schemaField.multiValued() : schemaBeforeUpdate.getFieldTypeByName(type).isMultiValued();
        }
        if (!isDynamic && Boolean.FALSE.equals(multiValued)) {
            for (String src : schemaBeforeUpdate.getCopySources(name)) {
                SchemaField srcField = schemaBeforeUpdate.getField(src);
                if (!srcField.multiValued()) continue;
                log.warn("Cannot change multi-valued field {} to single-valued because it is a copy field destination for multi-valued field {}", (Object)name, (Object)src);
                multiValued = Boolean.TRUE;
                diff.put(MULTIVALUED, multiValued);
                break;
            }
        }
        if (Boolean.FALSE.equals(multiValued) && schemaField.multiValued()) {
            this.validateMultiValuedChange(configSet, schemaField, Boolean.FALSE);
        }
        if (this.fieldHasMultiValuedChange(multiValued, schemaField)) {
            needsRebuild = true;
            log.warn("Need to rebuild the temp collection for {} after field {} updated to multi-valued {}", new Object[]{configSet, name, multiValued});
        }
        if (!needsRebuild) {
            Boolean bl = (Boolean)fieldAttributes.getOrDefault("termVectors", Boolean.FALSE);
            if (schemaField.storeTermVector() != bl.booleanValue()) {
                needsRebuild = true;
            }
        }
        log.info("For {}, replacing field {} with attributes: {}", new Object[]{configSet, name, diff});
        FieldType fieldType = schemaBeforeUpdate.getFieldTypeByName(type);
        IndexSchema updatedSchema = isDynamic ? schemaBeforeUpdate.replaceDynamicField(name, fieldType, diff) : schemaBeforeUpdate.replaceField(name, fieldType, diff);
        ((ManagedIndexSchema)updatedSchema).persistManagedSchema(false);
        if (!isDynamic) {
            this.applyCopyFieldUpdates(mutableId, copyDest, name, (ManagedIndexSchema)updatedSchema);
        }
        return needsRebuild;
    }

    protected void validateMultiValuedChange(String configSet, SchemaField field, Boolean multiValued) throws IOException {
        boolean isMV;
        List<SolrInputDocument> docs = this.getStoredSampleDocs(configSet);
        if (!docs.isEmpty() && (isMV = this.schemaSuggester.isMultiValued(field.getName(), docs)) && !multiValued.booleanValue()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot change field " + field.getName() + " to single-valued as some sample docs have multiple values!");
        }
    }

    protected void validateTypeChange(String configSet, SchemaField field, FieldType toType) throws IOException {
        if ("_version_".equals(field.getName())) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot change type of the _version_ field; it must be a plong.");
        }
        List<SolrInputDocument> docs = this.getStoredSampleDocs(configSet);
        if (!docs.isEmpty()) {
            this.schemaSuggester.validateTypeChange(field, toType, docs);
        }
    }

    void deleteStoredSampleDocs(String configSet) {
        try {
            this.cloudClient().deleteByQuery(".system", "id:" + configSet + "_sample/*", 10);
        }
        catch (IOException | SolrServerException | SolrException exc) {
            String excStr = exc.toString();
            log.warn("Failed to delete sample docs from blob store for {} due to: {}", (Object)configSet, (Object)excStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SolrInputDocument> getStoredSampleDocs(String configSet) throws IOException {
        URI uri;
        List docs = null;
        try {
            uri = this.collectionApiEndpoint(".system", "blob", configSet + "_sample").setParameter("wt", "filestream").build();
        }
        catch (URISyntaxException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        HttpGet httpGet = new HttpGet(uri);
        try {
            HttpResponse entity = ((CloudLegacySolrClient)this.cloudClient()).getHttpClient().execute((HttpUriRequest)httpGet);
            int statusCode = entity.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                byte[] bytes = DefaultSampleDocumentsLoader.streamAsBytes(entity.getEntity().getContent());
                if (bytes.length > 0) {
                    docs = (List)Utils.fromJavabin(bytes);
                }
            } else if (statusCode != 404) {
                byte[] bytes = DefaultSampleDocumentsLoader.streamAsBytes(entity.getEntity().getContent());
                throw new IOException("Failed to lookup stored docs for " + configSet + " due to: " + new String(bytes, StandardCharsets.UTF_8));
            }
        }
        finally {
            httpGet.releaseConnection();
        }
        return docs != null ? docs : Collections.emptyList();
    }

    void storeSampleDocs(String configSet, List<SolrInputDocument> docs) throws IOException {
        docs.forEach(d -> d.removeField("_version_"));
        this.postDataToBlobStore(this.cloudClient(), configSet + "_sample", DefaultSampleDocumentsLoader.streamAsBytes(Utils.toJavabin(docs)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postDataToBlobStore(CloudSolrClient cloudClient, String blobName, byte[] bytes) throws IOException {
        URI uri;
        try {
            uri = this.collectionApiEndpoint(".system", "blob", blobName).build();
        }
        catch (URISyntaxException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        HttpPost httpPost = new HttpPost(uri);
        try {
            httpPost.setHeader("Content-Type", "application/octet-stream");
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(bytes));
            HttpResponse resp = ((CloudLegacySolrClient)cloudClient).getHttpClient().execute((HttpUriRequest)httpPost);
            int statusCode = resp.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new SolrException(SolrException.ErrorCode.getErrorCode(statusCode), EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)StandardCharsets.UTF_8));
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    private String getBaseUrl(String collection) {
        String baseUrl = null;
        try {
            Optional<Replica> maybeActive;
            Set<String> liveNodes = this.zkStateReader().getClusterState().getLiveNodes();
            DocCollection docColl = this.zkStateReader().getCollection(collection);
            if (docColl != null && !liveNodes.isEmpty() && (maybeActive = docColl.getReplicas().stream().filter(r -> r.isActive(liveNodes)).findAny()).isPresent()) {
                baseUrl = maybeActive.get().getBaseUrl();
            }
        }
        catch (Exception exc) {
            log.warn("Failed to lookup base URL for collection {}", (Object)collection, (Object)exc);
        }
        if (baseUrl == null) {
            baseUrl = this.zkStateReader().getBaseUrlForNodeName(this.cc.getZkController().getNodeName());
        }
        return baseUrl;
    }

    private URIBuilder collectionApiEndpoint(String collection, String ... morePathSegments) throws URISyntaxException {
        URI baseUrl = new URI(this.getBaseUrl(collection));
        ArrayList<String> path = new ArrayList<String>(URLEncodedUtils.parsePathSegments((CharSequence)baseUrl.getPath()));
        path.add(collection);
        if (morePathSegments != null && morePathSegments.length > 0) {
            path.addAll(Arrays.asList(morePathSegments));
        }
        return new URIBuilder(baseUrl).setPathSegments(path);
    }

    protected String getManagedSchemaZkPath(String configSet) {
        return SchemaDesignerAPI.getConfigSetZkPath(configSet, "managed-schema.xml");
    }

    ManagedIndexSchema toggleNestedDocsFields(ManagedIndexSchema schema, boolean enabled) {
        return enabled ? this.enableNestedDocsFields(schema, true) : this.deleteNestedDocsFieldsIfNeeded(schema, true);
    }

    ManagedIndexSchema enableNestedDocsFields(ManagedIndexSchema schema, boolean persist) {
        boolean madeChanges = false;
        if (!schema.hasExplicitField("_root_")) {
            Map<String, Boolean> fieldAttrs = Map.of("docValues", false, "indexed", true, "stored", false);
            schema = (ManagedIndexSchema)schema.addField(schema.newField("_root_", "string", fieldAttrs), false);
            madeChanges = true;
        }
        if (!schema.hasExplicitField("_nest_path_")) {
            schema = (ManagedIndexSchema)schema.addField(schema.newField("_nest_path_", "_nest_path_", Collections.emptyMap()), false);
            madeChanges = true;
        }
        if (madeChanges && persist) {
            schema.persistManagedSchema(false);
        }
        return schema;
    }

    ManagedIndexSchema deleteNestedDocsFieldsIfNeeded(ManagedIndexSchema schema, boolean persist) {
        ArrayList<String> toDelete = new ArrayList<String>();
        if (schema.hasExplicitField("_root_")) {
            toDelete.add("_root_");
        }
        if (schema.hasExplicitField("_nest_path_")) {
            toDelete.add("_nest_path_");
        }
        if (!toDelete.isEmpty()) {
            schema = ((ManagedIndexSchema)schema).deleteFields(toDelete);
            if (persist) {
                ((ManagedIndexSchema)schema).persistManagedSchema(false);
            }
        }
        return schema;
    }

    SolrConfig loadSolrConfig(String configSet) {
        ZkSolrResourceLoader zkLoader = this.zkLoaderForConfigSet(configSet);
        boolean trusted = this.isConfigSetTrusted(configSet);
        return SolrConfig.readFromResourceLoader(zkLoader, "solrconfig.xml", trusted, null);
    }

    ManagedIndexSchema loadLatestSchema(String configSet) {
        return this.loadLatestSchema(this.loadSolrConfig(configSet));
    }

    ManagedIndexSchema loadLatestSchema(SolrConfig solrConfig) {
        ManagedIndexSchemaFactory factory = new ManagedIndexSchemaFactory();
        factory.init(new NamedList());
        return factory.create("managed-schema.xml", solrConfig, null);
    }

    int getCurrentSchemaVersion(String configSet) throws IOException {
        int currentVersion = -1;
        String path = this.getManagedSchemaZkPath(configSet);
        try {
            Stat stat = this.cc.getZkController().getZkClient().exists(path, null, true);
            if (stat != null) {
                currentVersion = stat.getVersion();
            }
        }
        catch (KeeperException.NoNodeException stat) {
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error getting version for schema: " + configSet, SolrZkClient.checkInterrupted(e));
        }
        return currentVersion;
    }

    void createCollection(String collection, String configSet) throws IOException, SolrServerException {
        this.createCollection(collection, configSet, 1, 1);
    }

    void createCollection(String collection, String configSet, int numShards, int numReplicas) throws IOException, SolrServerException {
        RTimer timer = new RTimer();
        Object rsp = CollectionAdminRequest.createCollection(collection, configSet, numShards, numReplicas).process(this.cloudClient());
        try {
            CollectionsHandler.waitForActiveCollection(collection, this.cc, rsp);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Failed waiting for new collection " + collection + " to reach the active state", SolrZkClient.checkInterrupted(e));
        }
        double tookMs = timer.getTime();
        log.debug("Took {} ms to create new collection {} with configSet {}", new Object[]{tookMs, collection, configSet});
    }

    protected CloudSolrClient cloudClient() {
        return this.cc.getSolrClientCache().getCloudSolrClient(this.cc.getZkController().getZkServerAddress());
    }

    protected ZkStateReader zkStateReader() {
        return this.cc.getZkController().getZkStateReader();
    }

    boolean applyCopyFieldUpdates(String mutableId, String copyDest, String fieldName, ManagedIndexSchema schema) throws IOException, SolrServerException {
        boolean updated = false;
        if (copyDest == null || copyDest.trim().isEmpty()) {
            List<CopyField> copyFieldsList = schema.getCopyFieldsList(fieldName);
            if (!copyFieldsList.isEmpty()) {
                List<String> dests = copyFieldsList.stream().map(cf -> cf.getDestination().getName()).collect(Collectors.toList());
                SchemaRequest.DeleteCopyField delAction = new SchemaRequest.DeleteCopyField(fieldName, dests);
                SchemaResponse.UpdateResponse schemaResponse = (SchemaResponse.UpdateResponse)delAction.process(this.cloudClient(), mutableId);
                if (schemaResponse.getStatus() != 0) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)schemaResponse.getException());
                }
                updated = true;
            }
        } else {
            Set del;
            SchemaField field = schema.getField(fieldName);
            HashSet<String> desired = new HashSet<String>();
            for (String dest : copyDest.trim().split(",")) {
                String toAdd = dest.trim();
                if (toAdd.equals(fieldName)) continue;
                SchemaField toAddField = schema.getFieldOrNull(toAdd);
                if (toAddField != null) {
                    if (!field.multiValued() || toAddField.multiValued()) {
                        desired.add(toAdd);
                        continue;
                    }
                    log.warn("Skipping copy-field dest {} for {} because it is not multi-valued!", (Object)toAdd, (Object)fieldName);
                    continue;
                }
                log.warn("Skipping copy-field dest {} for {} because it doesn't exist!", (Object)toAdd, (Object)fieldName);
            }
            Set existing = schema.getCopyFieldsList(fieldName).stream().map(cf -> cf.getDestination().getName()).collect(Collectors.toSet());
            Set add = desired.stream().filter(e -> !existing.contains(e)).collect(Collectors.toUnmodifiableSet());
            if (!add.isEmpty()) {
                SchemaRequest.AddCopyField addAction = new SchemaRequest.AddCopyField(fieldName, new ArrayList<String>(add));
                SchemaResponse.UpdateResponse schemaResponse = (SchemaResponse.UpdateResponse)addAction.process(this.cloudClient(), mutableId);
                if (schemaResponse.getStatus() != 0) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)schemaResponse.getException());
                }
                updated = true;
            }
            if (!(del = existing.stream().filter(e -> !desired.contains(e)).collect(Collectors.toUnmodifiableSet())).isEmpty()) {
                SchemaRequest.DeleteCopyField delAction = new SchemaRequest.DeleteCopyField(fieldName, new ArrayList<String>(del));
                SchemaResponse.UpdateResponse schemaResponse = (SchemaResponse.UpdateResponse)delAction.process(this.cloudClient(), mutableId);
                if (schemaResponse.getStatus() != 0) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)schemaResponse.getException());
                }
                updated = true;
            }
        }
        return updated;
    }

    protected boolean fieldHasMultiValuedChange(Object multiValued, SchemaField schemaField) {
        return multiValued == null || Boolean.TRUE.equals(multiValued) && !schemaField.multiValued() || Boolean.FALSE.equals(multiValued) && schemaField.multiValued();
    }

    protected boolean typeHasMultiValuedChange(Object multiValued, FieldType fieldType) {
        return multiValued == null || Boolean.TRUE.equals(multiValued) && !fieldType.isMultiValued() || Boolean.FALSE.equals(multiValued) && fieldType.isMultiValued();
    }

    ManagedIndexSchema syncLanguageSpecificObjectsAndFiles(String configSet, ManagedIndexSchema schema, List<String> langs, boolean dynamicEnabled, String copyFrom) throws IOException {
        if (!langs.isEmpty()) {
            schema = this.removeLanguageSpecificObjectsAndFiles(configSet, schema, langs);
        }
        schema = this.restoreLanguageSpecificObjectsAndFiles(configSet, schema, langs, dynamicEnabled, copyFrom);
        schema.persistManagedSchema(false);
        return schema;
    }

    protected ManagedIndexSchema removeLanguageSpecificObjectsAndFiles(String configSet, ManagedIndexSchema schema, List<String> langs) throws IOException {
        HashSet<String> languages = new HashSet<String>(includeLangIds);
        languages.addAll(langs);
        Set usedTypes = schema.getFields().values().stream().map(f -> f.getType().getTypeName()).collect(Collectors.toSet());
        Set usedLangs = schema.getFields().values().stream().filter(f -> this.isTextType(f.getType())).map(f -> f.getType().getTypeName().substring(TEXT_PREFIX_LEN)).collect(Collectors.toSet());
        languages.addAll(usedLangs);
        Map<String, FieldType> types = schema.getFieldTypes();
        Set toRemove = types.values().stream().filter(this::isTextType).filter(t -> !languages.contains(t.getTypeName().substring(TEXT_PREFIX_LEN))).map(FieldType::getTypeName).filter(t -> !usedTypes.contains(t)).collect(Collectors.toSet());
        List toRemoveDF = Arrays.stream(schema.getDynamicFields()).filter(df -> toRemove.contains(df.getPrototype().getType().getTypeName())).map(df -> df.getPrototype().getName()).collect(Collectors.toList());
        schema = ((ManagedIndexSchema)schema).deleteDynamicFields((Collection)toRemoveDF);
        schema = ((ManagedIndexSchema)schema).deleteFieldTypes((Collection)toRemove);
        SolrZkClient zkClient = this.cc.getZkController().getZkClient();
        String configPathInZk = "/configs/" + configSet;
        HashSet toRemoveFiles = new HashSet();
        Set langExt = languages.stream().map(l -> "_" + l).collect(Collectors.toSet());
        try {
            ZkMaintenanceUtils.traverseZkTree(zkClient, configPathInZk, ZkMaintenanceUtils.VISIT_ORDER.VISIT_POST, path -> {
                if (!this.isMatchingLangOrNonLangFile(path, langExt)) {
                    toRemoveFiles.add(path);
                }
            });
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Failed to traverse znode path: " + configPathInZk, SolrZkClient.checkInterrupted(e));
        }
        for (String path2 : toRemoveFiles) {
            try {
                zkClient.delete(path2, -1, false);
            }
            catch (KeeperException.NoNodeException noNodeException) {
            }
            catch (InterruptedException | KeeperException e) {
                throw new IOException("Failed to delete znode: " + path2, SolrZkClient.checkInterrupted(e));
            }
        }
        return schema;
    }

    protected ManagedIndexSchema restoreLanguageSpecificObjectsAndFiles(String configSet, ManagedIndexSchema schema, List<String> langs, boolean dynamicEnabled, String copyFrom) throws IOException {
        ManagedIndexSchema copyFromSchema = this.loadLatestSchema(copyFrom);
        HashSet<String> langSet = new HashSet<String>(includeLangIds);
        langSet.addAll(langs);
        boolean restoreAllLangs = langs.isEmpty();
        HashSet langFilesToRestore = new HashSet();
        SolrZkClient zkClient = this.zkStateReader().getZkClient();
        String configPathInZk = "/configs/" + copyFrom;
        Set langExt = langSet.stream().map(l -> "_" + l).collect(Collectors.toSet());
        try {
            ZkMaintenanceUtils.traverseZkTree(zkClient, configPathInZk, ZkMaintenanceUtils.VISIT_ORDER.VISIT_POST, path -> {
                if (path.endsWith(".txt")) {
                    if (restoreAllLangs) {
                        langFilesToRestore.add(path);
                        return;
                    }
                    String pathWoExt = path.substring(0, path.length() - 4);
                    for (String lang : langExt) {
                        if (!pathWoExt.endsWith(lang)) continue;
                        langFilesToRestore.add(path);
                        break;
                    }
                }
            });
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Failed to traverse znode path: " + configPathInZk, SolrZkClient.checkInterrupted(e));
        }
        if (!langFilesToRestore.isEmpty()) {
            String replacePathDir = ZNODE_PATH_DELIM + configSet;
            String origPathDir = ZNODE_PATH_DELIM + copyFrom;
            for (String path2 : langFilesToRestore) {
                String copyToPath = path2.replace(origPathDir, replacePathDir);
                try {
                    if (zkClient.exists(copyToPath, true).booleanValue()) continue;
                    zkClient.makePath(copyToPath, false, true);
                    zkClient.setData(copyToPath, zkClient.getData(path2, null, null, true), true);
                }
                catch (InterruptedException | KeeperException e) {
                    throw new IOException("Failed to restore file at znode path: " + copyToPath, SolrZkClient.checkInterrupted(e));
                }
            }
        }
        Map<String, FieldType> existingTypes = schema.getFieldTypes();
        List addTypes = copyFromSchema.getFieldTypes().values().stream().filter(t -> this.isLangTextType((FieldType)t, restoreAllLangs ? null : langSet) && !existingTypes.containsKey(t.getTypeName())).collect(Collectors.toList());
        if (!addTypes.isEmpty()) {
            schema = ((ManagedIndexSchema)schema).addFieldTypes(addTypes, false);
        }
        if (dynamicEnabled) {
            Set existingDynFields = Arrays.stream(schema.getDynamicFieldPrototypes()).map(SchemaField::getName).collect(Collectors.toSet());
            Set langFieldTypeNames = schema.getFieldTypes().values().stream().filter(t -> this.isLangTextType((FieldType)t, restoreAllLangs ? null : langSet)).map(FieldType::getTypeName).collect(Collectors.toSet());
            List addDynFields = Arrays.stream(copyFromSchema.getDynamicFields()).filter(df -> langFieldTypeNames.contains(df.getPrototype().getType().getTypeName())).filter(df -> !existingDynFields.contains(df.getPrototype().getName())).map(IndexSchema.DynamicField::getPrototype).collect(Collectors.toList());
            if (!addDynFields.isEmpty()) {
                schema = ((ManagedIndexSchema)schema).addDynamicFields((Collection)addDynFields, (Map)null, false);
            }
        } else {
            schema = this.removeDynamicFields((ManagedIndexSchema)schema);
        }
        return schema;
    }

    private boolean isMatchingLangOrNonLangFile(String path, Set<String> langs) {
        String fileName;
        if (!path.endsWith(".txt")) {
            return true;
        }
        int slashAt = path.lastIndexOf(47);
        String string = fileName = slashAt != -1 ? path.substring(slashAt + 1) : "";
        if (!fileName.contains("_")) {
            return true;
        }
        String pathWoExt = fileName.substring(0, fileName.length() - 4);
        for (String lang : langs) {
            if (!pathWoExt.endsWith(lang)) continue;
            return true;
        }
        return false;
    }

    private boolean isTextType(FieldType t) {
        return t.getTypeName().startsWith("text_") && TextField.class.equals(t.getClass());
    }

    private boolean isLangTextType(FieldType t, Set<String> langSet) {
        return this.isTextType(t) && (langSet == null || langSet.contains(t.getTypeName().substring("text_".length())));
    }

    protected ManagedIndexSchema removeDynamicFields(ManagedIndexSchema schema) {
        List dynamicFieldNames = Arrays.stream(schema.getDynamicFields()).map(f -> f.getPrototype().getName()).collect(Collectors.toList());
        if (!dynamicFieldNames.isEmpty()) {
            schema = schema.deleteDynamicFields((Collection)dynamicFieldNames);
        }
        return schema;
    }

    protected ManagedIndexSchema restoreDynamicFields(ManagedIndexSchema schema, List<String> langs, String copyFrom) {
        ManagedIndexSchema copyFromSchema = this.loadLatestSchema(copyFrom);
        IndexSchema.DynamicField[] dynamicFields = copyFromSchema.getDynamicFields();
        if (dynamicFields.length == 0 && !"_default".equals(copyFrom)) {
            copyFromSchema = this.loadLatestSchema("_default");
            dynamicFields = copyFromSchema.getDynamicFields();
        }
        if (dynamicFields.length == 0) {
            return schema;
        }
        Set existingDFNames = Arrays.stream(schema.getDynamicFields()).map(df -> df.getPrototype().getName()).collect(Collectors.toSet());
        List toAdd = Arrays.stream(dynamicFields).filter(df -> !existingDFNames.contains(df.getPrototype().getName())).map(IndexSchema.DynamicField::getPrototype).collect(Collectors.toList());
        if (!langs.isEmpty()) {
            HashSet<String> langSet = new HashSet<String>(includeLangIds);
            langSet.addAll(langs);
            toAdd = toAdd.stream().filter(df -> !df.getName().startsWith("*_txt_") || langSet.contains(df.getName().substring("*_txt_".length()))).collect(Collectors.toList());
        }
        if (!toAdd.isEmpty()) {
            Map<String, FieldType> fieldTypes = schema.getFieldTypes();
            List addTypes = toAdd.stream().map(SchemaField::getType).filter(t -> !fieldTypes.containsKey(t.getTypeName())).collect(Collectors.toList());
            if (!addTypes.isEmpty()) {
                schema = schema.addFieldTypes(addTypes, false);
            }
            schema = schema.addDynamicFields((Collection)toAdd, (Map)null, true);
        }
        return schema;
    }

    void checkSchemaVersion(String configSet, int versionInRequest, int currentVersion) throws IOException {
        if (versionInRequest < 0) {
            return;
        }
        if (currentVersion == -1) {
            currentVersion = this.getCurrentSchemaVersion(configSet);
        }
        if (currentVersion != versionInRequest) {
            if (configSet.startsWith("._designer_")) {
                configSet = configSet.substring("._designer_".length());
            }
            throw new SolrException(SolrException.ErrorCode.CONFLICT, "Your schema version " + versionInRequest + " for " + configSet + " is out-of-date; current version is: " + currentVersion + ". Perhaps another user also updated the schema while you were editing it? You'll need to retry your update after the schema is refreshed.");
        }
    }

    List<String> listConfigsInZk() throws IOException {
        return this.cc.getConfigSetService().listConfigs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] downloadAndZipConfigSet(String configId) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        final Path tmpDirectory = Files.createTempDirectory("schema-designer-" + FilenameUtils.getName((String)configId), new FileAttribute[0]);
        try {
            this.cc.getConfigSetService().downloadConfig(configId, tmpDirectory);
            try (final ZipOutputStream zipOut = new ZipOutputStream(baos);){
                Files.walkFileTree(tmpDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (Files.isHidden(dir)) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        Object dirName = tmpDirectory.relativize(dir).toString();
                        if (!((String)dirName).endsWith(SchemaDesignerConfigSetHelper.ZNODE_PATH_DELIM)) {
                            dirName = (String)dirName + SchemaDesignerConfigSetHelper.ZNODE_PATH_DELIM;
                        }
                        zipOut.putNextEntry(new ZipEntry((String)dirName));
                        zipOut.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (!Files.isHidden(file)) {
                            try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
                                ZipEntry zipEntry = new ZipEntry(tmpDirectory.relativize(file).toString());
                                zipOut.putNextEntry(zipEntry);
                                fis.transferTo(zipOut);
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        finally {
            PathUtils.deleteDirectory((Path)tmpDirectory);
        }
        return baos.toByteArray();
    }

    public boolean isConfigSetTrusted(String configSetName) {
        try {
            return this.cc.getConfigSetService().isConfigSetTrusted(configSetName);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load conf " + configSetName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void removeConfigSetTrust(String configSetName) {
        try {
            Map<String, Object> metadata = Collections.singletonMap("trusted", false);
            this.cc.getConfigSetService().setConfigMetadata(configSetName, metadata);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not remove trusted flag for configSet " + configSetName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected ZkSolrResourceLoader zkLoaderForConfigSet(String configSet) {
        SolrResourceLoader loader = this.cc.getResourceLoader();
        return new ZkSolrResourceLoader(loader.getInstancePath(), configSet, loader.getClassLoader(), this.cc.getZkController());
    }
}

