/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.handler.export.FloatComp;
import org.apache.solr.handler.export.SortValue;

class FloatValue
implements SortValue {
    protected NumericDocValues vals;
    protected String field;
    protected float currentValue;
    protected FloatComp comp;
    private int lastDocID;
    private boolean present;

    public FloatValue(String field, FloatComp comp) {
        this.field = field;
        this.comp = comp;
        this.currentValue = comp.resetValue();
        this.present = false;
    }

    @Override
    public Object getCurrentValue() {
        assert (this.present);
        return Float.valueOf(this.currentValue);
    }

    @Override
    public void toGlobalValue(SortValue previousValue) {
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public FloatValue copy() {
        return new FloatValue(this.field, this.comp);
    }

    @Override
    public void setNextReader(LeafReaderContext context) throws IOException {
        this.vals = DocValues.getNumeric(context.reader(), this.field);
        this.lastDocID = 0;
    }

    @Override
    public void setCurrentValue(int docId) throws IOException {
        if (docId < this.lastDocID) {
            throw new AssertionError((Object)("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs doc=" + docId));
        }
        this.lastDocID = docId;
        int curDocID = this.vals.docID();
        if (docId > curDocID) {
            curDocID = this.vals.advance(docId);
        }
        if (docId == curDocID) {
            this.present = true;
            this.currentValue = Float.intBitsToFloat((int)this.vals.longValue());
        } else {
            this.present = false;
            this.currentValue = 0.0f;
        }
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public void setCurrentValue(SortValue sv) {
        FloatValue fv = (FloatValue)sv;
        this.currentValue = fv.currentValue;
        this.present = fv.present;
    }

    @Override
    public void reset() {
        this.currentValue = this.comp.resetValue();
        this.present = false;
    }

    @Override
    public int compareTo(SortValue o) {
        FloatValue fv = (FloatValue)o;
        return this.comp.compare(this.currentValue, fv.currentValue);
    }
}

