/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.loader;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.JsonRecordReader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.RecordingJSONParser;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLoader
extends ContentStreamLoader {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicBoolean WARNED_ABOUT_INDEX_TIME_BOOSTS = new AtomicBoolean();
    public static final String CHILD_DOC_KEY = "_childDocuments_";

    @Override
    public String getDefaultWT() {
        return "json";
    }

    @Override
    public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws Exception {
        new SingleThreadedJsonLoader(req, rsp, processor).load(req, rsp, stream, processor);
    }

    public static SolrInputDocument buildDoc(Map<String, Object> m) {
        SolrInputDocument result = new SolrInputDocument();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (JsonLoader.mapEntryIsChildDoc(e.getValue())) {
                if (e.getValue() instanceof List) {
                    List value = (List)e.getValue();
                    for (Object o : value) {
                        if (!(o instanceof Map)) continue;
                        if (!result.containsKey(e.getKey())) {
                            result.setField(e.getKey(), new ArrayList(1));
                        }
                        result.addField(e.getKey(), JsonLoader.buildDoc((Map)o));
                    }
                    continue;
                }
                if (!(e.getValue() instanceof Map)) continue;
                result.addField(e.getKey(), JsonLoader.buildDoc((Map)e.getValue()));
                continue;
            }
            result.setField(e.getKey(), e.getValue());
        }
        return result;
    }

    private static boolean mapEntryIsChildDoc(Object val) {
        if (val instanceof List) {
            List listVal = (List)val;
            if (listVal.size() == 0) {
                return false;
            }
            return listVal.get(0) instanceof Map;
        }
        return val instanceof Map;
    }

    private static Object changeChildDoc(Object o) {
        if (o instanceof List) {
            return ((List)o).stream().map(JsonLoader::changeChildDoc).collect(Collectors.toList());
        }
        Map m = (Map)o;
        if (m.containsKey(null)) {
            m.put(CHILD_DOC_KEY, JsonLoader.changeChildDoc(m.remove(null)));
        }
        return m;
    }

    static class SingleThreadedJsonLoader
    extends ContentStreamLoader {
        protected final UpdateRequestProcessor processor;
        protected final SolrQueryRequest req;
        protected SolrQueryResponse rsp;
        protected JSONParser parser;
        protected final int commitWithin;
        protected final boolean overwrite;

        SingleThreadedJsonLoader(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor processor) {
            this.processor = processor;
            this.req = req;
            this.rsp = rsp;
            this.commitWithin = req.getParams().getInt("commitWithin", -1);
            this.overwrite = req.getParams().getBool("overwrite", true);
        }

        @Override
        public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws Exception {
            try (Reader reader = this.getReader(stream);){
                this.processUpdate(reader);
            }
            catch (JSONParser.ParseException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot parse provided JSON: " + e.getMessage());
            }
        }

        private Reader getReader(ContentStream stream) throws IOException {
            if (log.isTraceEnabled()) {
                String body = StrUtils.stringFromReader(stream.getReader());
                log.trace("body: {}", (Object)body);
                return new StringReader(body);
            }
            return stream.getReader();
        }

        void processUpdate(Reader reader) throws IOException {
            String path = (String)this.req.getContext().get("path");
            if ("/update/json/docs".equals(path) || "false".equals(this.req.getParams().get("json.command"))) {
                String split = this.req.getParams().get("split");
                String[] f = this.req.getParams().getParams("f");
                this.handleSplitMode(split, f, reader);
                return;
            }
            this.parser = new JSONParser(reader);
            int ev = this.parser.nextEvent();
            while (ev != 11) {
                switch (ev) {
                    case 9: {
                        this.handleAdds();
                        break;
                    }
                    case 1: {
                        if (this.parser.wasKey()) {
                            String v = this.parser.getString();
                            if (v.equals("add")) {
                                int ev2 = this.parser.nextEvent();
                                if (ev2 == 7) {
                                    this.processor.processAdd(this.parseAdd());
                                    break;
                                }
                                if (ev2 == 9) {
                                    this.handleAdds();
                                    break;
                                }
                                this.assertEvent(ev2, 7);
                                break;
                            }
                            if (v.equals("commit")) {
                                CommitUpdateCommand cmd = new CommitUpdateCommand(this.req, false);
                                cmd.waitSearcher = true;
                                this.parseCommitOptions(cmd);
                                this.processor.processCommit(cmd);
                                break;
                            }
                            if (v.equals("optimize")) {
                                CommitUpdateCommand cmd = new CommitUpdateCommand(this.req, true);
                                cmd.waitSearcher = true;
                                this.parseCommitOptions(cmd);
                                this.processor.processCommit(cmd);
                                break;
                            }
                            if (v.equals("delete")) {
                                this.handleDeleteCommand();
                                break;
                            }
                            if (v.equals("rollback")) {
                                this.processor.processRollback(this.parseRollback());
                                break;
                            }
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown command '" + v + "' at [" + this.parser.getPosition() + "]");
                        }
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (log.isInfoEnabled()) {
                            log.info("Can't have a value here. Unexpected {} at [{}]", (Object)JSONParser.getEventString(ev), (Object)this.parser.getPosition());
                        }
                    }
                    case 7: 
                    case 8: 
                    case 10: {
                        break;
                    }
                    default: {
                        log.info("Noggit UNKNOWN_EVENT_ID: {}", (Object)ev);
                    }
                }
                ev = this.parser.nextEvent();
            }
        }

        private void handleSplitMode(String split, String[] fields, Reader reader) throws IOException {
            if (split == null) {
                split = "/";
            }
            if (fields == null || fields.length == 0) {
                fields = new String[]{"$FQN:/**"};
            }
            final boolean echo = "true".equals(this.req.getParams().get("echo"));
            final String srcField = this.req.getParams().get("srcField");
            final boolean mapUniqueKeyOnly = this.req.getParams().getBool("mapUniqueKeyOnly", false);
            if (srcField != null) {
                if (!"/".equals(split)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Raw data can be stored only if split=/");
                }
                this.parser = new RecordingJSONParser(reader);
            } else {
                this.parser = new JSONParser(reader);
            }
            JsonRecordReader jsonRecordReader = JsonRecordReader.getInst(split, Arrays.asList(fields));
            jsonRecordReader.streamRecords(this.parser, new JsonRecordReader.Handler(){
                ArrayList<Map<String, Object>> docs = null;

                @Override
                public void handle(Map<String, Object> record, String path) {
                    Map<String, Object> copy = this.getDocMap(record, parser, srcField, mapUniqueKeyOnly);
                    if (echo) {
                        if (this.docs == null) {
                            this.docs = new ArrayList();
                            rsp.add("docs", this.docs);
                        }
                        JsonLoader.changeChildDoc(copy);
                        this.docs.add(copy);
                    } else {
                        AddUpdateCommand cmd = new AddUpdateCommand(req);
                        cmd.commitWithin = commitWithin;
                        cmd.overwrite = overwrite;
                        cmd.solrDoc = JsonLoader.buildDoc(copy);
                        try {
                            processor.processAdd(cmd);
                        }
                        catch (IOException e) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error inserting document: ", (Throwable)e);
                        }
                    }
                }
            });
        }

        private Map<String, Object> getDocMap(Map<String, Object> record, JSONParser parser, String srcField, boolean mapUniqueKeyOnly) {
            LinkedHashMap<String, Object> result;
            LinkedHashMap<String, Object> linkedHashMap = result = mapUniqueKeyOnly ? record : new LinkedHashMap<String, Object>(record);
            if (srcField != null && parser instanceof RecordingJSONParser) {
                RecordingJSONParser rjp = (RecordingJSONParser)parser;
                result.put(srcField, rjp.getBuf());
                rjp.resetBuf();
            }
            if (mapUniqueKeyOnly) {
                SchemaField sf = this.req.getSchema().getUniqueKeyField();
                if (sf == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No uniqueKey specified in schema");
                }
                String df = this.req.getParams().get("df");
                if (df == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No 'df' specified in request");
                }
                LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>();
                String uniqueField = (String)record.get(sf.getName());
                if (uniqueField == null) {
                    uniqueField = UUID.randomUUID().toString().toLowerCase(Locale.ROOT);
                }
                copy.put(sf.getName(), uniqueField);
                if (srcField != null && result.containsKey(srcField)) {
                    copy.put(srcField, result.remove(srcField));
                }
                ArrayList deepValues = new ArrayList();
                deepValues.addAll(result.values());
                copy.put(df, deepValues);
                result = copy;
            }
            return result;
        }

        void handleDeleteCommand() throws IOException {
            int ev = this.parser.nextEvent();
            switch (ev) {
                case 9: {
                    this.handleDeleteArray(ev);
                    break;
                }
                case 7: {
                    this.handleDeleteMap(ev);
                    break;
                }
                default: {
                    this.handleSingleDelete(ev);
                }
            }
        }

        String getString(int ev) throws IOException {
            switch (ev) {
                case 1: {
                    return this.parser.getString();
                }
                case 2: 
                case 3: 
                case 4: {
                    return this.parser.getNumberChars().toString();
                }
                case 5: {
                    return Boolean.toString(this.parser.getBoolean());
                }
                case 6: {
                    return null;
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected primitive JSON value but got: " + JSONParser.getEventString(ev) + " at [" + this.parser.getPosition() + "]");
        }

        void handleSingleDelete(int ev) throws IOException {
            if (ev == 7) {
                this.handleDeleteMap(ev);
            } else {
                DeleteUpdateCommand cmd = new DeleteUpdateCommand(this.req);
                cmd.commitWithin = this.commitWithin;
                String id = this.getString(ev);
                cmd.setId(id);
                this.processor.processDelete(cmd);
            }
        }

        void handleDeleteArray(int ev) throws IOException {
            assert (ev == 9);
            while ((ev = this.parser.nextEvent()) != 10) {
                this.handleSingleDelete(ev);
            }
            return;
        }

        void handleDeleteMap(int ev) throws IOException {
            assert (ev == 7);
            DeleteUpdateCommand cmd = new DeleteUpdateCommand(this.req);
            cmd.commitWithin = this.commitWithin;
            while ((ev = this.parser.nextEvent()) == 1) {
                String key = this.parser.getString();
                if (this.parser.wasKey()) {
                    if ("id".equals(key)) {
                        cmd.setId(this.getString(this.parser.nextEvent()));
                        continue;
                    }
                    if ("query".equals(key)) {
                        cmd.setQuery(this.parser.getString());
                        continue;
                    }
                    if ("commitWithin".equals(key)) {
                        cmd.commitWithin = (int)this.parser.getLong();
                        continue;
                    }
                    if ("_version_".equals(key)) {
                        cmd.setVersion(this.parser.getLong());
                        continue;
                    }
                    if ("_route_".equals(key)) {
                        cmd.setRoute(this.parser.getString());
                        continue;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown key '" + key + "' at [" + this.parser.getPosition() + "]");
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid string: " + key + " at [" + this.parser.getPosition() + "]");
            }
            if (ev == 8) {
                if (cmd.getId() == null && cmd.getQuery() == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing id or query for delete at [" + this.parser.getPosition() + "]");
                }
                this.processor.processDelete(cmd);
                return;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Got: " + JSONParser.getEventString(ev) + " at [" + this.parser.getPosition() + "]");
        }

        RollbackUpdateCommand parseRollback() throws IOException {
            this.assertNextEvent(7);
            this.assertNextEvent(8);
            return new RollbackUpdateCommand(this.req);
        }

        void parseCommitOptions(CommitUpdateCommand cmd) throws IOException {
            this.assertNextEvent(7);
            final Map map = (Map)ObjectBuilder.getVal(this.parser);
            SolrParams p = new SolrParams(){

                @Override
                public String get(String param) {
                    Object o = map.get(param);
                    return o == null ? null : o.toString();
                }

                @Override
                public String[] getParams(String param) {
                    return new String[]{this.get(param)};
                }

                @Override
                public Iterator<String> getParameterNamesIterator() {
                    return map.keySet().iterator();
                }
            };
            RequestHandlerUtils.validateCommitParams(p);
            p = SolrParams.wrapDefaults(p, this.req.getParams());
            RequestHandlerUtils.updateCommit(cmd, p);
        }

        AddUpdateCommand parseAdd() throws IOException {
            int ev;
            AddUpdateCommand cmd = new AddUpdateCommand(this.req);
            cmd.commitWithin = this.commitWithin;
            cmd.overwrite = this.overwrite;
            while ((ev = this.parser.nextEvent()) == 1) {
                if (this.parser.wasKey()) {
                    String key = this.parser.getString();
                    if ("doc".equals(key)) {
                        if (cmd.solrDoc != null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Multiple documents in same add command at [" + this.parser.getPosition() + "]");
                        }
                        ev = this.assertNextEvent(7);
                        cmd.solrDoc = this.parseDoc(ev);
                        continue;
                    }
                    if ("overwrite".equals(key)) {
                        cmd.overwrite = this.parser.getBoolean();
                        continue;
                    }
                    if ("commitWithin".equals(key)) {
                        cmd.commitWithin = (int)this.parser.getLong();
                        continue;
                    }
                    if ("boost".equals(key)) {
                        String boost = this.parser.getNumberChars().toString();
                        String message = "Ignoring document boost: " + boost + " as index-time boosts are not supported anymore";
                        if (WARNED_ABOUT_INDEX_TIME_BOOSTS.compareAndSet(false, true)) {
                            log.warn(message);
                            continue;
                        }
                        log.debug(message);
                        continue;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown key '" + key + "' at [" + this.parser.getPosition() + "]");
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Should be a key  at [" + this.parser.getPosition() + "]");
            }
            if (ev == 8) {
                if (cmd.solrDoc == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing solr document at [" + this.parser.getPosition() + "]");
                }
                return cmd;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Got: " + JSONParser.getEventString(ev) + " at [" + this.parser.getPosition() + "]");
        }

        void handleAdds() throws IOException {
            while (true) {
                AddUpdateCommand cmd = new AddUpdateCommand(this.req);
                cmd.commitWithin = this.commitWithin;
                cmd.overwrite = this.overwrite;
                int ev = this.parser.nextEvent();
                if (ev == 10) break;
                this.assertEvent(ev, 7);
                cmd.solrDoc = this.parseDoc(ev);
                this.processor.processAdd(cmd);
            }
        }

        int assertNextEvent(int expected) throws IOException {
            int got = this.parser.nextEvent();
            this.assertEvent(got, expected);
            return got;
        }

        void assertEvent(int ev, int expected) {
            if (ev != expected) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected: " + JSONParser.getEventString(expected) + " but got " + JSONParser.getEventString(ev) + " at [" + this.parser.getPosition() + "]");
            }
        }

        private SolrInputDocument parseDoc(int ev) throws IOException {
            assert (ev == 7);
            SolrInputDocument sdoc = new SolrInputDocument();
            block0: while ((ev = this.parser.nextEvent()) != 8) {
                String fieldName = this.parser.getString();
                if (fieldName.equals(JsonLoader.CHILD_DOC_KEY)) {
                    ev = this.parser.nextEvent();
                    this.assertEvent(ev, 9);
                    while (true) {
                        if ((ev = this.parser.nextEvent()) == 10) continue block0;
                        this.assertEvent(ev, 7);
                        sdoc.addChildDocument(this.parseDoc(ev));
                    }
                }
                ev = this.parser.nextEvent();
                Object val = this.parseFieldValue(ev, fieldName);
                sdoc.addField(fieldName, val);
            }
            return sdoc;
        }

        private Object parseFieldValue(int ev, String fieldName) throws IOException {
            switch (ev) {
                case 1: {
                    return this.parser.getString();
                }
                case 2: {
                    return this.parser.getLong();
                }
                case 3: {
                    return this.parser.getDouble();
                }
                case 4: {
                    return this.parser.getNumberChars().toString();
                }
                case 5: {
                    return this.parser.getBoolean();
                }
                case 6: {
                    this.parser.getNull();
                    return null;
                }
                case 9: {
                    return this.parseArrayFieldValue(ev, fieldName);
                }
                case 7: {
                    return this.parseObjectFieldValue(ev, fieldName);
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing JSON field value. Unexpected " + JSONParser.getEventString(ev) + " at [" + this.parser.getPosition() + "], field=" + fieldName);
        }

        private List<Object> parseArrayFieldValue(int ev, String fieldName) throws IOException {
            assert (ev == 9);
            ArrayList<Object> lst = new ArrayList<Object>(2);
            while ((ev = this.parser.nextEvent()) != 10) {
                lst.add(this.parseFieldValue(ev, fieldName));
            }
            return lst;
        }

        private Object parseObjectFieldValue(int ev, String fieldName) throws IOException {
            assert (ev == 7);
            SolrInputDocument extendedSolrDocument = this.parseDoc(ev);
            if (this.isChildDoc(extendedSolrDocument)) {
                return extendedSolrDocument;
            }
            assert (extendedSolrDocument.size() == 1);
            SolrInputField pair = extendedSolrDocument.iterator().next();
            return Collections.singletonMap(pair.getName(), pair.getValue());
        }

        private boolean isChildDoc(SolrInputDocument extendedFieldValue) {
            if (extendedFieldValue.size() != 1) {
                return true;
            }
            String fieldName = extendedFieldValue.iterator().next().getName();
            return this.req.getSchema().getFieldOrNull(fieldName) != null;
        }
    }
}

