/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.uhighlight.CustomSeparatorBreakIterator;
import org.apache.lucene.search.uhighlight.DefaultPassageFormatter;
import org.apache.lucene.search.uhighlight.LengthGoalBreakIterator;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.PassageScorer;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.search.uhighlight.WholeBreakIterator;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.util.RTimerTree;
import org.apache.solr.util.plugin.PluginInfoInitialized;

public class UnifiedSolrHighlighter
extends SolrHighlighter
implements PluginInfoInitialized {
    protected static final String SNIPPET_SEPARATOR = "\u0000";

    @Override
    public void init(PluginInfo info) {
    }

    @Override
    public NamedList<Object> doHighlighting(DocList docs, Query query, SolrQueryRequest req, String[] defaultFields) throws IOException {
        SolrParams params = req.getParams();
        if (!this.isHighlightingEnabled(params)) {
            return null;
        }
        int[] docIDs = this.toDocIDs(docs);
        String[] keys = this.getUniqueKeys(req.getSearcher(), docIDs);
        String[] fieldNames = this.getHighlightFields(query, req, defaultFields);
        int[] maxPassages = new int[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            maxPassages[i] = params.getFieldInt(fieldNames[i], "hl.snippets", 1);
        }
        UnifiedHighlighter highlighter = this.getHighlighter(req);
        Map<String, String[]> snippets = fieldNames.length == 0 ? Collections.emptyMap() : highlighter.highlightFields(fieldNames, query, docIDs, maxPassages);
        return this.encodeSnippets(keys, fieldNames, snippets);
    }

    protected UnifiedHighlighter getHighlighter(SolrQueryRequest req) {
        return new SolrExtendedUnifiedHighlighter(req);
    }

    protected NamedList<Object> encodeSnippets(String[] keys, String[] fieldNames, Map<String, String[]> snippets) {
        SimpleOrderedMap<Object> list = new SimpleOrderedMap<Object>();
        for (int i = 0; i < keys.length; ++i) {
            SimpleOrderedMap<String[]> summary = new SimpleOrderedMap<String[]>();
            for (String field : fieldNames) {
                String snippet = snippets.get(field)[i];
                if (snippet == null) continue;
                summary.add(field, snippet.split(SNIPPET_SEPARATOR));
            }
            list.add(keys[i], summary);
        }
        return list;
    }

    protected int[] toDocIDs(DocList docs) {
        int[] docIDs = new int[docs.size()];
        DocIterator iterator = docs.iterator();
        for (int i = 0; i < docIDs.length; ++i) {
            if (!iterator.hasNext()) {
                throw new AssertionError();
            }
            docIDs[i] = iterator.nextDoc();
        }
        if (iterator.hasNext()) {
            throw new AssertionError();
        }
        return docIDs;
    }

    protected String[] getUniqueKeys(SolrIndexSearcher searcher, int[] docIDs) throws IOException {
        IndexSchema schema = searcher.getSchema();
        SchemaField keyField = schema.getUniqueKeyField();
        if (keyField != null) {
            SolrReturnFields returnFields = new SolrReturnFields(keyField.getName(), null);
            String[] uniqueKeys = new String[docIDs.length];
            for (int i = 0; i < docIDs.length; ++i) {
                int docid = docIDs[i];
                SolrDocument solrDoc = searcher.getDocFetcher().solrDoc(docid, returnFields);
                uniqueKeys[i] = schema.printableUniqueKey(solrDoc);
            }
            return uniqueKeys;
        }
        return new String[docIDs.length];
    }

    protected static class SolrExtendedUnifiedHighlighter
    extends UnifiedHighlighter {
        protected static final Predicate<String> NOT_REQUIRED_FIELD_MATCH_PREDICATE = s -> true;
        private final SolrIndexSearcher solrIndexSearcher;
        protected final SolrParams params;
        protected final IndexSchema schema;
        protected final RTimerTree loadFieldValuesTimer;

        public SolrExtendedUnifiedHighlighter(SolrQueryRequest req) {
            super(req.getSearcher(), req.getSchema().getIndexAnalyzer());
            this.solrIndexSearcher = req.getSearcher();
            this.params = req.getParams();
            this.schema = req.getSchema();
            this.setMaxLength(this.params.getInt("hl.maxAnalyzedChars", SolrHighlighter.DEFAULT_MAX_CHARS));
            this.setCacheFieldValCharsThreshold(this.params.getInt("hl.cacheFieldValCharsThreshold", 524288));
            RTimerTree timerTree = req.getRequestTimer() != null ? req.getRequestTimer() : new RTimerTree();
            this.loadFieldValuesTimer = timerTree.sub("loadFieldValues");
            this.loadFieldValuesTimer.resume();
            this.loadFieldValuesTimer.pause();
        }

        @Override
        protected UnifiedHighlighter.OffsetSource getOffsetSource(String field) {
            String sourceStr = this.params.getFieldParam(field, "hl.offsetSource");
            if (sourceStr != null) {
                return UnifiedHighlighter.OffsetSource.valueOf(sourceStr.toUpperCase(Locale.ROOT));
            }
            return super.getOffsetSource(field);
        }

        @Override
        protected FieldInfo getFieldInfo(String field) {
            return ((SolrIndexSearcher)this.searcher).getFieldInfos().fieldInfo(field);
        }

        @Override
        public int getMaxNoHighlightPassages(String field) {
            boolean defaultSummary = this.params.getFieldBool(field, "hl.defaultSummary", false);
            if (defaultSummary) {
                return -1;
            }
            return 0;
        }

        @Override
        protected PassageFormatter getFormatter(String fieldName) {
            String preTag = this.params.getFieldParam(fieldName, "hl.tag.pre", this.params.getFieldParam(fieldName, "hl.simple.pre", "<em>"));
            String postTag = this.params.getFieldParam(fieldName, "hl.tag.post", this.params.getFieldParam(fieldName, "hl.simple.post", "</em>"));
            String ellipsis = this.params.getFieldParam(fieldName, "hl.tag.ellipsis", UnifiedSolrHighlighter.SNIPPET_SEPARATOR);
            String encoder = this.params.getFieldParam(fieldName, "hl.encoder", "simple");
            return new DefaultPassageFormatter(preTag, postTag, ellipsis, "html".equals(encoder));
        }

        @Override
        protected PassageScorer getScorer(String fieldName) {
            float k1 = this.params.getFieldFloat(fieldName, "hl.score.k1", 1.2f);
            float b = this.params.getFieldFloat(fieldName, "hl.score.b", 0.75f);
            float pivot = this.params.getFieldFloat(fieldName, "hl.score.pivot", 87.0f);
            return new PassageScorer(k1, b, pivot);
        }

        @Override
        protected BreakIterator getBreakIterator(String field) {
            BreakIterator baseBI;
            int fragsize = this.params.getFieldInt(field, "hl.fragsize", 70);
            String type = this.params.getFieldParam(field, "hl.bs.type");
            if (fragsize == 0 || "WHOLE".equals(type)) {
                return new WholeBreakIterator();
            }
            if ("SEPARATOR".equals(type)) {
                char customSep = this.parseBiSepChar(this.params.getFieldParam(field, "hl.bs.separator"));
                baseBI = new CustomSeparatorBreakIterator(customSep);
            } else {
                String language = this.params.getFieldParam(field, "hl.bs.language");
                String country = this.params.getFieldParam(field, "hl.bs.country");
                String variant = this.params.getFieldParam(field, "hl.bs.variant");
                Locale locale = this.parseLocale(language, country, variant);
                baseBI = this.parseBreakIterator(type, locale);
            }
            if (fragsize <= 1) {
                return baseBI;
            }
            float fragalign = this.params.getFieldFloat(field, "hl.fragAlignRatio", 0.33f);
            if (this.params.getFieldBool(field, "hl.fragsizeIsMinimum", true)) {
                return LengthGoalBreakIterator.createMinLength(baseBI, fragsize, fragalign);
            }
            return LengthGoalBreakIterator.createClosestToLength(baseBI, fragsize, fragalign);
        }

        protected char parseBiSepChar(String sepChar) {
            if (sepChar == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "hl.bs.separator not passed");
            }
            if (sepChar.length() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "hl.bs.separator must be a single char but got: '" + sepChar + "'");
            }
            return sepChar.charAt(0);
        }

        protected BreakIterator parseBreakIterator(String type, Locale locale) {
            if (type == null || "SENTENCE".equals(type)) {
                return BreakIterator.getSentenceInstance(locale);
            }
            if ("LINE".equals(type)) {
                return BreakIterator.getLineInstance(locale);
            }
            if ("WORD".equals(type)) {
                return BreakIterator.getWordInstance(locale);
            }
            if ("CHARACTER".equals(type)) {
                return BreakIterator.getCharacterInstance(locale);
            }
            throw new IllegalArgumentException("Unknown hl.bs.type: " + type);
        }

        protected Locale parseLocale(String language, String country, String variant) {
            if (language == null && country == null && variant == null) {
                return Locale.ROOT;
            }
            if (language == null) {
                throw new IllegalArgumentException("language is required if country or variant is specified");
            }
            if (country == null && variant != null) {
                throw new IllegalArgumentException("To specify variant, country is required");
            }
            if (country != null && variant != null) {
                return new Locale(language, country, variant);
            }
            if (country != null) {
                return new Locale(language, country);
            }
            return new Locale(language);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<CharSequence[]> loadFieldValues(String[] fields, DocIdSetIterator docIter, int cacheCharsThreshold) throws IOException {
            this.loadFieldValuesTimer.resume();
            try {
                List<CharSequence[]> list = super.loadFieldValues(fields, docIter, cacheCharsThreshold);
                return list;
            }
            finally {
                this.loadFieldValuesTimer.pause();
            }
        }

        @Override
        protected Set<UnifiedHighlighter.HighlightFlag> getFlags(String field) {
            EnumSet<UnifiedHighlighter.HighlightFlag> flags = EnumSet.noneOf(UnifiedHighlighter.HighlightFlag.class);
            if (this.params.getFieldBool(field, "hl.highlightMultiTerm", true)) {
                flags.add(UnifiedHighlighter.HighlightFlag.MULTI_TERM_QUERY);
            }
            if (this.params.getFieldBool(field, "hl.usePhraseHighlighter", true)) {
                flags.add(UnifiedHighlighter.HighlightFlag.PHRASES);
            }
            flags.add(UnifiedHighlighter.HighlightFlag.PASSAGE_RELEVANCY_OVER_SPEED);
            if (this.params.getFieldBool(field, "hl.weightMatches", true) && flags.contains((Object)UnifiedHighlighter.HighlightFlag.PHRASES) && flags.contains((Object)UnifiedHighlighter.HighlightFlag.MULTI_TERM_QUERY)) {
                flags.add(UnifiedHighlighter.HighlightFlag.WEIGHT_MATCHES);
            }
            return flags;
        }

        @Override
        protected Predicate<String> getFieldMatcher(String field) {
            if (this.params.getFieldBool(field, "hl.requireFieldMatch", false)) {
                return field::equals;
            }
            String[] queryFieldPattern = this.params.getFieldParams(field, "hl.queryFieldPattern");
            if (queryFieldPattern != null && queryFieldPattern.length != 0) {
                Supplier<Collection<String>> indexedFieldsSupplier = () -> this.solrIndexSearcher.getDocFetcher().getIndexedFieldNames();
                Set<String> fields = Set.of(SolrHighlighter.expandWildcardsInFields(indexedFieldsSupplier, queryFieldPattern));
                return fields::contains;
            }
            return NOT_REQUIRED_FIELD_MATCH_PREDICATE;
        }
    }
}

