/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.index;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.Version;

public final class SlowCompositeReaderWrapper
extends LeafReader {
    private final CompositeReader in;
    private final LeafMetaData metaData;
    private final FieldInfos fieldInfos;
    final Map<String, OrdinalMap> cachedOrdMaps = new ConcurrentHashMap<String, OrdinalMap>();

    public static LeafReader wrap(IndexReader reader) throws IOException {
        if (reader instanceof CompositeReader) {
            return new SlowCompositeReaderWrapper((CompositeReader)reader);
        }
        assert (reader instanceof LeafReader);
        return (LeafReader)reader;
    }

    SlowCompositeReaderWrapper(CompositeReader reader) throws IOException {
        this.in = reader;
        this.in.registerParentReader(this);
        if (reader.leaves().isEmpty()) {
            this.metaData = new LeafMetaData(Version.LATEST.major, Version.LATEST, null, false);
        } else {
            Version minVersion = Version.LATEST;
            for (LeafReaderContext leafReaderContext : reader.leaves()) {
                Version leafVersion = leafReaderContext.reader().getMetaData().getMinVersion();
                if (leafVersion == null) {
                    minVersion = null;
                    break;
                }
                if (!minVersion.onOrAfter(leafVersion)) continue;
                minVersion = leafVersion;
            }
            LeafMetaData leafMetaData = reader.leaves().get(0).reader().getMetaData();
            this.metaData = new LeafMetaData(leafMetaData.getCreatedVersionMajor(), minVersion, leafMetaData.getSort(), leafMetaData.hasBlocks());
        }
        this.fieldInfos = FieldInfos.getMergedFieldInfos(this.in);
    }

    public String toString() {
        return "SlowCompositeReaderWrapper(" + this.in + ")";
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    @Override
    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    @Override
    public Terms terms(String field) throws IOException {
        this.ensureOpen();
        return MultiTerms.getTerms(this.in, field);
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getNumericValues(this.in, field);
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getBinaryValues(this.in, field);
    }

    @Override
    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getSortedNumericValues(this.in, field);
    }

    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        List<LeafReaderContext> leaves = this.in.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedDocValues(field);
        }
        boolean anyReal = false;
        SortedDocValues[] values = new SortedDocValues[size];
        int[] starts = new int[size + 1];
        long totalCost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = this.in.leaves().get(i);
            LeafReader reader = context.reader();
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.SORTED) {
                return null;
            }
            SortedDocValues v = reader.getSortedDocValues(field);
            if (v == null) {
                v = DocValues.emptySorted();
            } else {
                anyReal = true;
            }
            totalCost += v.cost();
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = this.maxDoc();
        if (!anyReal) {
            return null;
        }
        OrdinalMap map = null;
        IndexReader.CacheHelper cacheHelper = this.getReaderCacheHelper();
        Function<String, OrdinalMap> producer = notUsed -> {
            try {
                OrdinalMap mapping = OrdinalMap.build(cacheHelper == null ? null : cacheHelper.getKey(), values, 0.25f);
                return mapping;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        map = cacheHelper != null ? this.cachedOrdMaps.computeIfAbsent(field + cacheHelper.getKey(), producer) : producer.apply("notUsed");
        return new MultiDocValues.MultiSortedDocValues(values, starts, map, totalCost);
    }

    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        List<LeafReaderContext> leaves = this.in.leaves();
        int size = leaves.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return leaves.get(0).reader().getSortedSetDocValues(field);
        }
        boolean anyReal = false;
        SortedSetDocValues[] values = new SortedSetDocValues[size];
        int[] starts = new int[size + 1];
        long totalCost = 0L;
        for (int i = 0; i < size; ++i) {
            LeafReaderContext context = this.in.leaves().get(i);
            LeafReader reader = context.reader();
            FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(field);
            if (fieldInfo != null && fieldInfo.getDocValuesType() != DocValuesType.SORTED_SET) {
                return null;
            }
            SortedSetDocValues v = reader.getSortedSetDocValues(field);
            if (v == null) {
                v = DocValues.emptySortedSet();
            } else {
                anyReal = true;
            }
            totalCost += v.cost();
            values[i] = v;
            starts[i] = context.docBase;
        }
        starts[size] = this.maxDoc();
        if (!anyReal) {
            return null;
        }
        OrdinalMap map = null;
        IndexReader.CacheHelper cacheHelper = this.getReaderCacheHelper();
        Function<String, OrdinalMap> producer = notUsed -> {
            try {
                OrdinalMap mapping = OrdinalMap.build(cacheHelper == null ? null : cacheHelper.getKey(), values, 0.25f);
                return mapping;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        map = cacheHelper != null ? this.cachedOrdMaps.computeIfAbsent(field + cacheHelper.getKey(), producer) : producer.apply("notUsed");
        return new MultiDocValues.MultiSortedSetDocValues(values, starts, map, totalCost);
    }

    @Override
    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        return MultiDocValues.getNormValues(this.in, field);
    }

    @Override
    public Fields getTermVectors(int docID) throws IOException {
        return this.in.getTermVectors(docID);
    }

    @Override
    public TermVectors termVectors() throws IOException {
        this.ensureOpen();
        return this.in.termVectors();
    }

    @Override
    public StoredFields storedFields() throws IOException {
        this.ensureOpen();
        return this.in.storedFields();
    }

    @Override
    public int numDocs() {
        return this.in.numDocs();
    }

    @Override
    public int maxDoc() {
        return this.in.maxDoc();
    }

    @Override
    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.ensureOpen();
        this.in.document(docID, visitor);
    }

    @Override
    public Bits getLiveDocs() {
        this.ensureOpen();
        return MultiBits.getLiveDocs(this.in);
    }

    @Override
    public PointValues getPointValues(String field) {
        this.ensureOpen();
        throw new UnsupportedOperationException();
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String field) {
        this.ensureOpen();
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteVectorValues getByteVectorValues(String field) {
        this.ensureOpen();
        throw new UnsupportedOperationException();
    }

    @Override
    public void searchNearestVectors(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void searchNearestVectors(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    protected void doClose() throws IOException {
        this.in.close();
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        for (LeafReaderContext ctx : this.in.leaves()) {
            ctx.reader().checkIntegrity();
        }
    }

    @Override
    public LeafMetaData getMetaData() {
        return this.metaData;
    }
}

