/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.JSONWriter;
import org.apache.solr.response.SolrQueryResponse;

public class CborResponseWriter
extends BinaryResponseWriter {
    final CBORFactory cborFactory;
    final CBORFactory cborFactoryCompact = CBORFactory.builder().enable(CBORGenerator.Feature.STRINGREF).build();

    public CborResponseWriter() {
        this.cborFactory = CBORFactory.builder().build();
    }

    @Override
    public void write(OutputStream out, SolrQueryRequest req, SolrQueryResponse response) throws IOException {
        boolean useStringRef = req.getParams().getBool("string_ref", true);
        WriterImpl writer = new WriterImpl(useStringRef ? this.cborFactoryCompact : this.cborFactory, out, req, response);
        writer.writeResponse();
        writer.gen.flush();
    }

    @Override
    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "application/octet-stream";
    }

    static class WriterImpl
    extends JSONWriter {
        final CBORGenerator gen;

        public WriterImpl(CBORFactory factory, OutputStream out, SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
            super(null, req, rsp);
            this.gen = factory.createGenerator(out);
        }

        @Override
        public void writeResponse() throws IOException {
            super.writeNamedList(null, this.rsp.getValues());
        }

        public void write(NamedList nl) throws IOException {
            super.writeNamedList(null, nl);
        }

        @Override
        public void writeNumber(String name, Number val) throws IOException {
            if (val instanceof Integer) {
                this.gen.writeNumber(val.intValue());
            } else if (val instanceof Long) {
                this.gen.writeNumber(val.longValue());
            } else if (val instanceof Float) {
                this.gen.writeNumber(val.floatValue());
            } else if (val instanceof Double) {
                this.gen.writeNumber(val.doubleValue());
            } else if (val instanceof Short) {
                this.gen.writeNumber(val.shortValue());
            } else if (val instanceof Byte) {
                this.gen.writeNumber((short)val.byteValue());
            } else if (val instanceof BigInteger) {
                this.gen.writeNumber((BigInteger)val);
            } else if (val instanceof BigDecimal) {
                this.gen.writeNumber((BigDecimal)val);
            } else {
                this.gen.writeString(val.getClass().getName() + ":" + val.toString());
            }
        }

        @Override
        public void writeBool(String name, Boolean val) throws IOException {
            this.gen.writeBoolean(val.booleanValue());
        }

        @Override
        public void writeNull(String name) throws IOException {
            this.gen.writeNull();
        }

        @Override
        public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
            this.gen.writeString(val);
        }

        @Override
        public void writeLong(String name, long val) throws IOException {
            this.gen.writeNumber(val);
        }

        @Override
        public void writeInt(String name, int val) throws IOException {
            this.gen.writeNumber(val);
        }

        @Override
        public void writeBool(String name, boolean val) throws IOException {
            this.gen.writeBoolean(val);
        }

        @Override
        public void writeFloat(String name, float val) throws IOException {
            this.gen.writeNumber(val);
        }

        @Override
        public void writeArrayCloser() throws IOException {
            this.gen.writeEndArray();
        }

        @Override
        public void writeArraySeparator() {
        }

        @Override
        public void writeArrayOpener(int size) throws IOException, IllegalArgumentException {
            this.gen.writeStartArray();
        }

        @Override
        public void writeMapCloser() throws IOException {
            this.gen.writeEndObject();
        }

        @Override
        public void writeKey(String fname, boolean needsEscaping) throws IOException {
            this.gen.writeFieldName(fname);
        }

        @Override
        public void writeMapOpener(int size) throws IOException, IllegalArgumentException {
            this.gen.writeStartObject();
        }

        @Override
        public void writeByteArr(String name, byte[] buf, int offset, int len) throws IOException {
            this.gen.writeBinary(buf, offset, len);
        }

        @Override
        public void writeMapSeparator() throws IOException {
        }

        @Override
        public void indent() throws IOException {
        }

        @Override
        public void indent(int lev) throws IOException {
        }

        @Override
        public int incLevel() {
            return 0;
        }

        @Override
        public int decLevel() {
            return 0;
        }
    }
}

