/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.solr.common.PushWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.JSONResponseWriter;
import org.apache.solr.response.JSONWriter;
import org.apache.solr.response.SolrQueryResponse;

public class JacksonJsonWriter
extends BinaryResponseWriter {
    protected final JsonFactory jsonfactory = new JsonFactory();
    protected static final DefaultPrettyPrinter pretty = new DefaultPrettyPrinter().withoutSpacesInObjectEntries().withArrayIndenter((DefaultPrettyPrinter.Indenter)DefaultPrettyPrinter.NopIndenter.instance).withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter().withLinefeed("\n"));

    @Override
    public void write(OutputStream out, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        WriterImpl sw = new WriterImpl(this.jsonfactory, out, request, response);
        sw.writeResponse();
        sw.close();
    }

    public PushWriter getWriter(OutputStream out, SolrQueryRequest request, SolrQueryResponse response) {
        return new WriterImpl(this.jsonfactory, out, request, response);
    }

    @Override
    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return JSONResponseWriter.CONTENT_TYPE_JSON_UTF8;
    }

    public static class WriterImpl
    extends JSONWriter {
        protected JsonGenerator gen;

        public WriterImpl(JsonFactory j, OutputStream out, SolrQueryRequest req, SolrQueryResponse rsp) {
            super(null, req, rsp);
            try {
                this.gen = j.createGenerator(out, JsonEncoding.UTF8);
                if (this.doIndent) {
                    this.gen.setPrettyPrinter((PrettyPrinter)pretty.createInstance());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void writeResponse() throws IOException {
            if (this.wrapperFunction != null) {
                this.writeStr(null, this.wrapperFunction + "(", false);
            }
            super.writeNamedList(null, this.rsp.getValues());
            if (this.wrapperFunction != null) {
                this.writeStr(null, ")", false);
            }
            this.gen.close();
        }

        @Override
        public void writeNumber(String name, Number val) throws IOException {
            if (val instanceof Integer) {
                this.gen.writeNumber(val.intValue());
            } else if (val instanceof Long) {
                this.gen.writeNumber(val.longValue());
            } else if (val instanceof Float) {
                this.gen.writeNumber(val.floatValue());
            } else if (val instanceof Double) {
                this.gen.writeNumber(val.doubleValue());
            } else if (val instanceof Short) {
                this.gen.writeNumber(val.shortValue());
            } else if (val instanceof Byte) {
                this.gen.writeNumber((short)val.byteValue());
            } else if (val instanceof BigInteger) {
                this.gen.writeNumber((BigInteger)val);
            } else if (val instanceof BigDecimal) {
                this.gen.writeNumber((BigDecimal)val);
            } else {
                this.gen.writeString(val.getClass().getName() + ":" + val.toString());
            }
        }

        @Override
        public void writeBool(String name, Boolean val) throws IOException {
            this.gen.writeBoolean(val.booleanValue());
        }

        @Override
        public void writeNull(String name) throws IOException {
            this.gen.writeNull();
        }

        @Override
        public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
            if (needsEscaping) {
                this.gen.writeString(val);
            } else {
                this.gen.writeRawValue(val);
            }
        }

        @Override
        public void writeLong(String name, long val) throws IOException {
            this.gen.writeNumber(val);
        }

        @Override
        public void writeInt(String name, int val) throws IOException {
            this.gen.writeNumber(val);
        }

        @Override
        public void writeBool(String name, boolean val) throws IOException {
            this.gen.writeBoolean(val);
        }

        @Override
        public void writeFloat(String name, float val) throws IOException {
            this.gen.writeNumber(val);
        }

        @Override
        public void writeArrayCloser() throws IOException {
            this.gen.writeEndArray();
        }

        @Override
        public void writeArraySeparator() {
        }

        @Override
        public void writeArrayOpener(int size) throws IOException, IllegalArgumentException {
            this.gen.writeStartArray();
        }

        @Override
        public void writeMapCloser() throws IOException {
            this.gen.writeEndObject();
        }

        @Override
        public void writeMapSeparator() {
        }

        @Override
        public void writeMapOpener(int size) throws IOException, IllegalArgumentException {
            this.gen.writeStartObject();
        }

        @Override
        public void writeKey(String fname, boolean needsEscaping) throws IOException {
            this.gen.writeFieldName(fname);
        }

        @Override
        public void writeByteArr(String name, byte[] buf, int offset, int len) throws IOException {
            this.gen.writeBinary(buf, offset, len);
        }

        @Override
        public void setLevel(int level) {
        }

        @Override
        public int level() {
            return 0;
        }

        @Override
        public void indent() throws IOException {
        }

        @Override
        public void indent(int lev) throws IOException {
        }

        @Override
        public int incLevel() {
            return 0;
        }

        @Override
        public int decLevel() {
            return 0;
        }

        @Override
        public void close() throws IOException {
            this.gen.close();
        }

        @Override
        public void writeStrRaw(String name, String val) throws IOException {
            this.gen.writeRawValue(val);
        }

        @Override
        public void writeDate(String name, String val) throws IOException {
            this.gen.writeString(val);
        }
    }
}

