/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.spatial.bbox.BBoxOverlapRatioValueSource;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.util.ShapeAreaValueSource;
import org.apache.solr.common.SolrException;
import org.apache.solr.legacy.BBoxStrategy;
import org.apache.solr.legacy.LegacyFieldType;
import org.apache.solr.schema.AbstractSpatialFieldType;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.locationtech.spatial4j.shape.Rectangle;

public class BBoxField
extends AbstractSpatialFieldType<BBoxStrategy>
implements SchemaAware {
    private static final String PARAM_QUERY_TARGET_PROPORTION = "queryTargetProportion";
    private static final String PARAM_MIN_SIDE_LENGTH = "minSideLength";
    private static final String OVERLAP_RATIO = "overlapRatio";
    private static final String AREA = "area";
    private static final String AREA2D = "area2D";
    private String numberTypeName;
    private String booleanTypeName = "boolean";
    private boolean storeSubFields = false;
    private IndexSchema schema;

    public BBoxField() {
        super(new HashSet<String>(Arrays.asList(OVERLAP_RATIO, AREA, AREA2D)));
    }

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        String v = args.remove("numberType");
        if (v == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The field type: " + this.typeName + " must specify the numberType attribute.");
        }
        this.numberTypeName = v;
        v = args.remove("booleanType");
        if (v != null) {
            this.booleanTypeName = v;
        }
        if ((v = args.remove("storeSubFields")) != null) {
            this.storeSubFields = Boolean.valueOf(v);
        }
    }

    @Override
    public void inform(IndexSchema schema) {
        this.schema = schema;
        FieldType numberType = schema.getFieldTypeByName(this.numberTypeName);
        FieldType booleanType = schema.getFieldTypeByName(this.booleanTypeName);
        if (numberType == null) {
            throw new RuntimeException("Cannot find number fieldType: " + this.numberTypeName);
        }
        if (booleanType == null) {
            throw new RuntimeException("Cannot find boolean fieldType: " + this.booleanTypeName);
        }
        if (!(booleanType instanceof BoolField)) {
            throw new RuntimeException("Must be a BoolField: " + booleanType);
        }
        if (numberType.getNumberType() != NumberType.DOUBLE) {
            throw new RuntimeException("Must be Double number type: " + numberType);
        }
        ArrayList<SchemaField> fields = new ArrayList<SchemaField>(schema.getFields().values());
        for (SchemaField sf : fields) {
            if (sf.getType() != this) continue;
            String name = sf.getName();
            this.registerSubFields(schema, name, numberType, booleanType);
        }
    }

    private void registerSubFields(IndexSchema schema, String name, FieldType numberType, FieldType booleanType) {
        this.register(schema, name + "__minX", numberType);
        this.register(schema, name + "__maxX", numberType);
        this.register(schema, name + "__minY", numberType);
        this.register(schema, name + "__maxY", numberType);
        this.register(schema, name + "__xdl", booleanType);
    }

    private void register(IndexSchema schema, String name, FieldType fieldType) {
        int props = fieldType.properties;
        props = this.storeSubFields ? (props |= 4) : (props &= 0xFFFFFFFB);
        SchemaField sf = new SchemaField(name, fieldType, props, null);
        schema.getFields().put(sf.getName(), sf);
    }

    @Override
    protected BBoxStrategy newSpatialStrategy(String fieldName) {
        SchemaField solrNumField;
        org.apache.lucene.document.FieldType luceneType;
        FieldType numberType = this.schema.getFieldTypeByName(this.numberTypeName);
        FieldType booleanType = this.schema.getFieldTypeByName(this.booleanTypeName);
        if (this.schema.isDynamicField(fieldName)) {
            this.registerSubFields(this.schema, fieldName, numberType, booleanType);
        }
        if (!((luceneType = (org.apache.lucene.document.FieldType)(solrNumField = new SchemaField("_", numberType)).createField(0.0).fieldType()) instanceof LegacyFieldType)) {
            luceneType = new org.apache.lucene.document.FieldType(luceneType);
        }
        luceneType.setStored(this.storeSubFields);
        if (solrNumField.hasDocValues()) {
            luceneType = luceneType instanceof LegacyFieldType ? new LegacyFieldType((LegacyFieldType)luceneType) : new org.apache.lucene.document.FieldType(luceneType);
            luceneType.setDocValuesType(DocValuesType.NUMERIC);
        }
        return new BBoxStrategy(this.ctx, fieldName, luceneType);
    }

    @Override
    protected DoubleValuesSource getValueSourceFromSpatialArgs(QParser parser, SchemaField field, SpatialArgs spatialArgs, String scoreParam, BBoxStrategy strategy) {
        if (scoreParam == null) {
            return null;
        }
        switch (scoreParam) {
            case "overlapRatio": {
                double queryTargetProportion = 0.25;
                String v = parser.getParam(PARAM_QUERY_TARGET_PROPORTION);
                if (v != null) {
                    queryTargetProportion = Double.parseDouble(v);
                }
                double minSideLength = 0.0;
                v = parser.getParam(PARAM_MIN_SIDE_LENGTH);
                if (v != null) {
                    minSideLength = Double.parseDouble(v);
                }
                return new BBoxOverlapRatioValueSource(strategy.makeShapeValueSource(), this.ctx.isGeo(), (Rectangle)spatialArgs.getShape(), queryTargetProportion, minSideLength);
            }
            case "area": {
                return new ShapeAreaValueSource(strategy.makeShapeValueSource(), this.ctx, this.ctx.isGeo(), this.distanceUnits.multiplierFromDegreesToThisUnit() * this.distanceUnits.multiplierFromDegreesToThisUnit());
            }
            case "area2D": {
                return new ShapeAreaValueSource(strategy.makeShapeValueSource(), this.ctx, false, this.distanceUnits.multiplierFromDegreesToThisUnit() * this.distanceUnits.multiplierFromDegreesToThisUnit());
            }
        }
        return super.getValueSourceFromSpatialArgs(parser, field, spatialArgs, scoreParam, strategy);
    }
}

