/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.Collection;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DoubleFieldSource;
import org.apache.lucene.queries.function.valuesource.MultiValuedDoubleFieldSource;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.schema.DoubleValueFieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.PointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;

public class DoublePointField
extends PointField
implements DoubleValueFieldType {
    public DoublePointField() {
        this.type = NumberType.DOUBLE;
    }

    @Override
    public Object toNativeType(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof CharSequence) {
            return Double.parseDouble(val.toString());
        }
        return super.toNativeType(val);
    }

    @Override
    public Query getPointRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        double actualMax;
        double actualMin;
        if (min == null) {
            actualMin = Double.NEGATIVE_INFINITY;
        } else {
            actualMin = DoublePointField.parseDoubleFromUser(field.getName(), min);
            if (!minInclusive) {
                if (actualMin == Double.POSITIVE_INFINITY) {
                    return new MatchNoDocsQuery();
                }
                actualMin = DoublePoint.nextUp(actualMin);
            }
        }
        if (max == null) {
            actualMax = Double.POSITIVE_INFINITY;
        } else {
            actualMax = DoublePointField.parseDoubleFromUser(field.getName(), max);
            if (!maxInclusive) {
                if (actualMax == Double.NEGATIVE_INFINITY) {
                    return new MatchNoDocsQuery();
                }
                actualMax = DoublePoint.nextDown(actualMax);
            }
        }
        return DoublePoint.newRangeQuery(field.getName(), actualMin, actualMax);
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return DoublePoint.decodeDimension(term.bytes, term.offset);
    }

    @Override
    public Object toObject(IndexableField f) {
        Number val = f.numericValue();
        if (val != null) {
            if (!f.fieldType().stored() && f.fieldType().docValuesType() == DocValuesType.NUMERIC) {
                return Double.longBitsToDouble(val.longValue());
            }
            if (!f.fieldType().stored() && f.fieldType().docValuesType() == DocValuesType.SORTED_NUMERIC) {
                return NumericUtils.sortableLongToDouble(val.longValue());
            }
            return val;
        }
        throw new AssertionError((Object)("Unexpected state. Field: '" + f + "'"));
    }

    @Override
    protected Query getExactQuery(SchemaField field, String externalVal) {
        return DoublePoint.newExactQuery(field.getName(), DoublePointField.parseDoubleFromUser(field.getName(), externalVal));
    }

    @Override
    public Query getSetQuery(QParser parser, SchemaField field, Collection<String> externalVal) {
        assert (externalVal.size() > 0);
        if (!field.indexed()) {
            return super.getSetQuery(parser, field, externalVal);
        }
        double[] values = new double[externalVal.size()];
        int i = 0;
        for (String val : externalVal) {
            values[i] = DoublePointField.parseDoubleFromUser(field.getName(), val);
            ++i;
        }
        if (field.hasDocValues()) {
            return DoubleField.newSetQuery(field.getName(), values);
        }
        return DoublePoint.newSetQuery(field.getName(), values);
    }

    @Override
    protected String indexedToReadable(BytesRef indexedForm) {
        return Double.toString(DoublePoint.decodeDimension(indexedForm.bytes, indexedForm.offset));
    }

    @Override
    public void readableToIndexed(CharSequence val, BytesRefBuilder result) {
        result.grow(8);
        result.setLength(8);
        DoublePoint.encodeDimension(DoublePointField.parseDoubleFromUser(null, val.toString()), result.bytes(), 0);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return null;
        }
        return UninvertingReader.Type.DOUBLE_POINT;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource();
        return new DoubleFieldSource(field.getName());
    }

    @Override
    protected ValueSource getSingleValueSource(SortedNumericSelector.Type choice, SchemaField f) {
        return new MultiValuedDoubleFieldSource(f.getName(), choice);
    }

    @Override
    public IndexableField createField(SchemaField field, Object value) {
        double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
        return new DoublePoint(field.getName(), doubleValue);
    }

    @Override
    protected StoredField getStoredField(SchemaField sf, Object value) {
        return new StoredField(sf.getName(), (Double)this.toNativeType(value));
    }
}

