/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import net.jcip.annotations.NotThreadSafe;
import org.apache.solr.cloud.ZkConfigSetService;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ObjectCache;
import org.apache.solr.common.util.Pair;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.XmlConfigFile;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchemaFactory;
import org.apache.solr.util.DOMConfigNode;
import org.apache.solr.util.DataConfigNode;
import org.apache.solr.util.SystemIdResolver;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@NotThreadSafe
public abstract class IndexSchemaFactory
implements NamedListInitializedPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static volatile Consumer<String> CACHE_MISS_LISTENER = null;

    public static IndexSchema buildIndexSchema(String resourceName, SolrConfig config) {
        return IndexSchemaFactory.buildIndexSchema(resourceName, config, null);
    }

    public static IndexSchema buildIndexSchema(String resourceName, SolrConfig config, ConfigSetService configSetService) {
        return IndexSchemaFactory.newIndexSchemaFactory(config).create(resourceName, config, configSetService);
    }

    public static IndexSchemaFactory newIndexSchemaFactory(SolrConfig config) {
        IndexSchemaFactory factory;
        PluginInfo info = config.getPluginInfo(IndexSchemaFactory.class.getName());
        if (null != info) {
            factory = config.getResourceLoader().newInstance(info.className, IndexSchemaFactory.class);
            factory.init(info.initArgs);
        } else {
            factory = config.getResourceLoader().newInstance(ManagedIndexSchemaFactory.class.getName(), IndexSchemaFactory.class);
        }
        return factory;
    }

    public String getSchemaResourceName(String cdResourceName) {
        return cdResourceName;
    }

    public IndexSchema create(String resourceName, SolrConfig config, ConfigSetService configSetService) {
        SolrResourceLoader loader = config.getResourceLoader();
        if (null == resourceName) {
            resourceName = "schema.xml";
        }
        try {
            return new IndexSchema(resourceName, IndexSchemaFactory.getConfigResource(configSetService, null, loader, resourceName), config.luceneMatchVersion, loader, config.getSubstituteProperties());
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            String msg = "Error loading schema resource " + resourceName;
            log.error(msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
        }
    }

    public static ConfigSetService.ConfigResource getConfigResource(ConfigSetService configSetService, InputStream schemaInputStream, SolrResourceLoader loader, String name) {
        return () -> IndexSchemaFactory.getFromCache((String)name, (SolrResourceLoader)loader, (Supplier<ObjectCache>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getConfigResource$0(org.apache.solr.core.ConfigSetService ), ()Lorg/apache/solr/common/util/ObjectCache;)((ConfigSetService)configSetService), (Supplier<VersionedConfig>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getConfigResource$1(java.io.InputStream org.apache.solr.core.SolrResourceLoader java.lang.String ), ()Lorg/apache/solr/schema/IndexSchemaFactory$VersionedConfig;)((InputStream)schemaInputStream, (SolrResourceLoader)loader, (String)name)).data;
    }

    private static VersionedConfig loadConfig(InputStream schemaInputStream, SolrResourceLoader loader, String name) {
        VersionedConfig versionedConfig;
        block8: {
            InputStream is = schemaInputStream == null ? loader.openResource(name) : schemaInputStream;
            try {
                ConfigNode node = IndexSchemaFactory.getParsedSchema(is, loader, name);
                int version = is instanceof ZkSolrResourceLoader.ZkByteArrayInputStream ? ((ZkSolrResourceLoader.ZkByteArrayInputStream)is).getStat().getVersion() : 0;
                versionedConfig = new VersionedConfig(version, node);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error fetching schema", (Throwable)e);
                }
            }
            is.close();
        }
        return versionedConfig;
    }

    public static VersionedConfig getFromCache(String name, SolrResourceLoader loader, Supplier<ObjectCache> objectCacheSupplier, Supplier<VersionedConfig> c) {
        Supplier<VersionedConfig> cfgLoader;
        Consumer<String> listener = CACHE_MISS_LISTENER;
        Supplier<VersionedConfig> supplier = cfgLoader = listener == null ? c : () -> {
            listener.accept(name);
            return (VersionedConfig)c.get();
        };
        if (loader instanceof ZkSolrResourceLoader) {
            ZkSolrResourceLoader zkLoader = (ZkSolrResourceLoader)loader;
            ObjectCache objectCache = objectCacheSupplier.get();
            if (objectCache == null) {
                return cfgLoader.get();
            }
            Map confCache = (Map)objectCache.computeIfAbsent(ConfigSetService.ConfigResource.class.getName(), k -> new ConcurrentHashMap());
            Pair<String, Integer> res = zkLoader.getZkResourceInfo(name);
            if (res == null) {
                return cfgLoader.get();
            }
            VersionedConfig result = null;
            result = confCache.computeIfAbsent(res.first(), k -> (VersionedConfig)cfgLoader.get());
            if (result.version == res.second()) {
                return result;
            }
            confCache.remove(res.first());
            return confCache.computeIfAbsent(res.first(), k -> (VersionedConfig)cfgLoader.get());
        }
        return cfgLoader.get();
    }

    public static ConfigNode getParsedSchema(InputStream is, SolrResourceLoader loader, String name) throws IOException, SAXException, ParserConfigurationException {
        XmlConfigFile schemaConf = null;
        InputSource inputSource = new InputSource(is);
        inputSource.setSystemId(SystemIdResolver.createSystemIdFromResourceName(name));
        schemaConf = new XmlConfigFile(loader, "schema", inputSource, "/schema/", null);
        return new DataConfigNode(new DOMConfigNode(schemaConf.getDocument().getDocumentElement()));
    }

    private static /* synthetic */ VersionedConfig lambda$getConfigResource$1(InputStream schemaInputStream, SolrResourceLoader loader, String name) {
        return IndexSchemaFactory.loadConfig(schemaInputStream, loader, name);
    }

    private static /* synthetic */ ObjectCache lambda$getConfigResource$0(ConfigSetService configSetService) {
        if (!(configSetService instanceof ZkConfigSetService)) {
            return null;
        }
        return ((ZkConfigSetService)configSetService).getSolrCloudManager().getObjectCache();
    }

    public static class VersionedConfig {
        public final int version;
        public final ConfigNode data;

        public VersionedConfig(int version, ConfigNode data) {
            this.version = version;
            this.data = data;
        }
    }
}

