/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.AbstractSpatialFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

public class LatLonPointSpatialField
extends AbstractSpatialFieldType<LatLonPointSpatialStrategy>
implements SchemaAware {
    private IndexSchema schema;

    @Override
    protected void checkSupportsDocValues() {
    }

    @Override
    public void inform(IndexSchema schema) {
        this.schema = schema;
    }

    @Override
    protected LatLonPointSpatialStrategy newSpatialStrategy(String fieldName) {
        SchemaField schemaField = this.schema.getField(fieldName);
        return new LatLonPointSpatialStrategy(this.ctx, fieldName, schemaField.indexed(), schemaField.hasDocValues());
    }

    @Override
    public String toExternal(IndexableField f) {
        if (f.numericValue() != null) {
            return LatLonPointSpatialField.decodeDocValueToString(f.numericValue().longValue());
        }
        return super.toExternal(f);
    }

    public static String decodeDocValueToString(long value) {
        double latDouble = GeoEncodingUtils.decodeLatitude((int)(value >> 32));
        double lonDouble = GeoEncodingUtils.decodeLongitude((int)(value & 0xFFFFFFFFL));
        int DECIMAL_PLACES = 7;
        RoundingMode ROUND_MODE = RoundingMode.CEILING;
        BigDecimal latitudeDecoded = BigDecimal.valueOf(latDouble).setScale(7, ROUND_MODE);
        BigDecimal longitudeDecoded = BigDecimal.valueOf(lonDouble).setScale(7, ROUND_MODE);
        return latitudeDecoded.stripTrailingZeros().toPlainString() + "," + longitudeDecoded.stripTrailingZeros().toPlainString();
    }

    public static class LatLonPointSpatialStrategy
    extends SpatialStrategy {
        private final boolean indexed;
        private final boolean docValues;

        public LatLonPointSpatialStrategy(SpatialContext ctx, String fieldName, boolean indexed, boolean docValues) {
            super(ctx, fieldName);
            if (!ctx.isGeo()) {
                throw new IllegalArgumentException("ctx must be geo=true: " + ctx);
            }
            this.indexed = indexed;
            this.docValues = docValues;
        }

        @Override
        public Field[] createIndexableFields(Shape shape) {
            if (!(shape instanceof Point)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.getClass().getSimpleName() + " only supports indexing points; got: " + shape);
            }
            Point point = (Point)shape;
            int fieldsLen = (this.indexed ? 1 : 0) + (this.docValues ? 1 : 0);
            Field[] fields = new Field[fieldsLen];
            int fieldsIdx = 0;
            if (this.indexed) {
                fields[fieldsIdx++] = new LatLonPoint(this.getFieldName(), point.getY(), point.getX());
            }
            if (this.docValues) {
                fields[fieldsIdx++] = new LatLonDocValuesField(this.getFieldName(), point.getY(), point.getX());
            }
            return fields;
        }

        @Override
        public Query makeQuery(SpatialArgs args) {
            if (args.getOperation() != SpatialOperation.Intersects) {
                throw new UnsupportedSpatialOperation(args.getOperation());
            }
            Shape shape = args.getShape();
            if (this.indexed && this.docValues) {
                return new IndexOrDocValuesQuery(this.makeQueryFromIndex(shape), this.makeQueryFromDocValues(shape));
            }
            if (this.indexed) {
                return this.makeQueryFromIndex(shape);
            }
            if (this.docValues) {
                return this.makeQueryFromDocValues(shape);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.getFieldName() + " needs indexed (preferred) or docValues to support search");
        }

        protected Query makeQueryFromIndex(Shape shape) {
            if (shape instanceof Circle) {
                Circle circle = (Circle)shape;
                double radiusMeters = circle.getRadius() * 111.19507973436875 * 1000.0;
                return LatLonPoint.newDistanceQuery(this.getFieldName(), circle.getCenter().getY(), circle.getCenter().getX(), radiusMeters);
            }
            if (shape instanceof Rectangle) {
                Rectangle rect = (Rectangle)shape;
                return LatLonPoint.newBoxQuery(this.getFieldName(), rect.getMinY(), rect.getMaxY(), rect.getMinX(), rect.getMaxX());
            }
            if (shape instanceof Point) {
                Point point = (Point)shape;
                return LatLonPoint.newDistanceQuery(this.getFieldName(), point.getY(), point.getX(), 0.0);
            }
            throw new UnsupportedOperationException("Shape " + shape.getClass() + " is not supported by " + this.getClass());
        }

        protected Query makeQueryFromDocValues(Shape shape) {
            if (shape instanceof Circle) {
                Circle circle = (Circle)shape;
                double radiusMeters = circle.getRadius() * 111.19507973436875 * 1000.0;
                return LatLonDocValuesField.newSlowDistanceQuery(this.getFieldName(), circle.getCenter().getY(), circle.getCenter().getX(), radiusMeters);
            }
            if (shape instanceof Rectangle) {
                Rectangle rect = (Rectangle)shape;
                return LatLonDocValuesField.newSlowBoxQuery(this.getFieldName(), rect.getMinY(), rect.getMaxY(), rect.getMinX(), rect.getMaxX());
            }
            if (shape instanceof Point) {
                Point point = (Point)shape;
                return LatLonDocValuesField.newSlowDistanceQuery(this.getFieldName(), point.getY(), point.getX(), 0.0);
            }
            throw new UnsupportedOperationException("Shape " + shape.getClass() + " is not supported by " + this.getClass());
        }

        @Override
        public DoubleValuesSource makeDistanceValueSource(Point queryPoint, double multiplier) {
            if (!this.docValues) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, this.getFieldName() + " must have docValues enabled to support this feature");
            }
            return new DistanceSortValueSource(this.getFieldName(), queryPoint, 8.993203677616634E-6 * multiplier);
        }

        private static class DistanceSortValueSource
        extends DoubleValuesSource {
            private final String fieldName;
            private final Point queryPoint;
            private final double multiplier;

            DistanceSortValueSource(String fieldName, Point queryPoint, double multiplier) {
                this.fieldName = fieldName;
                this.queryPoint = queryPoint;
                this.multiplier = multiplier;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof DistanceSortValueSource)) {
                    return false;
                }
                DistanceSortValueSource that = (DistanceSortValueSource)o;
                return Double.compare(that.multiplier, this.multiplier) == 0 && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.queryPoint, that.queryPoint);
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.fieldName, this.queryPoint, this.multiplier);
            }

            @Override
            public DoubleValues getValues(final LeafReaderContext ctx, DoubleValues scores) throws IOException {
                return new DoubleValues(){
                    final FieldComparator<Double> comparator;
                    final LeafFieldComparator leafComparator;
                    final double mult;
                    double value;
                    {
                        this.comparator = this.getSortField(false).getComparator(1, Pruning.NONE);
                        this.leafComparator = this.comparator.getLeafComparator(ctx);
                        this.mult = multiplier;
                        this.value = Double.POSITIVE_INFINITY;
                    }

                    @Override
                    public double doubleValue() throws IOException {
                        return this.value;
                    }

                    @Override
                    public boolean advanceExact(int doc) throws IOException {
                        this.leafComparator.copy(0, doc);
                        this.value = this.comparator.value(0) * this.mult;
                        return true;
                    }
                };
            }

            @Override
            public boolean needsScores() {
                return false;
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, this.fieldName);
            }

            @Override
            public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
                return this;
            }

            @Override
            public String toString() {
                return "distSort(" + this.fieldName + ", " + this.queryPoint + ", mult:" + this.multiplier + ")";
            }

            @Override
            public SortField getSortField(boolean reverse) {
                if (reverse) {
                    return super.getSortField(true);
                }
                return LatLonDocValuesField.newDistanceSort(this.fieldName, this.queryPoint.getY(), this.queryPoint.getX());
            }
        }
    }
}

